/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.google.common.base.Preconditions;
import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.Realm;
import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicConfigFileAuthenticationProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimplePrivateKeySupplier;
import com.oracle.bmc.auth.internal.ConfigFileDelegationTokenUtils;
import com.oracle.bmc.auth.internal.DelegationTokenConfigurator;
import com.oracle.bmc.http.ClientConfigurator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileAuthenticationDetailsProvider
implements AuthenticationDetailsProvider,
RegionProvider,
ProvidesClientConfigurators {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFileAuthenticationDetailsProvider.class);
    private static final String OCI_REGION_ENV_VAR_NAME = "OCI_REGION";
    private final BasicConfigFileAuthenticationProvider delegate;
    private final Region region;
    private static final String CONFIG_FILE_DEBUG_INFORMATION_LOG = "\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm";

    public ConfigFileAuthenticationDetailsProvider(String profile) throws IOException {
        this(ConfigFileReader.parseDefault(profile));
    }

    public ConfigFileAuthenticationDetailsProvider(String configurationFilePath, String profile) throws IOException {
        this(ConfigFileReader.parse(configurationFilePath, profile));
    }

    public ConfigFileAuthenticationDetailsProvider(ConfigFileReader.ConfigFile configFile) {
        String authentication_type = configFile.get("authentication_type");
        this.delegate = authentication_type != null && authentication_type.equals("instance_principal") ? new ConfigFileInstancePrincipalAuthenticationDetailsProvider(configFile) : new ConfigFileSimpleAuthenticationDetailsProvider(configFile);
        this.region = ConfigFileAuthenticationDetailsProvider.getRegionFromConfigFile(configFile);
    }

    public static Region getRegionFromConfigFile(ConfigFileReader.ConfigFile configFile) {
        Region region = null;
        String regionId = configFile.get("region");
        if (StringUtils.isBlank((CharSequence)regionId)) {
            regionId = System.getenv(OCI_REGION_ENV_VAR_NAME);
            LOG.info("regionId from OCI_REGION env variable: " + regionId);
        }
        if (regionId != null) {
            try {
                region = Region.fromRegionId(regionId);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Found regionId '{}' in config file or OCI_REGION env variable, but not supported by this version of the SDK\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm", (Object)regionId, (Object)e);
                region = Region.register(regionId, Realm.OC1);
            }
        } else {
            LOG.info("Region not specified in Config file or OCI_REGION env variable. Proceeding without setting a region.");
        }
        return region;
    }

    @Override
    public String getFingerprint() {
        return this.delegate.getFingerprint();
    }

    @Override
    public String getTenantId() {
        return this.delegate.getTenantId();
    }

    @Override
    public String getUserId() {
        return this.delegate.getUserId();
    }

    @Override
    public List<ClientConfigurator> getClientConfigurators() {
        return this.delegate.getClientConfigurators();
    }

    @Override
    @Deprecated
    public String getPassPhrase() {
        return this.delegate.getPassPhrase();
    }

    @Override
    public char[] getPassphraseCharacters() {
        return this.delegate.getPassphraseCharacters();
    }

    @Override
    public InputStream getPrivateKey() {
        return this.delegate.getPrivateKey();
    }

    @Override
    public String getKeyId() {
        return this.delegate.getKeyId();
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public String getPemFilePath() {
        return this.delegate.getPemFilePath();
    }

    public String toString() {
        return "ConfigFileAuthenticationDetailsProvider(delegate=" + this.delegate + ", region=" + this.getRegion() + ")";
    }

    private static class ConfigFileInstancePrincipalAuthenticationDetailsProvider
    implements BasicConfigFileAuthenticationProvider {
        private final InstancePrincipalsAuthenticationDetailsProvider delegate = InstancePrincipalsAuthenticationDetailsProvider.builder().build();
        private final String tenantId;
        private final List<ClientConfigurator> clientConfigurators;

        private ConfigFileInstancePrincipalAuthenticationDetailsProvider(ConfigFileReader.ConfigFile configFile) {
            String tenantId = configFile.get("tenancy");
            if (tenantId == null) {
                tenantId = "";
            }
            this.tenantId = tenantId;
            this.clientConfigurators = new ArrayList<ClientConfigurator>();
            try {
                String delegationToken = ConfigFileDelegationTokenUtils.parseAndGetToken(configFile);
                if (!StringUtils.isBlank((CharSequence)delegationToken)) {
                    this.clientConfigurators.add(new DelegationTokenConfigurator(delegationToken));
                }
            }
            catch (Exception e) {
                LOG.debug("Could not load delegation token!");
            }
        }

        @Override
        public String getFingerprint() {
            return null;
        }

        @Override
        public String getTenantId() {
            return this.tenantId;
        }

        @Override
        public String getUserId() {
            return null;
        }

        @Override
        public String getKeyId() {
            return this.delegate.getKeyId();
        }

        @Override
        public InputStream getPrivateKey() {
            return this.delegate.getPrivateKey();
        }

        @Override
        public String getPassPhrase() {
            return null;
        }

        @Override
        public char[] getPassphraseCharacters() {
            return null;
        }

        @Override
        public String getPemFilePath() {
            return null;
        }

        @Override
        public List<ClientConfigurator> getClientConfigurators() {
            return this.clientConfigurators;
        }
    }

    private static class ConfigFileSimpleAuthenticationDetailsProvider
    implements BasicConfigFileAuthenticationProvider {
        private final SimpleAuthenticationDetailsProvider delegate;
        private final String pemFilePath;
        private final List<ClientConfigurator> clientConfigurators;

        private ConfigFileSimpleAuthenticationDetailsProvider(ConfigFileReader.ConfigFile configFile) {
            String fingerprint = (String)Preconditions.checkNotNull((Object)configFile.get("fingerprint"), (Object)"Missing fingerprint in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm");
            String tenantId = (String)Preconditions.checkNotNull((Object)configFile.get("tenancy"), (Object)"Missing tenancy in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm");
            String userId = (String)Preconditions.checkNotNull((Object)configFile.get("user"), (Object)"Missing user in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm");
            String pemFilePath = (String)Preconditions.checkNotNull((Object)configFile.get("key_file"), (Object)"Missing key_file in config.\nFor more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm");
            String passPhrase = configFile.get("pass_phrase");
            SimplePrivateKeySupplier privateKeySupplier = new SimplePrivateKeySupplier(pemFilePath);
            SimpleAuthenticationDetailsProvider.SimpleAuthenticationDetailsProviderBuilder builder = SimpleAuthenticationDetailsProvider.builder().privateKeySupplier(privateKeySupplier).fingerprint(fingerprint).userId(userId).tenantId(tenantId);
            if (passPhrase != null) {
                builder = builder.passphraseCharacters(passPhrase.toCharArray());
            }
            this.delegate = builder.build();
            this.pemFilePath = pemFilePath;
            this.clientConfigurators = new ArrayList<ClientConfigurator>();
        }

        @Override
        public String getFingerprint() {
            return this.delegate.getFingerprint();
        }

        @Override
        public String getTenantId() {
            return this.delegate.getTenantId();
        }

        @Override
        public String getUserId() {
            return this.delegate.getUserId();
        }

        @Override
        @Deprecated
        public String getPassPhrase() {
            return this.delegate.getPassPhrase();
        }

        @Override
        @Deprecated
        public char[] getPassphraseCharacters() {
            return this.delegate.getPassphraseCharacters();
        }

        @Override
        public InputStream getPrivateKey() {
            return this.delegate.getPrivateKey();
        }

        @Override
        public String getKeyId() {
            return this.delegate.getKeyId();
        }

        @Override
        public String getPemFilePath() {
            return this.pemFilePath;
        }

        @Override
        public List<ClientConfigurator> getClientConfigurators() {
            return this.clientConfigurators;
        }
    }
}

