/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractFederationClientAuthenticationDetailsProviderBuilder;
import com.oracle.bmc.auth.AbstractRequestingAuthenticationDetailsProvider;
import com.oracle.bmc.auth.AuthCachingPolicy;
import com.oracle.bmc.auth.ConfigurableRefreshOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesConfigurableRefresh;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.X509CertificateSupplier;
import com.oracle.bmc.auth.internal.DefaultRptPathProvider;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.FileBasedKeySupplier;
import com.oracle.bmc.auth.internal.FileBasedResourcePrincipalFederationClient;
import com.oracle.bmc.auth.internal.FixedContentKeySupplier;
import com.oracle.bmc.auth.internal.FixedContentResourcePrincipalFederationClient;
import com.oracle.bmc.auth.internal.ResourcePrincipalsFederationClient;
import com.oracle.bmc.auth.internal.RptPathProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.NameUtils;
import java.io.File;
import java.time.Duration;

@AuthCachingPolicy(cacheKeyId=false, cachePrivateKey=false)
public class ResourcePrincipalAuthenticationDetailsProvider
extends AbstractRequestingAuthenticationDetailsProvider
implements RegionProvider,
RefreshableOnNotAuthenticatedProvider<String>,
ConfigurableRefreshOnNotAuthenticatedProvider<String> {
    static final String OCI_RESOURCE_PRINCIPAL_VERSION = "OCI_RESOURCE_PRINCIPAL_VERSION";
    static final String RP_VERSION_2_2 = "2.2";
    static final String OCI_RESOURCE_PRINCIPAL_RPST = "OCI_RESOURCE_PRINCIPAL_RPST";
    static final String OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM = "OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM";
    static final String OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE = "OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE";
    static final String OCI_RESOURCE_PRINCIPAL_REGION_ENV_VAR_NAME = "OCI_RESOURCE_PRINCIPAL_REGION";
    private static final String RP_VERSION_1_1 = "1.1";
    private static final String OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT = "OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT";
    private static final String OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT = "OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT";
    private static final String RP_DEBUG_INFORMATION_LOG = "\nResource principals authentication can only be used in certain OCI services. Please check that the OCI service you're running this code from supports Resource principals.\nSee https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal for more info.";
    private final Region region;

    ResourcePrincipalAuthenticationDetailsProvider(FederationClient federationClient, SessionKeySupplier sessionKeySupplier, Region region) {
        super(federationClient, sessionKeySupplier);
        this.region = region;
    }

    public static ResourcePrincipalAuthenticationDetailsProviderBuilder builder() {
        return new ResourcePrincipalAuthenticationDetailsProviderBuilder();
    }

    public String getStringClaim(String key) {
        return this.federationClient.getStringClaim(key);
    }

    @Override
    public String refresh() {
        return this.federationClient.refreshAndGetSecurityToken();
    }

    @Override
    public String refreshIfExpiringWithin(Duration time) {
        if (this.federationClient instanceof ProvidesConfigurableRefresh) {
            return ((ProvidesConfigurableRefresh)((Object)this.federationClient)).refreshAndGetSecurityTokenIfExpiringWithin(time);
        }
        return this.federationClient.refreshAndGetSecurityToken();
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public static class ResourcePrincipalAuthenticationDetailsProviderBuilder
    extends AbstractFederationClientAuthenticationDetailsProviderBuilder<ResourcePrincipalAuthenticationDetailsProviderBuilder, ResourcePrincipalAuthenticationDetailsProvider> {
        private String resourcePrincipalTokenEndpoint;
        private RptPathProvider resourcePrincipalTokenPathProvider;
        private CircuitBreakerConfiguration circuitBreakerConfig;

        ResourcePrincipalAuthenticationDetailsProviderBuilder() {
        }

        public ResourcePrincipalAuthenticationDetailsProviderBuilder resourcePrincipalTokenPathProvider(RptPathProvider resourcePrincipalTokenPathProvider) {
            this.resourcePrincipalTokenPathProvider = resourcePrincipalTokenPathProvider;
            return this;
        }

        public ResourcePrincipalAuthenticationDetailsProviderBuilder resourcePrincipalTokenEndpoint(String resourcePrincipalTokenEndpoint) {
            this.resourcePrincipalTokenEndpoint = resourcePrincipalTokenEndpoint;
            return this;
        }

        public ResourcePrincipalAuthenticationDetailsProviderBuilder circuitBreakerConfig(CircuitBreakerConfiguration circuitBreakerConfig) {
            this.circuitBreakerConfig = circuitBreakerConfig;
            return this;
        }

        public ResourcePrincipalAuthenticationDetailsProviderBuilder resourcePrincipalTokenEndpoint(Service service, Region region) {
            Optional<String> endpoint = region.getEndpoint(service);
            if (endpoint.isPresent()) {
                return this.resourcePrincipalTokenEndpoint((String)endpoint.get());
            }
            return this.resourcePrincipalTokenEndpoint(null);
        }

        @Deprecated
        public ResourcePrincipalAuthenticationDetailsProviderBuilder resourcePrincipalSessionTokenEndpoint(String resourcePrincipalSessionTokenEndpoint) {
            return (ResourcePrincipalAuthenticationDetailsProviderBuilder)super.federationEndpoint(resourcePrincipalSessionTokenEndpoint);
        }

        @Override
        public ResourcePrincipalAuthenticationDetailsProviderBuilder leafCertificateSupplier(X509CertificateSupplier leafCertificateSupplier) {
            return (ResourcePrincipalAuthenticationDetailsProviderBuilder)super.leafCertificateSupplier(leafCertificateSupplier);
        }

        @Override
        public ResourcePrincipalAuthenticationDetailsProvider build() {
            String ociResourcePrincipalVersion = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_VERSION);
            if (ociResourcePrincipalVersion == null) {
                throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_VERSION environment variable missing");
            }
            switch (ociResourcePrincipalVersion) {
                case "2.2": {
                    String ociResourcePrincipalPrivateKey = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM);
                    String ociResourcePrincipalPassphrase = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE);
                    String ociResourcePrincipalRPST = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPST);
                    String ociResourcePrincipalRegion = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_REGION_ENV_VAR_NAME);
                    String inputType = "environment variable";
                    return ResourcePrincipalAuthenticationDetailsProviderBuilder.build_2_2(ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase, ociResourcePrincipalRPST, ociResourcePrincipalRegion, "environment variable");
                }
                case "1.1": {
                    String ociResourcePrincipalRptEndpoint = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT);
                    String ociResourcePrincipalRpstEndpoint = System.getenv(ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT);
                    return this.build_1_1(ociResourcePrincipalRptEndpoint, ociResourcePrincipalRpstEndpoint);
                }
            }
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_VERSION has unknown value.\nResource principals authentication can only be used in certain OCI services. Please check that the OCI service you're running this code from supports Resource principals.\nSee https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal for more info.");
        }

        public static ResourcePrincipalAuthenticationDetailsProvider build_2_2(String ociResourcePrincipalPrivateKey, String ociResourcePrincipalPassphrase, String ociResourcePrincipalRPST, String ociResourcePrincipalRegion, String inputType) {
            SessionKeySupplier sessionKeySupplier;
            if (ociResourcePrincipalPrivateKey == null) {
                throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM " + inputType + " missing." + ResourcePrincipalAuthenticationDetailsProvider.RP_DEBUG_INFORMATION_LOG);
            }
            if (new File(ociResourcePrincipalPrivateKey).isAbsolute()) {
                if (ociResourcePrincipalPassphrase != null && !new File(ociResourcePrincipalPassphrase).isAbsolute()) {
                    throw new IllegalArgumentException("Cannot mix path and constant settings for OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM " + ociResourcePrincipalPrivateKey + " and " + ResourcePrincipalAuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE + " " + ociResourcePrincipalPassphrase + ResourcePrincipalAuthenticationDetailsProvider.RP_DEBUG_INFORMATION_LOG);
                }
                sessionKeySupplier = new FileBasedKeySupplier(ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase);
            } else {
                char[] passPhraseChars = ociResourcePrincipalPassphrase != null ? ociResourcePrincipalPassphrase.toCharArray() : null;
                sessionKeySupplier = new FixedContentKeySupplier(ociResourcePrincipalPrivateKey, passPhraseChars);
            }
            if (ociResourcePrincipalRPST == null) {
                throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_RPST " + inputType + " missing." + ResourcePrincipalAuthenticationDetailsProvider.RP_DEBUG_INFORMATION_LOG);
            }
            FederationClient federationClient = new File(ociResourcePrincipalRPST).isAbsolute() ? new FileBasedResourcePrincipalFederationClient(sessionKeySupplier, ociResourcePrincipalRPST) : new FixedContentResourcePrincipalFederationClient(ociResourcePrincipalRPST, sessionKeySupplier);
            if (ociResourcePrincipalRegion == null) {
                throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_REGION " + inputType + " missing." + ResourcePrincipalAuthenticationDetailsProvider.RP_DEBUG_INFORMATION_LOG);
            }
            Region region = Region.valueOf(NameUtils.canonicalizeForEnumTypes(ociResourcePrincipalRegion));
            return new ResourcePrincipalAuthenticationDetailsProvider(federationClient, sessionKeySupplier, region);
        }

        private ResourcePrincipalAuthenticationDetailsProvider build_1_1(String ociResourcePrincipalRptEndpoint, String ociResourcePrincipalRpstEndpoint) {
            this.resourcePrincipalTokenEndpoint = ociResourcePrincipalRptEndpoint;
            this.federationEndpoint = ociResourcePrincipalRpstEndpoint != null ? ociResourcePrincipalRpstEndpoint : this.autoDetectEndpointUsingMetadataUrl();
            this.sessionKeySupplier = new AbstractFederationClientAuthenticationDetailsProviderBuilder.SessionKeySupplierImpl();
            this.federationClient = this.createFederationClient(this.sessionKeySupplier);
            return this.buildProvider(this.sessionKeySupplier);
        }

        @Override
        protected FederationClient createFederationClient(SessionKeySupplier sessionKeySupplier) {
            Preconditions.checkNotNull((Object)this.resourcePrincipalTokenEndpoint);
            if (this.resourcePrincipalTokenPathProvider == null) {
                this.resourcePrincipalTokenPathProvider = new DefaultRptPathProvider();
            }
            InstancePrincipalsAuthenticationDetailsProvider provider = ((InstancePrincipalsAuthenticationDetailsProvider.InstancePrincipalsAuthenticationDetailsProviderBuilder)((InstancePrincipalsAuthenticationDetailsProvider.InstancePrincipalsAuthenticationDetailsProviderBuilder)InstancePrincipalsAuthenticationDetailsProvider.builder().federationEndpoint(this.federationEndpoint).leafCertificateSupplier(this.leafCertificateSupplier).intermediateCertificateSuppliers(this.intermediateCertificateSuppliers)).circuitBreakerConfigurator(this.circuitBreakerConfig != null ? this.circuitBreakerConfig : CircuitBreakerUtils.getDefaultCircuitBreakerConfig())).build();
            return new ResourcePrincipalsFederationClient(this.resourcePrincipalTokenEndpoint, this.resourcePrincipalTokenPathProvider, this.federationEndpoint, sessionKeySupplier, provider, this.federationClientConfigurator, this.circuitBreakerConfig);
        }

        @Override
        protected ResourcePrincipalAuthenticationDetailsProvider buildProvider(SessionKeySupplier sessionKeySupplierToUse) {
            return new ResourcePrincipalAuthenticationDetailsProvider(this.federationClient, sessionKeySupplierToUse, this.region);
        }
    }

    public static class ClaimKeys {
        public static final String COMPARTMENT_ID_CLAIM_KEY = "res_compartment";
        public static final String TENANT_ID_CLAIM_KEY = "res_tenant";
    }
}

