/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HttpDateUtils;
import com.oracle.bmc.model.Range;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

public class HeaderUtils {
    public static Optional<List<String>> get(MultivaluedMap<String, String> headers, String name) {
        if (headers == null) {
            return Optional.absent();
        }
        String lowerCaseHeaderName = name.toLowerCase(Locale.ROOT);
        for (Map.Entry entry : headers.entrySet()) {
            if (!((String)entry.getKey()).toLowerCase(Locale.ROOT).equals(lowerCaseHeaderName)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.absent();
    }

    public static <T> T toValue(String headerName, String value, Class<T> clazz) {
        if (clazz == String.class) {
            return (T)value;
        }
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (clazz == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (clazz == Date.class) {
            return (T)HttpDateUtils.parse(headerName, value);
        }
        if (clazz == Range.class) {
            return (T)Range.parse(value);
        }
        if (clazz == BigDecimal.class) {
            return (T)new BigDecimal(value);
        }
        if (clazz.isEnum()) {
            try {
                return clazz.cast(clazz.getDeclaredMethod("create", String.class).invoke(null, value));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Could not create enum '" + clazz.getName() + "', value '" + value + "'", e);
            }
        }
        throw new IllegalArgumentException("Unknown header type: " + clazz);
    }
}

