/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.project.classpath;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.project.classpath.ProjectClassPathModifierAccessor;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.java.project.classpath.ProjectModulesModifier;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class ProjectClassPathModifier {
    private static final Logger LOG = Logger.getLogger(ProjectClassPathModifier.class.getName());

    private ProjectClassPathModifier() {
    }

    public static boolean addLibraries(Library[] libraries, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            boolean r1 = ProjectClassPathModifierAccessor.INSTANCE.addLibraries(libraries, extensible.pcmi, extensible.sg, extensible.classPathType);
            boolean r2 = !extensible.classPathType.equals(classPathType) && ProjectClassPathModifier.addRootsToModinfo(classPathType, projectArtifact, ProjectClassPathModifier.toURLs(libraries));
            return r1 || r2;
        }
        boolean result = false;
        for (Library library : libraries) {
            result |= extensible.pcpe.addLibrary(library);
        }
        return result;
    }

    public static boolean removeLibraries(Library[] libraries, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            boolean r1 = ProjectClassPathModifierAccessor.INSTANCE.removeLibraries(extensible.uniqueLibraries(libraries), extensible.pcmi, extensible.sg, extensible.classPathType);
            boolean r2 = !extensible.classPathType.equals(classPathType) && ProjectClassPathModifier.removeRootsFromModinfo(classPathType, projectArtifact, ProjectClassPathModifier.toURLs(libraries));
            return r1 || r2;
        }
        throw new UnsupportedOperationException("Cannot remove libraries using " + extensible);
    }

    public static boolean addRoots(URL[] classPathRoots, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Parameters.notNull((CharSequence)"classPathRoots", (Object)classPathRoots);
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            boolean r1 = ProjectClassPathModifierAccessor.INSTANCE.addRoots(classPathRoots, extensible.pcmi, extensible.sg, extensible.classPathType);
            boolean r2 = !extensible.classPathType.equals(classPathType) && ProjectClassPathModifier.addRootsToModinfo(classPathType, projectArtifact, Arrays.asList(classPathRoots));
            return r1 || r2;
        }
        boolean result = false;
        for (URL urlToAdd : classPathRoots) {
            FileObject fo;
            Parameters.notNull((CharSequence)"classPathRoots", (Object)urlToAdd);
            if ("jar".equals(urlToAdd.getProtocol())) {
                urlToAdd = FileUtil.getArchiveFile((URL)urlToAdd);
            }
            if ((fo = URLMapper.findFileObject((URL)urlToAdd)) == null) {
                throw new UnsupportedOperationException("Adding of a non existent root is not supported by project.");
            }
            result |= extensible.pcpe.addArchiveFile(fo);
        }
        return result;
    }

    public static boolean addRoots(URI[] classPathRoots, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            boolean r1 = ProjectClassPathModifierAccessor.INSTANCE.addRoots(classPathRoots, extensible.pcmi, extensible.sg, extensible.classPathType);
            boolean r2 = !extensible.classPathType.equals(classPathType) && ProjectClassPathModifier.addRootsToModinfo(classPathType, projectArtifact, ProjectClassPathModifier.toURLs(Arrays.asList(classPathRoots)));
            return r1 || r2;
        }
        boolean result = false;
        Project project = FileOwnerQuery.getOwner((FileObject)projectArtifact);
        File projectFolderFile = FileUtil.toFile((FileObject)project.getProjectDirectory());
        for (URI uri : classPathRoots) {
            FileObject fo;
            URI urlToAdd = LibrariesSupport.getArchiveFile((URI)uri);
            if (urlToAdd == null) {
                urlToAdd = uri;
            }
            if (urlToAdd.isAbsolute()) {
                fo = FileUtil.toFileObject((File)BaseUtilities.toFile((URI)urlToAdd));
            } else {
                File f = PropertyUtils.resolveFile((File)projectFolderFile, (String)LibrariesSupport.convertURIToFilePath((URI)urlToAdd));
                fo = FileUtil.toFileObject((File)f);
            }
            if (fo == null) {
                throw new UnsupportedOperationException("Adding of a non existent root is not supported by project.");
            }
            result |= extensible.pcpe.addArchiveFile(fo);
        }
        return result;
    }

    public static boolean removeRoots(URL[] classPathRoots, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            boolean r1 = ProjectClassPathModifierAccessor.INSTANCE.removeRoots(extensible.uniqueLocations(classPathRoots), extensible.pcmi, extensible.sg, extensible.classPathType);
            boolean r2 = !extensible.classPathType.equals(classPathType) && ProjectClassPathModifier.removeRootsFromModinfo(classPathType, projectArtifact, Arrays.asList(classPathRoots));
            return r1 || r2;
        }
        throw new UnsupportedOperationException("Cannot remove roots from " + extensible);
    }

    public static boolean removeRoots(URI[] classPathRoots, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            return ProjectClassPathModifierAccessor.INSTANCE.removeRoots(classPathRoots, extensible.pcmi, extensible.sg, extensible.classPathType);
        }
        throw new UnsupportedOperationException("Cannot remove roots from " + extensible);
    }

    public static boolean addAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        assert (artifacts.length == artifactElements.length);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            boolean r1 = ProjectClassPathModifierAccessor.INSTANCE.addAntArtifacts(artifacts, artifactElements, extensible.pcmi, extensible.sg, extensible.classPathType);
            boolean r2 = !extensible.classPathType.equals(classPathType) && ProjectClassPathModifier.addRootsToModinfo(classPathType, projectArtifact, ProjectClassPathModifier.toURLs(Arrays.asList(artifactElements)));
            return r1 || r2;
        }
        boolean result = false;
        for (int i = 0; i < artifacts.length; ++i) {
            result |= extensible.pcpe.addAntArtifact(artifacts[i], artifactElements[i]);
        }
        return result;
    }

    public static boolean addProjects(Project[] projects, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            boolean r1 = ProjectClassPathModifierAccessor.INSTANCE.addProjects(projects, extensible.pcmi, extensible.sg, extensible.classPathType);
            boolean r2 = !extensible.classPathType.equals(classPathType) && ProjectClassPathModifier.addRootsToModinfo(classPathType, projectArtifact, ProjectClassPathModifier.toURLs(projects));
            return r1 || r2;
        }
        throw new UnsupportedOperationException("Cannot add project as dependency. Missing ProjectClassPathModifierImplementation service in project type.");
    }

    public static boolean removeAntArtifacts(AntArtifact[] artifacts, URI[] artifactElements, FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        Extensible extensible = ProjectClassPathModifier.findExtensible(projectArtifact, classPathType);
        if (extensible.pcmi != null) {
            assert (extensible.sg != null);
            assert (extensible.classPathType != null);
            boolean r1 = ProjectClassPathModifierAccessor.INSTANCE.removeAntArtifacts(artifacts, artifactElements, extensible.pcmi, extensible.sg, extensible.classPathType);
            boolean r2 = !extensible.classPathType.equals(classPathType) && ProjectClassPathModifier.removeRootsFromModinfo(classPathType, projectArtifact, ProjectClassPathModifier.toURLs(Arrays.asList(artifactElements)));
            return r1 || r2;
        }
        throw new UnsupportedOperationException("Cannot remove artifacts from " + extensible);
    }

    private static Extensible findExtensible(FileObject projectArtifact, String classPathType) throws UnsupportedOperationException {
        String _classPathType;
        assert (projectArtifact != null);
        assert (classPathType != null);
        Project project = FileOwnerQuery.getOwner((FileObject)projectArtifact);
        if (project == null) {
            throw new UnsupportedOperationException("No project found to correspond to " + FileUtil.getFileDisplayName((FileObject)projectArtifact));
        }
        ProjectClassPathModifierImplementation pm = (ProjectClassPathModifierImplementation)project.getLookup().lookup(ProjectClassPathModifierImplementation.class);
        ProjectModulesModifier pmm = (ProjectModulesModifier)Lookup.getDefault().lookup(ProjectModulesModifier.class);
        String substModulePath = pmm == null ? null : pmm.provideModularClasspath(projectArtifact, classPathType);
        String string = _classPathType = substModulePath == null ? classPathType : substModulePath;
        if (pm != null) {
            SourceGroup[] sgs = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleSourceGroups(pm);
            assert (sgs != null) : "Class: " + pm.getClass() + " returned null as source groups.";
            for (SourceGroup sg : sgs) {
                if (projectArtifact != sg.getRootFolder() && !FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)projectArtifact) || !sg.contains(projectArtifact)) continue;
                String[] types = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleClassPathTypes(pm, sg);
                assert (types != null) : "Class: " + pm.getClass() + " returned null as classpath types.";
                boolean originalFound = false;
                for (String type : types) {
                    if (_classPathType.equals(type)) {
                        String label = "ProjectClassPathModifierImplementation for " + _classPathType + " on " + FileUtil.getFileDisplayName((FileObject)sg.getRootFolder());
                        return new Extensible(project, pm, sg, type, label);
                    }
                    if (!classPathType.equals(type)) continue;
                    originalFound = true;
                }
                if (!originalFound) continue;
                String label = "ProjectClassPathModifierImplementation for " + classPathType + " on " + FileUtil.getFileDisplayName((FileObject)sg.getRootFolder());
                return new Extensible(project, pm, sg, classPathType, label);
            }
            throw new UnsupportedOperationException("Project in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) + " of " + project.getClass() + " has a ProjectClassPathModifierImplementation but it will not handle " + _classPathType + " for " + FileUtil.getFileDisplayName((FileObject)projectArtifact) + " extensible source groups: " + ProjectClassPathModifier.sourceGroupsToString(sgs));
        }
        ProjectClassPathExtender pe = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
        if (pe != null) {
            if (_classPathType.equals("classpath/compile")) {
                return new Extensible(project, pe, "ProjectClassPathExtender for " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()));
            }
            throw new UnsupportedOperationException("Project in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) + " of " + project.getClass() + " has a ProjectClassPathExtender in its lookup but no ProjectClassPathModifierImplementation to handle " + _classPathType);
        }
        throw new UnsupportedOperationException("Project in " + FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory()) + " of " + project.getClass() + " has neither a ProjectClassPathModifierImplementation nor a ProjectClassPathExtender in its lookup");
    }

    private static String sourceGroupsToString(SourceGroup[] sgs) {
        StringBuilder sb = new StringBuilder();
        for (SourceGroup sg : sgs) {
            if (sb.length() != 0) {
                sb.append(':');
            }
            sb.append(FileUtil.getFileDisplayName((FileObject)sg.getRootFolder()));
        }
        return sb.toString();
    }

    public static ProjectClassPathExtender extenderForModifier(final ProjectClassPathModifierImplementation pcpmi) {
        return new ProjectClassPathExtender(){

            @Override
            public boolean addLibrary(Library library) throws IOException {
                SourceGroup[] sgs = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleSourceGroups(pcpmi);
                if (sgs.length == 0) {
                    return false;
                }
                String[] types = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleClassPathTypes(pcpmi, sgs[0]);
                if (types.length == 0) {
                    return false;
                }
                try {
                    return ProjectClassPathModifierAccessor.INSTANCE.addLibraries(new Library[]{library}, pcpmi, sgs[0], types[0]);
                }
                catch (UnsupportedOperationException x) {
                    return false;
                }
            }

            @Override
            public boolean addArchiveFile(FileObject archiveFile) throws IOException {
                SourceGroup[] sgs = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleSourceGroups(pcpmi);
                if (sgs.length == 0) {
                    return false;
                }
                String[] types = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleClassPathTypes(pcpmi, sgs[0]);
                if (types.length == 0) {
                    return false;
                }
                URL r = archiveFile.getURL();
                if (FileUtil.isArchiveFile((URL)r)) {
                    r = FileUtil.getArchiveRoot((URL)r);
                }
                try {
                    return ProjectClassPathModifierAccessor.INSTANCE.addRoots(new URL[]{r}, pcpmi, sgs[0], types[0]);
                }
                catch (UnsupportedOperationException x) {
                    return false;
                }
            }

            @Override
            public boolean addAntArtifact(AntArtifact artifact, URI artifactElement) throws IOException {
                SourceGroup[] sgs = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleSourceGroups(pcpmi);
                if (sgs.length == 0) {
                    return false;
                }
                String[] types = ProjectClassPathModifierAccessor.INSTANCE.getExtensibleClassPathTypes(pcpmi, sgs[0]);
                if (types.length == 0) {
                    return false;
                }
                try {
                    return ProjectClassPathModifierAccessor.INSTANCE.addAntArtifacts(new AntArtifact[]{artifact}, new URI[]{artifactElement}, pcpmi, sgs[0], types[0]);
                }
                catch (UnsupportedOperationException x) {
                    return false;
                }
            }
        };
    }

    public static ProjectClassPathExtender extenderForModifier(final Project p) {
        return new ProjectClassPathExtender(){

            @Override
            public boolean addLibrary(Library library) throws IOException {
                ProjectClassPathModifierImplementation pcpmi = (ProjectClassPathModifierImplementation)p.getLookup().lookup(ProjectClassPathModifierImplementation.class);
                return pcpmi != null ? ProjectClassPathModifier.extenderForModifier(pcpmi).addLibrary(library) : false;
            }

            @Override
            public boolean addArchiveFile(FileObject archiveFile) throws IOException {
                ProjectClassPathModifierImplementation pcpmi = (ProjectClassPathModifierImplementation)p.getLookup().lookup(ProjectClassPathModifierImplementation.class);
                return pcpmi != null ? ProjectClassPathModifier.extenderForModifier(pcpmi).addArchiveFile(archiveFile) : false;
            }

            @Override
            public boolean addAntArtifact(AntArtifact artifact, URI artifactElement) throws IOException {
                ProjectClassPathModifierImplementation pcpmi = (ProjectClassPathModifierImplementation)p.getLookup().lookup(ProjectClassPathModifierImplementation.class);
                return pcpmi != null ? ProjectClassPathModifier.extenderForModifier(pcpmi).addAntArtifact(artifact, artifactElement) : false;
            }
        };
    }

    private static Collection<URL> toURLs(Collection<URI> libs) {
        URL[] urls = new URL[libs.size()];
        int index = 0;
        for (URI u : libs) {
            try {
                urls[index++] = u.toURL();
            }
            catch (MalformedURLException ex) {
                return Collections.emptyList();
            }
        }
        return Arrays.asList(urls);
    }

    private static Collection<URL> toURLs(Project[] prjs) {
        return ProjectClassPathModifier.toURLs(Arrays.asList(prjs).stream().flatMap(prj -> Arrays.asList(AntArtifactQuery.findArtifactsByType((Project)prj, (String)"jar")).stream()).flatMap(a -> Arrays.asList(a.getArtifactLocations()).stream()).collect(Collectors.toList()));
    }

    private static Collection<URL> toURLs(Library[] libraries) {
        return Arrays.stream(libraries).flatMap(l -> l.getContent("classpath").stream()).collect(Collectors.toList());
    }

    private static boolean removeRootsFromModinfo(String originalPathType, FileObject artifact, Collection<URL> libs) {
        ProjectModulesModifier pmm = (ProjectModulesModifier)Lookup.getDefault().lookup(ProjectModulesModifier.class);
        if (pmm == null) {
            return false;
        }
        try {
            return pmm.removeRequiredModules(originalPathType, artifact, libs);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not remove module requires", ex);
            return false;
        }
    }

    private static boolean addRootsToModinfo(String originalPathType, FileObject artifact, Collection<URL> libs) {
        ProjectModulesModifier pmm = (ProjectModulesModifier)Lookup.getDefault().lookup(ProjectModulesModifier.class);
        if (pmm == null) {
            return false;
        }
        try {
            return pmm.addRequiredModules(originalPathType, artifact, libs);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not declare module requires", ex);
            return false;
        }
    }

    private static final class Extensible {
        private final Project project;
        private final String classPathType;
        private final SourceGroup sg;
        private final ProjectClassPathModifierImplementation pcmi;
        private final ProjectClassPathExtender pcpe;
        private final String label;

        private Extensible(Project project, ProjectClassPathModifierImplementation pcmi, SourceGroup sg, String classPathType, String label) {
            assert (pcmi != null);
            assert (sg != null);
            assert (classPathType != null);
            this.project = project;
            this.pcmi = pcmi;
            this.sg = sg;
            this.classPathType = classPathType;
            this.pcpe = null;
            this.label = label;
        }

        private Extensible(Project project, ProjectClassPathExtender pcpe, String label) {
            assert (pcpe != null);
            this.project = project;
            this.pcpe = pcpe;
            this.pcmi = null;
            this.sg = null;
            this.classPathType = "classpath/compile";
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        URL[] uniqueLocations(URL[] locations) {
            ProjectModulesModifier pmm = (ProjectModulesModifier)Lookup.getDefault().lookup(ProjectModulesModifier.class);
            if (pmm == null) {
                return locations;
            }
            Map<URL, Collection<ClassPath>> usages = pmm.findModuleUsages(this.sg.getRootFolder(), Arrays.asList(locations));
            if (usages.isEmpty()) {
                return locations;
            }
            ClassPath myPath = ClassPath.getClassPath((FileObject)this.sg.getRootFolder(), (String)"classpath/source");
            return (URL[])usages.keySet().stream().filter(u -> ((Collection)usages.get(u)).size() == 1 && Arrays.equals(((ClassPath)((Collection)usages.get(u)).iterator().next()).getRoots(), myPath.getRoots())).toArray(URL[]::new);
        }

        Library[] uniqueLibraries(Library[] libraries) {
            HashMap libraryMap = new HashMap();
            URL[] locations = (URL[])Arrays.stream(libraries).flatMap(l -> l.getContent("classpath").stream().map(x -> {
                libraryMap.put(x, l);
                return x;
            })).toArray(URL[]::new);
            return (Library[])Arrays.stream(this.uniqueLocations(locations)).map(u -> (Library)libraryMap.get(u)).distinct().toArray(Library[]::new);
        }
    }
}

