/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.netserver.SocketFramework;
import org.netbeans.modules.netserver.websocket.AbstractWSHandler;
import org.netbeans.modules.netserver.websocket.WebSocketChanelHandler;
import org.netbeans.modules.netserver.websocket.WebSocketServerImpl;

abstract class AbstractWSHandler7<T extends SocketFramework>
extends AbstractWSHandler<T>
implements WebSocketChanelHandler {
    protected static final String SALT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    protected static final byte FINISH_BYTE = Integer.valueOf("10000000", 2).byteValue();
    protected static final byte CONT_BYTE = Integer.valueOf("00000000", 2).byteValue();
    protected static final byte FIRST_BYTE_MESSAGE = Integer.valueOf("10000001", 2).byteValue();
    protected static final byte FIRST_CONT_BYTE_MESSAGE = Integer.valueOf("00000001", 2).byteValue();
    protected static final byte CLOSE_CONNECTION_BYTE = Integer.valueOf("10001000", 2).byteValue();
    protected static final byte FIRST_BYTE_BINARY = Integer.valueOf("10000010", 2).byteValue();
    protected static final byte FIRST_CONT_BYTE_BINARY = Integer.valueOf("00000010", 2).byteValue();
    protected static final int LENGTH_LEVEL = 65536;
    private static final Logger LOGGER = Logger.getLogger(AbstractWSHandler7.class.getName());
    private final AtomicReference<byte[]> readData = new AtomicReference();
    private final AtomicInteger prevFrameType = new AtomicInteger();
    private Random myRandom = new Random(this.hashCode());

    AbstractWSHandler7(T t) {
        super(t);
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws IOException {
        SocketChannel socketChannel = (SocketChannel)this.getKey().channel();
        while (true) {
            byteBuffer.clear();
            byteBuffer.limit(1);
            int size = socketChannel.read(byteBuffer);
            if (size == -1) {
                this.close();
                return;
            }
            if (size == 0) {
                return;
            }
            byteBuffer.flip();
            byte leadingByte = byteBuffer.get();
            if (leadingByte == CLOSE_CONNECTION_BYTE) {
                this.close();
                return;
            }
            if (leadingByte == FIRST_BYTE_MESSAGE || leadingByte == FIRST_BYTE_BINARY) {
                this.prevFrameType.set(0);
                this.readData.set(null);
                if (this.readFinalFrame(byteBuffer, socketChannel, leadingByte)) continue;
                return;
            }
            if (leadingByte == FIRST_CONT_BYTE_MESSAGE || leadingByte == FIRST_CONT_BYTE_BINARY || leadingByte == CONT_BYTE) {
                if (leadingByte == FIRST_CONT_BYTE_MESSAGE) {
                    this.prevFrameType.set(1);
                } else if (leadingByte == FIRST_CONT_BYTE_BINARY) {
                    this.prevFrameType.set(2);
                }
                byte[] data = this.readFrame(byteBuffer, socketChannel, this.prevFrameType.get());
                byte[] current = this.readData.get();
                if (current == null) {
                    this.readData.set(data);
                    continue;
                }
                byte[] newData = new byte[current.length + data.length];
                System.arraycopy(current, 0, newData, 0, current.length);
                System.arraycopy(data, 0, newData, current.length, data.length);
                this.readData.set(newData);
                continue;
            }
            if (leadingByte == FINISH_BYTE) {
                byte[] current = this.readData.get();
                int currentFrameType = this.prevFrameType.get();
                byte[] data = this.readFrame(byteBuffer, socketChannel, currentFrameType);
                if (current == null) {
                    LOGGER.log(Level.INFO, "The previous data has been null");
                    if (data != null) {
                        this.readDelegate(data, currentFrameType);
                    }
                } else {
                    byte[] newData = new byte[current.length + data.length];
                    System.arraycopy(current, 0, newData, 0, current.length);
                    System.arraycopy(data, 0, newData, current.length, data.length);
                    this.readDelegate(newData, currentFrameType);
                }
                this.prevFrameType.set(0);
                this.readData.set(null);
                continue;
            }
            this.prevFrameType.set(0);
            this.readData.set(null);
            LOGGER.log(Level.INFO, "Unhandled frame {0}", leadingByte);
        }
    }

    @Override
    public byte[] createTextFrame(String message) {
        int startBytesCount;
        byte[] lengthBytes;
        byte[] data = message.getBytes(Charset.forName("UTF-8"));
        int length = data.length;
        if (length < 126) {
            lengthBytes = new byte[]{(byte)length};
        } else if (length < 65536) {
            lengthBytes = new byte[]{126, (byte)(length >> 8), (byte)(length & 0xFF)};
        } else {
            lengthBytes = new byte[9];
            lengthBytes[0] = 127;
            for (int i = 8; i >= 1; --i) {
                lengthBytes[i] = (byte)(length & 0xFF);
                length >>= 8;
            }
        }
        if (this.isClient()) {
            startBytesCount = 5;
            lengthBytes[0] = (byte)(lengthBytes[0] | 0x80);
        } else {
            startBytesCount = 1;
        }
        byte[] result = new byte[data.length + lengthBytes.length + startBytesCount];
        result[0] = FIRST_BYTE_MESSAGE;
        System.arraycopy(lengthBytes, 0, result, 1, lengthBytes.length);
        System.arraycopy(data, 0, result, lengthBytes.length + startBytesCount, data.length);
        return result;
    }

    protected byte[] mask(byte[] maskedMessage, boolean hasMask) {
        if (hasMask) {
            byte[] result = new byte[maskedMessage.length - 4];
            for (int i = 4; i < maskedMessage.length; ++i) {
                byte unsignedMask = (byte)(maskedMessage[i % 4] & 0xFF);
                result[i - 4] = (byte)(unsignedMask ^ maskedMessage[i]);
            }
            return result;
        }
        return maskedMessage;
    }

    protected String generateAcceptKey(String key) {
        StringBuilder builder = new StringBuilder(key);
        builder.append(SALT);
        try {
            return Base64.getEncoder().encodeToString(MessageDigest.getInstance("SHA").digest(builder.toString().getBytes(Charset.forName("UTF-8"))));
        }
        catch (NoSuchAlgorithmException e) {
            WebSocketServerImpl.LOG.log(Level.WARNING, null, e);
            return null;
        }
    }

    protected Random getRandom() {
        return this.myRandom;
    }

    private boolean readFinalFrame(ByteBuffer byteBuffer, SocketChannel socketChannel, byte leadingByte) throws IOException {
        boolean hasMask;
        int size;
        int frameType = leadingByte == FIRST_BYTE_MESSAGE ? 1 : 2;
        byteBuffer.clear();
        byteBuffer.limit(1);
        do {
            if ((size = socketChannel.read(byteBuffer)) != -1) continue;
            this.close();
            return false;
        } while (size == 0 && !this.isStopped());
        if (this.isStopped()) {
            this.close();
            return false;
        }
        byteBuffer.flip();
        byte masknLength = byteBuffer.get();
        boolean bl = hasMask = masknLength < 0;
        if (!this.verifyMask(hasMask)) {
            this.close();
            return false;
        }
        int length = masknLength & 0x7F;
        if (length < 126) {
            return this.readData(byteBuffer, socketChannel, frameType, length, hasMask);
        }
        if (length == 126) {
            byteBuffer.clear();
            byteBuffer.limit(2);
            do {
                if ((size = socketChannel.read(byteBuffer)) != -1) continue;
                this.close();
                return false;
            } while (byteBuffer.position() < byteBuffer.limit() && !this.isStopped());
            if (this.isStopped()) {
                this.close();
                return false;
            }
            byteBuffer.flip();
            length = byteBuffer.getShort() & 0xFFFF;
            return this.readData(byteBuffer, socketChannel, frameType, length, hasMask);
        }
        if (length == 127) {
            byteBuffer.clear();
            byteBuffer.limit(8);
            do {
                if ((size = socketChannel.read(byteBuffer)) != -1) continue;
                this.close();
                return false;
            } while (byteBuffer.position() < byteBuffer.limit() && !this.isStopped());
            if (this.isStopped()) {
                this.close();
                return false;
            }
            byteBuffer.flip();
            long longLength = byteBuffer.getLong();
            return this.readData(byteBuffer, socketChannel, frameType, longLength, hasMask);
        }
        return true;
    }

    private byte[] readFrame(ByteBuffer byteBuffer, SocketChannel socketChannel, int frameType) throws IOException {
        boolean hasMask;
        int size;
        byteBuffer.clear();
        byteBuffer.limit(1);
        do {
            if ((size = socketChannel.read(byteBuffer)) != -1) continue;
            this.close();
            return null;
        } while (size == 0 && !this.isStopped());
        if (this.isStopped()) {
            this.close();
            return null;
        }
        byteBuffer.flip();
        byte masknLength = byteBuffer.get();
        boolean bl = hasMask = masknLength < 0;
        if (!this.verifyMask(hasMask)) {
            this.close();
            return null;
        }
        int length = masknLength & 0x7F;
        if (length < 126) {
            return this.readFrameData(byteBuffer, socketChannel, frameType, length, hasMask);
        }
        if (length == 126) {
            byteBuffer.clear();
            byteBuffer.limit(2);
            do {
                if ((size = socketChannel.read(byteBuffer)) != -1) continue;
                this.close();
                return null;
            } while (byteBuffer.position() < byteBuffer.limit() && !this.isStopped());
            if (this.isStopped()) {
                this.close();
                return null;
            }
            byteBuffer.flip();
            length = byteBuffer.getShort() & 0xFFFF;
            return this.readFrameData(byteBuffer, socketChannel, frameType, length, hasMask);
        }
        assert (length == 127) : length;
        byteBuffer.clear();
        byteBuffer.limit(8);
        do {
            if ((size = socketChannel.read(byteBuffer)) != -1) continue;
            this.close();
            return null;
        } while (byteBuffer.position() < byteBuffer.limit() && !this.isStopped());
        if (this.isStopped()) {
            this.close();
            return null;
        }
        byteBuffer.flip();
        long longLength = byteBuffer.getLong();
        return this.readFrameDataCheck(byteBuffer, socketChannel, frameType, longLength, hasMask);
    }

    private boolean readData(ByteBuffer byteBuffer, SocketChannel socketChannel, int frameType, int length, boolean hasMask) throws IOException {
        byte[] result;
        int frameSize;
        byteBuffer.clear();
        int n = frameSize = hasMask ? length + 4 : length;
        if (frameSize < 0) {
            this.readData(byteBuffer, socketChannel, frameType, (long)length, hasMask);
        }
        if ((result = this.readData(byteBuffer, socketChannel, frameSize)) == null) {
            return false;
        }
        this.readDelegate(this.mask(result, hasMask), frameType);
        return true;
    }

    private byte[] readFrameData(ByteBuffer byteBuffer, SocketChannel socketChannel, int frameType, int length, boolean hasMask) throws IOException {
        int frameSize;
        byteBuffer.clear();
        int n = frameSize = hasMask ? length + 4 : length;
        if (frameSize < 0) {
            return this.readFrameDataCheck(byteBuffer, socketChannel, frameType, length, hasMask);
        }
        byte[] result = this.mask(this.readData(byteBuffer, socketChannel, frameSize), hasMask);
        return result;
    }

    private byte[] readData(ByteBuffer byteBuffer, SocketChannel socketChannel, int size) throws IOException {
        int redBytes = 0;
        byte[] result = new byte[size];
        int fullBufferCount = 0;
        if (size < byteBuffer.capacity()) {
            byteBuffer.limit(size);
        }
        while (redBytes < size && !this.isStopped()) {
            int resultRed;
            int red = socketChannel.read(byteBuffer);
            if (red == -1) {
                this.close();
                return null;
            }
            if (red == 0 || (redBytes += red) % byteBuffer.capacity() != 0) continue;
            byteBuffer.flip();
            byteBuffer.get(result, fullBufferCount * byteBuffer.capacity(), byteBuffer.limit());
            byteBuffer.clear();
            if (size - (resultRed = ++fullBufferCount * byteBuffer.capacity()) > byteBuffer.capacity()) continue;
            byteBuffer.limit(size - resultRed);
        }
        if (this.isStopped()) {
            this.close();
            return null;
        }
        byteBuffer.flip();
        int savedBytes = byteBuffer.capacity() * fullBufferCount;
        byteBuffer.get(result, savedBytes, size - savedBytes);
        return result;
    }

    private boolean readData(ByteBuffer byteBuffer, SocketChannel socketChannel, int frameType, long length, boolean hasMask) throws IOException {
        int shift = (int)(length >> 32);
        if (shift != 0) {
            throw new RuntimeException("Data frame is too big. Cannot handle it. Implementation should be rewritten.");
        }
        this.readData(byteBuffer, socketChannel, frameType, (int)length, hasMask);
        return true;
    }

    private byte[] readFrameDataCheck(ByteBuffer byteBuffer, SocketChannel socketChannel, int frameType, long length, boolean hasMask) throws IOException {
        int shift = (int)(length >> 32);
        if (shift != 0) {
            throw new RuntimeException("Data frame is too big. Cannot handle it. Implementation should be rewritten.");
        }
        return this.readFrameData(byteBuffer, socketChannel, frameType, (int)length, hasMask);
    }

    protected abstract boolean isClient();

    protected abstract void readDelegate(byte[] var1, int var2);

    protected abstract boolean verifyMask(boolean var1) throws IOException;
}

