/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jgit.transport.RemoteConfig;

public final class GitRemoteConfig {
    private final List<String> uris;
    private final List<String> pushUris;
    private final List<String> fetchSpecs;
    private final List<String> pushSpecs;
    private final String remoteName;

    public GitRemoteConfig(String remoteName, List<String> uris, List<String> pushUris, List<String> fetchSpecs, List<String> pushSpecs) {
        this.remoteName = remoteName;
        this.uris = uris;
        this.pushUris = pushUris;
        this.fetchSpecs = fetchSpecs;
        this.pushSpecs = pushSpecs;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public List<String> getUris() {
        return Collections.unmodifiableList(this.uris);
    }

    public List<String> getPushUris() {
        return Collections.unmodifiableList(this.pushUris);
    }

    public List<String> getFetchRefSpecs() {
        return Collections.unmodifiableList(this.fetchSpecs);
    }

    public List<String> getPushRefSpecs() {
        return Collections.unmodifiableList(this.pushSpecs);
    }

    private static List<String> getAsStrings(List<? extends Object> list) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Object object : list) {
            set.add(object.toString());
        }
        return new ArrayList<String>(set);
    }

    static GitRemoteConfig fromRemoteConfig(RemoteConfig config) {
        return new GitRemoteConfig(config.getName(), GitRemoteConfig.getAsStrings(config.getURIs()), GitRemoteConfig.getAsStrings(config.getPushURIs()), GitRemoteConfig.getAsStrings(config.getFetchRefSpecs()), GitRemoteConfig.getAsStrings(config.getPushRefSpecs()));
    }
}

