/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2semodule;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.EventListener;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ScanUtils;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

final class MainClassUpdater
extends FileChangeAdapter
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor("main-class-updater", 1);
    private static final Logger LOG = Logger.getLogger(MainClassUpdater.class.getName());
    private static final int NEW = 0;
    private static final int STARTED = 1;
    private static final int FINISHED = 2;
    private final Project project;
    private final PropertyEvaluator eval;
    private final UpdateHelper helper;
    private final SourceRoots sourceRoots;
    private final String mainClassPropName;
    private final AtomicInteger state;
    private FileObject currentFo;
    private DataObject currentDo;
    private FileChangeListener foListener;
    private PropertyChangeListener doListener;
    private long lc = 0L;

    MainClassUpdater(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper helper, @NonNull SourceRoots sourceRoots, @NonNull String mainClassPropName) {
        assert (project != null);
        assert (eval != null);
        assert (helper != null);
        assert (sourceRoots != null);
        assert (mainClassPropName != null);
        this.project = project;
        this.eval = eval;
        this.helper = helper;
        this.sourceRoots = sourceRoots;
        this.mainClassPropName = mainClassPropName;
        this.state = new AtomicInteger(0);
    }

    void start() {
        RP.submit(() -> {
            if (!this.state.compareAndSet(0, 1)) {
                throw new IllegalStateException("Current State: " + this.state.get());
            }
            this.eval.addPropertyChangeListener((PropertyChangeListener)this);
            this.addFileChangeListener();
        });
    }

    public void stop() {
        RP.submit(() -> {
            if (this.state.compareAndSet(1, 2)) {
                MainClassUpdater mainClassUpdater = this;
                synchronized (mainClassUpdater) {
                    if (this.currentFo != null && this.foListener != null) {
                        this.currentFo.removeFileChangeListener(this.foListener);
                    }
                    if (this.currentDo != null && this.doListener != null) {
                        this.currentDo.removePropertyChangeListener(this.doListener);
                    }
                }
            } else {
                throw new IllegalStateException("Current State: " + this.state.get());
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("primaryFile".equals(evt.getPropertyName())) {
            FileObject newFile = (FileObject)evt.getNewValue();
            FileObject oldFile = (FileObject)evt.getOldValue();
            this.handleMainClassMoved(oldFile, newFile);
        } else if (this.mainClassPropName.equals(evt.getPropertyName())) {
            RP.post(this::addFileChangeListener);
        }
    }

    public void fileRenamed(FileRenameEvent evt) {
        this.handleMainClassMoved(evt.getFile(), evt.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMainClassMoved(FileObject oldFile, FileObject newFile) {
        FileObject _current;
        if (!this.project.getProjectDirectory().isValid()) {
            return;
        }
        MainClassUpdater mainClassUpdater = this;
        synchronized (mainClassUpdater) {
            _current = this.currentFo;
        }
        if (oldFile == _current) {
            Runnable r = () -> {
                try {
                    String oldMainClass = (String)ProjectManager.mutex().readAccess(() -> this.eval.getProperty(this.mainClassPropName));
                    Collection main = SourceUtils.getMainClasses((FileObject)newFile);
                    String newMainClass = null;
                    if (!main.isEmpty()) {
                        ElementHandle mainHandle = (ElementHandle)main.iterator().next();
                        newMainClass = mainHandle.getQualifiedName();
                    }
                    if (newMainClass != null && !newMainClass.equals(oldMainClass) && this.helper.requestUpdate() && this.eval.getProperty("config") == null) {
                        String newMainClassFinal = newMainClass;
                        ProjectManager.mutex().writeAccess(() -> {
                            EditableProperties props = this.helper.getProperties("nbproject/project.properties");
                            props.put(this.mainClassPropName, newMainClassFinal);
                            this.helper.putProperties("nbproject/project.properties", props);
                            ProjectManager.getDefault().saveProject(this.project);
                            return null;
                        });
                    }
                }
                catch (IOException | MutexException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileChangeListener() {
        FileObject[] roots;
        long clc;
        MainClassUpdater mainClassUpdater = this;
        synchronized (mainClassUpdater) {
            if (this.currentFo != null && this.foListener != null) {
                this.currentFo.removeFileChangeListener(this.foListener);
                this.foListener = null;
                this.currentFo = null;
            }
            if (this.currentDo != null && this.doListener != null) {
                this.currentDo.removePropertyChangeListener(this.doListener);
                this.doListener = null;
                this.currentDo = null;
            }
            clc = ++this.lc;
        }
        String mainClassName = this.eval.getProperty(this.mainClassPropName);
        if (mainClassName != null && (roots = this.sourceRoots.getRoots()).length > 0) {
            ClassPath bootCp = Optional.ofNullable(ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/boot")).orElse(JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries());
            ClassPath compileCp = Optional.ofNullable(ClassPath.getClassPath((FileObject)roots[0], (String)"classpath/compile")).orElse(ClassPath.EMPTY);
            ClassPath systemModules = ClassPath.getClassPath((FileObject)roots[0], (String)"modules/boot");
            ClassPath modulePath = ClassPath.getClassPath((FileObject)roots[0], (String)"modules/compile");
            ClassPath allUnnamed = ClassPath.getClassPath((FileObject)roots[0], (String)"modules/classpath");
            ClassPath moduleSourcePath = ClassPath.getClassPath((FileObject)roots[0], (String)"modules/source");
            ClasspathInfo cpInfo = new ClasspathInfo.Builder(bootCp).setClassPath(compileCp).setModuleBootPath(systemModules).setModuleCompilePath(modulePath).setModuleClassPath(allUnnamed).setModuleSourcePath(moduleSourcePath).build();
            JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
            ScanUtils.postUserActionTask((JavaSource)js, c -> {
                c.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement te = (TypeElement)ScanUtils.checkElement((CompilationInfo)c, (Element)c.getElements().getTypeElement(mainClassName));
                if (te != null) {
                    ClassPath allSources = ClassPathSupport.createClassPath((FileObject[])roots);
                    FileObject fo = SourceUtils.getFile((Element)te, (ClasspathInfo)new ClasspathInfo.Builder(bootCp).setClassPath(compileCp).setSourcePath(allSources).setModuleBootPath(systemModules).setModuleCompilePath(modulePath).setModuleClassPath(allUnnamed).setModuleSourcePath(moduleSourcePath).build());
                    boolean owned = allSources.contains(fo);
                    MainClassUpdater mainClassUpdater = this;
                    synchronized (mainClassUpdater) {
                        if (this.lc == clc && fo != null && owned) {
                            this.currentFo = fo;
                            this.foListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this, (Object)this.currentFo);
                            this.currentFo.addFileChangeListener(this.foListener);
                            this.currentDo = DataObject.find((FileObject)this.currentFo);
                            this.doListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.currentDo);
                            this.currentDo.addPropertyChangeListener(this.doListener);
                        }
                    }
                }
            });
        }
    }
}

