/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.options;

import org.netbeans.modules.css.prep.less.LessExecutable;
import org.netbeans.modules.css.prep.sass.SassCli;
import org.netbeans.modules.css.prep.util.StringUtils;
import org.netbeans.modules.web.common.api.ValidationResult;

public final class CssPrepOptionsValidator {
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public CssPrepOptionsValidator validateSassPath(String sassPath, boolean allowEmpty) {
        if (allowEmpty && !StringUtils.hasText(sassPath)) {
            return this;
        }
        String warning = SassCli.validate(sassPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"sass.path", warning));
        }
        return this;
    }

    public CssPrepOptionsValidator validateLessPath(String lessPath, boolean allowEmpty) {
        if (allowEmpty && !StringUtils.hasText(lessPath)) {
            return this;
        }
        String warning = LessExecutable.validate(lessPath);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"less.path", warning));
        }
        return this;
    }
}

