/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CallableUtils {
    private CallableUtils() {
    }

    public static <T, R> Callable<R> andThen(Callable<T> callable, Function<T, R> resultHandler) {
        return () -> resultHandler.apply(callable.call());
    }

    public static <T, R> Callable<R> andThen(Callable<T> callable, BiFunction<T, Exception, R> handler) {
        return () -> {
            try {
                Object result = callable.call();
                return handler.apply(result, null);
            }
            catch (Exception exception) {
                return handler.apply(null, exception);
            }
        };
    }

    public static <T, R> Callable<R> andThen(Callable<T> callable, Function<T, R> resultHandler, Function<Exception, R> exceptionHandler) {
        return () -> {
            try {
                Object result = callable.call();
                return resultHandler.apply(result);
            }
            catch (Exception exception) {
                return exceptionHandler.apply(exception);
            }
        };
    }

    public static <T> Callable<T> recover(Callable<T> callable, Function<Exception, T> exceptionHandler) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                return exceptionHandler.apply(exception);
            }
        };
    }
}

