/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.util.MissingResourceException;
import java.util.jar.Manifest;
import org.netbeans.jemmy.JemmyProperties;

public class JellyVersion {
    private static boolean jemmyVersionChecked = false;

    public static void main(String[] argv) {
        System.out.println("Jellytools version : " + JellyVersion.getVersion() + " (Build " + JellyVersion.getBuild() + " on " + JellyVersion.getIDEVersion() + " and Jemmy " + JellyVersion.getJemmyVersion() + ")");
    }

    public static synchronized void checkJemmyVersion() {
        if (!jemmyVersionChecked) {
            jemmyVersionChecked = true;
            String jemmyVersion = null;
            try {
                jemmyVersion = JemmyProperties.getVersion();
            }
            catch (Exception e) {
                return;
            }
            String builtOnJemmyVersion = JellyVersion.getJemmyVersion();
            if (jemmyVersion.compareTo(builtOnJemmyVersion) < 0) {
                String line = "\n##############################################\n";
                String message = "Need to upgrade Jemmy to version: " + builtOnJemmyVersion + "\nCurrent Jemmy version: " + jemmyVersion;
                JemmyProperties.getCurrentOutput().printError(line + message + line);
            }
        }
    }

    private static Manifest getManifest() {
        String info = "org/netbeans/jellytools/version_info";
        try {
            return new Manifest(new JellyVersion().getClass().getClassLoader().getResourceAsStream(info));
        }
        catch (Exception e) {
            throw new MissingResourceException("Version info not available.", null, null);
        }
    }

    public static String getMajorVersion() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jellytools-MajorVersion");
    }

    public static String getMinorVersion() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jellytools-MinorVersion");
    }

    public static String getVersion() {
        return JellyVersion.getMajorVersion() + "." + JellyVersion.getMinorVersion();
    }

    public static String getBuild() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jellytools-Build");
    }

    public static String getIDEVersion() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jellytools-IDEVersion");
    }

    public static String getJemmyMajorVersion() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jemmy-MajorVersion");
    }

    public static String getJemmyMinorVersion() {
        return JellyVersion.getManifest().getMainAttributes().getValue("Jemmy-MinorVersion");
    }

    public static String getJemmyVersion() {
        return JellyVersion.getJemmyMajorVersion() + "." + JellyVersion.getJemmyMinorVersion();
    }
}

