/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.janitor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.netbeans.modules.janitor.Bundle;
import org.netbeans.modules.janitor.Janitor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JanitorOptionsPanel
extends JPanel {
    final SpinnerNumberModel spinnerModel;
    private JButton btRunNow;
    private JCheckBox cbAutoRemove;
    private JCheckBox cbEnabled;
    private JLabel lbRunNowInfo;
    private JLabel lbUnusedDays;
    private JSpinner spUnusedDays;

    public JanitorOptionsPanel() {
        this.initComponents();
        this.spinnerModel = new SpinnerNumberModel(Janitor.getUnusedDays(), 0, 1825, 1);
        this.spUnusedDays.setModel(this.spinnerModel);
    }

    void loadValues() {
        this.cbEnabled.setSelected(Janitor.isEnabled());
        this.cbAutoRemove.setSelected(Janitor.isAutoRemoveAbanconedCache());
        this.spinnerModel.setValue(Janitor.getUnusedDays());
        this.resetRunNow();
    }

    void saveValues() {
        Janitor.setEnabled(this.cbEnabled.isSelected());
        Janitor.setAutoRemoveAbanconedCache(this.cbAutoRemove.isSelected());
        Janitor.setUnusedDays(this.spinnerModel.getNumber().intValue());
        this.resetRunNow();
    }

    boolean isChanged() {
        boolean changed = false;
        changed |= this.cbEnabled.isSelected() != Janitor.isEnabled();
        changed |= this.cbAutoRemove.isSelected() != Janitor.isAutoRemoveAbanconedCache();
        changed |= this.spinnerModel.getNumber().intValue() != Janitor.getUnusedDays();
        return changed |= !this.btRunNow.isEnabled();
    }

    private void initComponents() {
        this.cbEnabled = new JCheckBox();
        this.lbUnusedDays = new JLabel();
        this.cbAutoRemove = new JCheckBox();
        this.spUnusedDays = new JSpinner();
        this.btRunNow = new JButton();
        this.lbRunNowInfo = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.cbEnabled, (String)NbBundle.getMessage(JanitorOptionsPanel.class, (String)"JanitorOptionsPanel.cbEnabled.text"));
        this.lbUnusedDays.setLabelFor(this.spUnusedDays);
        Mnemonics.setLocalizedText((JLabel)this.lbUnusedDays, (String)NbBundle.getMessage(JanitorOptionsPanel.class, (String)"JanitorOptionsPanel.lbUnusedDays.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAutoRemove, (String)NbBundle.getMessage(JanitorOptionsPanel.class, (String)"JanitorOptionsPanel.cbAutoRemove.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btRunNow, (String)NbBundle.getMessage(JanitorOptionsPanel.class, (String)"JanitorOptionsPanel.btRunNow.text"));
        this.btRunNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JanitorOptionsPanel.this.btRunNowActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btRunNow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbRunNowInfo, -1, -1, Short.MAX_VALUE)).addComponent(this.cbEnabled, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lbUnusedDays).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spUnusedDays, -2, -1, -2)).addComponent(this.cbAutoRemove)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cbEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAutoRemove).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbUnusedDays).addComponent(this.spUnusedDays, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.lbRunNowInfo)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btRunNow))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btRunNowActionPerformed(ActionEvent evt) {
        this.btRunNow.setEnabled(false);
        Janitor.runNow();
        this.lbRunNowInfo.setText(Bundle.lbRunNowInfo_Info());
    }

    private void resetRunNow() {
        this.btRunNow.setEnabled(true);
        this.lbRunNowInfo.setText(null);
    }
}

