/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.knockout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.inspect.webkit.knockout.Bundle;
import org.netbeans.modules.web.inspect.webkit.knockout.KnockoutChildFactory;
import org.netbeans.modules.web.inspect.webkit.knockout.unused.UnusedBindingsPanel;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.netbeans.swing.outline.Outline;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class KnockoutPanel
extends JPanel
implements ExplorerManager.Provider {
    private static final RequestProcessor RP = new RequestProcessor(KnockoutPanel.class);
    private final ExplorerManager manager = new ExplorerManager();
    private final WebKitPageModel pageModel;
    private OutlineView contextView;
    private JComponent bindingContextComponent;
    private Listener pageModelListener;
    private boolean knockoutFound;
    org.openide.nodes.Node selectedNode;
    private final UnusedBindingsPanel unusedBindingsPanel;
    private boolean bindingContextShown = true;
    private JToggleButton bindingContextButton;
    private JPanel contentPanel;
    private JPanel mainPanel;
    private JLabel messageLabel;
    private JToolBar toolBar;
    private ButtonGroup toolBarButtonGroup;
    private JToggleButton unusedBindingsButton;

    public KnockoutPanel(WebKitPageModel pageModel) {
        this.pageModel = pageModel;
        this.initContextView();
        this.initComponents();
        this.initToolBar();
        this.unusedBindingsPanel = new UnusedBindingsPanel();
        this.unusedBindingsPanel.setPageModel(pageModel);
        if (pageModel == null) {
            this.messageLabel.setText(Bundle.KnockoutPanel_messageLabel_noInspection());
            this.add(this.messageLabel);
        } else {
            this.pageModelListener = new Listener();
            pageModel.addPropertyChangeListener(this.pageModelListener);
            this.update(true);
        }
    }

    private void initContextView() {
        this.contextView = new OutlineView(Bundle.KnockoutPanel_contextView_name());
        this.contextView.setAllowedDragActions(0);
        this.contextView.setAllowedDropActions(0);
        this.contextView.setShowNodeIcons(false);
        this.contextView.addPropertyColumn("value", Bundle.KnockoutPanel_contextView_value());
        Outline outline = this.contextView.getOutline();
        outline.setRootVisible(false);
    }

    private void initToolBar() {
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        this.toolBar.setBorder(b);
        this.toolBar.setFocusable(true);
        String lafId = UIManager.getLookAndFeel().getID();
        if ("Windows".equals(lafId) && !KnockoutPanel.isXPTheme()) {
            this.toolBar.setRollover(true);
        } else if ("Aqua".equals(lafId)) {
            this.toolBar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.toolBar.setVisible(false);
    }

    private static boolean isXPTheme() {
        Boolean isXP = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return isXP == null ? false : isXP;
    }

    void dispose() {
        if (this.pageModelListener != null) {
            this.pageModel.removePropertyChangeListener(this.pageModelListener);
            this.pageModelListener = null;
        }
    }

    WebKitPageModel getPageModel() {
        return this.pageModel;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    final void update(final boolean documentUpdated) {
        JComponent componentToShow;
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KnockoutPanel.this.update(documentUpdated);
                }
            });
            return;
        }
        this.selectedNode = null;
        if (documentUpdated) {
            this.knockoutFound = false;
            this.unusedBindingsPanel.setKnockoutVersion(null);
        }
        if (this.knockoutFound) {
            List<org.openide.nodes.Node> selection = this.pageModel.getSelectedNodes();
            if (selection.isEmpty()) {
                this.messageLabel.setText(Bundle.KnockoutPanel_messageLabel_noSelection());
                this.bindingContextComponent = this.messageLabel;
            } else if (selection.size() > 1) {
                this.messageLabel.setText(Bundle.KnockoutPanel_messageLabel_noSingleSelection());
                this.bindingContextComponent = this.messageLabel;
            } else {
                this.selectedNode = selection.get(0);
                Node webKitNode = (Node)this.selectedNode.getLookup().lookup(Node.class);
                WebKitDebugging webKit = this.pageModel.getWebKit();
                AbstractNode rootNode = new AbstractNode(Children.create((ChildFactory)new KnockoutChildFactory(webKit, webKitNode), (boolean)true));
                this.getExplorerManager().setRootContext((org.openide.nodes.Node)rootNode);
                this.bindingContextComponent = this.contextView;
                this.expandDataNode();
            }
            if (this.bindingContextButton.isSelected()) {
                this.showInContentPanel(this.bindingContextComponent);
            }
            componentToShow = this.mainPanel;
        } else {
            this.messageLabel.setText(Bundle.KnockoutPanel_messageLabel_noKnockout());
            componentToShow = this.messageLabel;
        }
        if (componentToShow.getParent() == null) {
            this.removeAll();
            this.add(componentToShow);
        }
        this.revalidate();
        this.repaint();
    }

    void knockoutUsed(String koVersion) {
        this.knockoutFound = true;
        this.unusedBindingsPanel.setKnockoutVersion(koVersion);
        this.update(false);
    }

    boolean isKnockoutUsed() {
        return this.knockoutFound;
    }

    void showKnockoutContext() {
        this.bindingContextButton.doClick();
    }

    private void expandDataNode() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                for (final org.openide.nodes.Node node : KnockoutPanel.this.manager.getRootContext().getChildren().getNodes(true)) {
                    if (!"$data".equals(node.getName())) continue;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            KnockoutPanel.this.contextView.expandNode(node);
                        }
                    });
                }
            }
        });
    }

    void showInContentPanel(JComponent component) {
        this.contentPanel.removeAll();
        this.contentPanel.add(component);
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
    }

    Lookup.Provider createLookupProvider(ActionMap actionMap) {
        final Lookup bindingContextLookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)actionMap);
        final Lookup unusedBindingLookup = ExplorerUtils.createLookup((ExplorerManager)this.unusedBindingsPanel.getExplorerManager(), (ActionMap)actionMap);
        return new Lookup.Provider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Lookup getLookup() {
                KnockoutPanel knockoutPanel = KnockoutPanel.this;
                synchronized (knockoutPanel) {
                    return KnockoutPanel.this.bindingContextShown ? bindingContextLookup : unusedBindingLookup;
                }
            }
        };
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.toolBarButtonGroup = new ButtonGroup();
        this.mainPanel = new JPanel();
        this.toolBar = new JToolBar();
        this.bindingContextButton = new JToggleButton();
        this.unusedBindingsButton = new JToggleButton();
        this.contentPanel = new JPanel();
        this.messageLabel.setBackground(this.contextView.getViewport().getView().getBackground());
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setEnabled(false);
        this.messageLabel.setOpaque(true);
        this.mainPanel.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBarButtonGroup.add(this.bindingContextButton);
        this.bindingContextButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.bindingContextButton, (String)NbBundle.getMessage(KnockoutPanel.class, (String)"KnockoutPanel.bindingContextButton.text"));
        this.bindingContextButton.setFocusable(false);
        this.bindingContextButton.setHorizontalTextPosition(0);
        this.bindingContextButton.setVerticalTextPosition(3);
        this.bindingContextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KnockoutPanel.this.bindingContextButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.bindingContextButton);
        this.toolBarButtonGroup.add(this.unusedBindingsButton);
        Mnemonics.setLocalizedText((AbstractButton)this.unusedBindingsButton, (String)NbBundle.getMessage(KnockoutPanel.class, (String)"KnockoutPanel.unusedBindingsButton.text"));
        this.unusedBindingsButton.setFocusable(false);
        this.unusedBindingsButton.setHorizontalTextPosition(0);
        this.unusedBindingsButton.setVerticalTextPosition(3);
        this.unusedBindingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KnockoutPanel.this.unusedBindingsButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.unusedBindingsButton);
        this.mainPanel.add((Component)this.toolBar, "First");
        this.contentPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.contentPanel, "Center");
        this.setLayout(new BorderLayout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindingContextButtonActionPerformed(ActionEvent evt) {
        KnockoutPanel knockoutPanel = this;
        synchronized (knockoutPanel) {
            this.bindingContextShown = true;
        }
        this.showInContentPanel(this.bindingContextComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unusedBindingsButtonActionPerformed(ActionEvent evt) {
        KnockoutPanel knockoutPanel = this;
        synchronized (knockoutPanel) {
            this.bindingContextShown = false;
        }
        this.showInContentPanel(this.unusedBindingsPanel);
    }

    final class Listener
    implements PropertyChangeListener {
        Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("selectedNodes".equals(propName)) {
                KnockoutPanel.this.update(false);
            } else if ("document".equals(propName)) {
                KnockoutPanel.this.update(true);
            }
        }
    }
}

