/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.git.Git;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ModuleLifecycleManager
implements ErrorHandler,
EntityResolver {
    private static ModuleLifecycleManager instance;
    private static final String[] otherGitModules;

    private ModuleLifecycleManager() {
    }

    static ModuleLifecycleManager getInstance() {
        if (instance == null) {
            instance = new ModuleLifecycleManager();
        }
        return instance;
    }

    void disableOtherModules() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean notify = false;
                block17: for (int i = 0; i < otherGitModules.length; ++i) {
                    FileLock lock = null;
                    OutputStream os = null;
                    try {
                        String newModule = otherGitModules[i];
                        String newModuleXML = "Modules/" + newModule.replace('.', '-') + ".xml";
                        FileObject fo = FileUtil.getConfigFile((String)newModuleXML);
                        if (fo == null) continue;
                        Document document = ModuleLifecycleManager.this.readModuleDocument(fo);
                        NodeList list = document.getDocumentElement().getElementsByTagName("param");
                        int n = list.getLength();
                        for (int j = 0; j < n; ++j) {
                            Element node = (Element)list.item(j);
                            if (!"enabled".equals(node.getAttribute("name"))) continue;
                            Text text = (Text)node.getChildNodes().item(0);
                            String value = text.getNodeValue();
                            if (!"true".equals(value)) continue block17;
                            text.setNodeValue("false");
                            break;
                        }
                        notify = true;
                        lock = fo.lock();
                        os = fo.getOutputStream(lock);
                        XMLUtil.write((Document)document, (OutputStream)os, (String)"UTF-8");
                        continue;
                    }
                    catch (Exception e) {
                        Git.LOG.log(Level.WARNING, null, e);
                        continue;
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
                if (notify) {
                    JTextPane ballonDetails = this.getPane(NbBundle.getBundle(ModuleLifecycleManager.class).getString("MSG_Install_Warning"));
                    JTextPane popupDetails = this.getPane(NbBundle.getBundle(ModuleLifecycleManager.class).getString("MSG_Install_Warning"));
                    NotificationDisplayer.getDefault().notify(NbBundle.getMessage(ModuleLifecycleManager.class, (String)"MSG_Install_Warning_Title"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/git/resources/icons/info.png", (boolean)false), (JComponent)ballonDetails, (JComponent)popupDetails, NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.WARNING);
                }
            }

            private JTextPane getPane(String txt) {
                JTextPane bubble = new JTextPane();
                bubble.setOpaque(false);
                bubble.setEditable(false);
                if (UIManager.getLookAndFeel().getID().equals("Nimbus")) {
                    bubble.setBackground(new Color(0, 0, 0, 0));
                }
                bubble.setContentType("text/html");
                bubble.setText(txt);
                return bubble;
            }
        };
        RequestProcessor.getDefault().post(runnable);
    }

    private Document readModuleDocument(FileObject fo) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder parser = dbf.newDocumentBuilder();
        parser.setEntityResolver(this);
        parser.setErrorHandler(this);
        InputStream is = fo.getInputStream();
        Document document = parser.parse(is);
        is.close();
        return document;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    @Override
    public void error(SAXParseException exception) {
        Git.LOG.log(Level.INFO, null, exception);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        Git.LOG.log(Level.INFO, null, exception);
    }

    @Override
    public void warning(SAXParseException exception) {
        Git.LOG.log(Level.INFO, null, exception);
    }

    static {
        otherGitModules = new String[]{"org.nbgit"};
    }
}

