/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.nette2.options.Nette2Options;
import org.netbeans.modules.php.nette2.ui.wizards.NewNette2ProjectPanel;
import org.netbeans.modules.php.nette2.utils.FileUtils;
import org.netbeans.modules.php.spi.framework.PhpModuleExtender;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

class Nette2PhpModuleExtender
extends PhpModuleExtender {
    private NewNette2ProjectPanel netteProjectPanel;

    Nette2PhpModuleExtender() {
    }

    public void addChangeListener(ChangeListener listener) {
        this.getPanel().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getPanel().removeChangeListener(listener);
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        return this.getPanel().getErrorMessage();
    }

    public String getWarningMessage() {
        return null;
    }

    public Set<FileObject> extend(PhpModule phpModule) throws PhpModuleExtender.ExtendingException {
        HashSet<FileObject> result = new HashSet<FileObject>();
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory != null) {
            FileObject tempDir;
            FileObject bootstrap;
            String projectDirectory = sourceDirectory.getPath();
            FileUtils.copyDirectory(new File(Nette2Options.getInstance().getSandbox()), new File(projectDirectory));
            File netteLibsDirectory = new File(projectDirectory, "/libs/Nette");
            if (this.isValidNetteLibsDir(netteLibsDirectory) && this.getPanel().isCopyNetteCheckboxSelected()) {
                FileUtils.copyDirectory(new File(Nette2Options.getInstance().getNetteDirectory()), netteLibsDirectory);
            }
            if ((bootstrap = FileUtil.toFileObject((File)new File(projectDirectory, "app/bootstrap.php"))) != null && !bootstrap.isFolder() && bootstrap.isValid()) {
                result.add(bootstrap);
            }
            if ((tempDir = sourceDirectory.getFileObject("/temp")) != null) {
                FileUtils.chmod777Recursively(tempDir);
            }
        }
        return result;
    }

    private boolean isValidNetteLibsDir(File netteLibsDirectory) {
        return !netteLibsDirectory.exists() || netteLibsDirectory.exists() && netteLibsDirectory.isDirectory() && netteLibsDirectory.list() == null;
    }

    private synchronized NewNette2ProjectPanel getPanel() {
        if (this.netteProjectPanel == null) {
            this.netteProjectPanel = new NewNette2ProjectPanel();
        }
        return this.netteProjectPanel;
    }
}

