/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.encoding;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public abstract class Encoder
extends CharsetEncoder {
    boolean reportMalformed = true;
    boolean reportUnmappable = true;

    protected Encoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar) {
        super(cs, averageBytesPerChar, maxBytesPerChar);
    }

    protected final void implOnMalformedInput(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("The argument must not be null.");
        }
        if (newAction == CodingErrorAction.IGNORE) {
            throw new IllegalArgumentException("The Encoding Standard does not allow errors to be ignored.");
        }
        if (newAction == CodingErrorAction.REPLACE) {
            this.reportMalformed = false;
            return;
        }
        if (newAction == CodingErrorAction.REPORT) {
            this.reportUnmappable = true;
            return;
        }
        assert (false) : "Unreachable.";
        throw new IllegalArgumentException("Unknown CodingErrorAction.");
    }

    protected final void implOnUnmappableCharacter(CodingErrorAction newAction) {
        if (newAction == null) {
            throw new IllegalArgumentException("The argument must not be null.");
        }
        if (newAction == CodingErrorAction.IGNORE) {
            throw new IllegalArgumentException("The Encoding Standard does not allow errors to be ignored.");
        }
        if (newAction == CodingErrorAction.REPLACE) {
            this.reportUnmappable = false;
            return;
        }
        if (newAction == CodingErrorAction.REPORT) {
            this.reportMalformed = true;
            return;
        }
        assert (false) : "Unreachable.";
        throw new IllegalArgumentException("Unknown CodingErrorAction.");
    }

    public boolean isLegalReplacement(byte[] repl) {
        if (repl == null) {
            return false;
        }
        if (repl.length != 1) {
            return false;
        }
        return repl[0] == 63;
    }

    protected final void implReplaceWith(byte[] newReplacement) {
    }
}

