/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.java.hints.introduce.TargetDescription;
import org.openide.awt.HtmlRenderer;

public class CommonMembersPanel
extends JPanel {
    private final Iterable<TargetDescription> targets;
    private JComboBox targetsComboBox;
    private JCheckBox duplicates;
    private TargetDescription targetDescriptionTest;

    public CommonMembersPanel(Iterable<TargetDescription> targets) {
        this.targets = targets;
    }

    protected final void initialize(JComboBox targetsComboBox, JCheckBox duplicates) {
        this.targetsComboBox = targetsComboBox;
        this.duplicates = duplicates;
        duplicates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommonMembersPanel.this.updateTargetsModel();
            }
        });
        this.updateTargetsModel();
    }

    private void updateTargetsModel() {
        Object originalSelected = this.targetsComboBox.getSelectedItem();
        DefaultComboBoxModel<TargetDescription> model = new DefaultComboBoxModel<TargetDescription>();
        int lastGood = -1;
        for (TargetDescription td : this.targets) {
            if (this.duplicates.isSelected() && !td.allowForDuplicates) continue;
            model.addElement(td);
            if (td.anonymous) continue;
            ++lastGood;
        }
        this.targetsComboBox.setModel(model);
        if (originalSelected != null) {
            this.targetsComboBox.setSelectedItem(originalSelected);
        } else if (lastGood >= 0) {
            this.targetsComboBox.setSelectedIndex(lastGood);
        } else if (model.getSize() > 0) {
            this.targetsComboBox.setSelectedIndex(0);
        }
        this.targetsComboBox.setEnabled(model.getSize() != 1);
    }

    public Iterable<TargetDescription> getTargets() {
        return this.targets;
    }

    public TargetDescription getSelectedTarget() {
        return this.targetDescriptionTest != null ? this.targetDescriptionTest : (TargetDescription)this.targetsComboBox.getSelectedItem();
    }

    void setTargetDescription(String classBinaryName) {
        for (TargetDescription td : this.targets) {
            if (!classBinaryName.equals(td.type.getBinaryName())) continue;
            this.targetDescriptionTest = td;
            return;
        }
        throw new IllegalStateException();
    }

    public static final class TargetsRendererImpl
    implements ListCellRenderer {
        private final HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof TargetDescription) {
                value = "<html>" + ((TargetDescription)value).displayName;
            }
            return this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

