/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.css.lib.api.FilterableError;
import org.netbeans.modules.javascript2.editor.parser.BaseParserResult;
import org.netbeans.modules.javascript2.editor.parser.JsErrorManager;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

public abstract class SanitizingParser<R extends BaseParserResult>
extends Parser {
    private static final Logger LOGGER = Logger.getLogger(SanitizingParser.class.getName());
    public static final boolean PARSE_BIG_FILES = Boolean.getBoolean("nb.js.parse.big.files");
    public static final long MAX_FILE_SIZE_TO_PARSE = Integer.getInteger("nb.js.big.file.size", 0x100000).intValue();
    private static final long MAX_MINIMIZE_FILE_SIZE_TO_PARSE = Integer.getInteger("nb.js.big.minimize.file.size", 0).intValue();
    private static final int MAX_RIGHT_CURLY_BRACKETS = 30;
    private final Language<JsTokenId> language;
    private final ChangeSupport listeners;
    private R lastResult = null;

    public SanitizingParser(Language<JsTokenId> language) {
        this.language = language;
        this.listeners = new ChangeSupport((Object)this);
    }

    public final void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, snapshot.getText().toString());
        }
        try {
            JsErrorManager errorManager = new JsErrorManager(snapshot, this.language);
            this.lastResult = this.parseSource(snapshot, event, this.getSanitizeStrategy(), errorManager);
            ((BaseParserResult)((Object)this.lastResult)).setErrors(errorManager.getErrors());
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Exception during parsing", ex);
            this.lastResult = this.createErrorResult(snapshot);
        }
    }

    protected abstract String getDefaultScriptName();

    @CheckForNull
    protected abstract R parseSource(Context var1, JsErrorManager var2) throws Exception;

    protected abstract String getMimeType();

    @NonNull
    protected abstract R createErrorResult(@NonNull Snapshot var1);

    protected Sanitize getSanitizeStrategy() {
        return Sanitize.NONE;
    }

    final R parseSource(Snapshot snapshot, SourceModificationEvent event, Sanitize sanitizing, JsErrorManager errorManager) throws Exception {
        FileObject fo = snapshot.getSource().getFileObject();
        long startTime = System.nanoTime();
        String scriptName = fo != null ? snapshot.getSource().getFileObject().getNameExt() : this.getDefaultScriptName();
        if (!this.isParsable(snapshot)) {
            return this.createErrorResult(snapshot);
        }
        int caretOffset = GsfUtilities.getLastKnownCaretOffset((Snapshot)snapshot, (EventObject)event);
        Context context = new Context(scriptName, snapshot, caretOffset, this.language);
        R result = this.parseContext(context, sanitizing, errorManager);
        if (!((BaseParserResult)((Object)result)).success() && context.isModule()) {
            context.isModule = false;
            result = this.parseContext(context, sanitizing, errorManager, false);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Parsing took: {0} ms; source: {1}", new Object[]{(System.nanoTime() - startTime) / 1000000L, scriptName});
        }
        return result;
    }

    private boolean isParsable(Snapshot snapshot) {
        FileObject fo = snapshot.getSource().getFileObject();
        boolean isEmbeded = !this.getMimeType().equals(snapshot.getMimePath().getPath());
        CharSequence text = snapshot.getText();
        String scriptName = fo != null ? snapshot.getSource().getFileObject().getNameExt() : this.getDefaultScriptName();
        Long size = fo != null && !isEmbeded ? fo.getSize() : (long)text.length();
        if (!PARSE_BIG_FILES) {
            if (size > MAX_FILE_SIZE_TO_PARSE) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "The file {0} was not parsed because the size is too big.", scriptName);
                }
                return false;
            }
            if (!(size <= MAX_MINIMIZE_FILE_SIZE_TO_PARSE || snapshot.getMimeType().equals("text/x-json") || snapshot.getMimeType().equals("text/package+x-json") || snapshot.getMimeType().equals("text/bower+x-json"))) {
                boolean isMinified = false;
                TokenSequence ts = LexUtilities.getTokenSequence((Snapshot)snapshot, (int)0, this.language);
                if (ts != null) {
                    int countedLines;
                    int countChars = 0;
                    for (countedLines = 0; !isMinified && ts.moveNext() && countedLines < 5; ++countedLines) {
                        LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.DOC_COMMENT, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.EOL, JsTokenId.WHITESPACE));
                        int offset = ts.offset();
                        LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.EOL));
                        countChars += ts.offset() - offset;
                    }
                    if (countedLines > 0 && countChars / countedLines > 200) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "The file {0} was not parsed because it is minimized and the size is too big.", scriptName);
                        }
                        return false;
                    }
                }
            } else if (snapshot.getMimeType().equals("text/x-json")) {
                int count;
                int index = text.length() - 1;
                if (index < 0) {
                    return false;
                }
                char ch = text.charAt(index);
                while (index > 0 && ch != '}') {
                    ch = text.charAt(--index);
                }
                for (count = 0; index > 0 && ch == '}' && count <= 30; ++count) {
                    ch = text.charAt(--index);
                }
                if (count >= 30) {
                    return false;
                }
            }
        }
        return true;
    }

    R parseContext(Context context, Sanitize sanitizing, JsErrorManager errorManager) throws Exception {
        return this.parseContext(context, sanitizing, errorManager, true);
    }

    private R parseContext(Context context, Sanitize sanitizing, JsErrorManager errorManager, boolean copyErrors) throws Exception {
        boolean sanitized = false;
        if (sanitizing != Sanitize.NONE && sanitizing != Sanitize.NEVER) {
            boolean ok = this.sanitizeSource(context, sanitizing, errorManager);
            if (ok) {
                sanitized = true;
                assert (context.getSanitizedSource() != null);
            } else {
                return this.parseContext(context, sanitizing.next(), errorManager, false);
            }
        }
        JsErrorManager current = new JsErrorManager(context.getSnapshot(), this.language);
        R r = this.parseSource(context, current);
        if (copyErrors) {
            errorManager.fillErrors(current);
        }
        if (sanitizing != Sanitize.NEVER) {
            if (!sanitized) {
                if (current.getMissingCurlyError() != null) {
                    return this.parseContext(context, Sanitize.MISSING_CURLY, errorManager, false);
                }
                if (current.getMissingSemicolonError() != null) {
                    return this.parseContext(context, Sanitize.MISSING_SEMICOLON, errorManager, false);
                }
            }
            if (r == null || !current.isEmpty()) {
                return this.parseContext(context, sanitizing.next(), errorManager, false);
            }
        }
        return r != null ? r : this.createErrorResult(context.getSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    private boolean sanitizeSource(Context context, Sanitize sanitizing, JsErrorManager errorManager) {
        if (sanitizing == Sanitize.MISSING_CURLY) {
            Error error = errorManager.getMissingCurlyError();
            if (error != null) {
                int offset = error.getStartPosition();
                return this.sanitizeBrackets(sanitizing, context, offset, '{', '}');
            }
        } else if (sanitizing == Sanitize.MISSING_SEMICOLON) {
            Error error = errorManager.getMissingSemicolonError();
            if (error != null) {
                void var6_24;
                String source = context.getOriginalSource();
                boolean bl = false;
                StringBuilder builder = new StringBuilder(source);
                if (error.getStartPosition() >= source.length()) {
                    builder.append(';');
                    boolean bl2 = true;
                } else {
                    int replaceOffset = error.getStartPosition();
                    if (replaceOffset >= 0 && Character.isWhitespace(replaceOffset)) {
                        builder.delete(replaceOffset, replaceOffset + 1);
                        builder.insert(replaceOffset, ';');
                        boolean bl3 = true;
                    }
                }
                if (var6_24 != false) {
                    context.setSanitizedSource(builder.toString());
                    context.setSanitization(sanitizing);
                    return true;
                }
            }
        } else if (sanitizing == Sanitize.SYNTAX_ERROR_CURRENT) {
            List<? extends FilterableError> errors = errorManager.getErrors();
            if (!errors.isEmpty()) {
                Error error = (Error)errors.get(0);
                int n = error.getStartPosition();
                TokenSequence ts = LexUtilities.getTokenSequence((Snapshot)context.getSnapshot(), (int)0, this.language);
                if (ts != null) {
                    int start;
                    ts.move(n);
                    if (ts.moveNext() && (start = ts.offset()) >= 0 && ts.moveNext()) {
                        int end = ts.offset();
                        ts.movePrevious();
                        while (ts.movePrevious() && ts.token().id() == JsTokenId.WHITESPACE) {
                        }
                        if (ts.token().id() == JsTokenId.OPERATOR_DOT) {
                            start = ts.offset();
                        }
                        StringBuilder builder = new StringBuilder(context.getOriginalSource());
                        SanitizingParser.erase(builder, start, end);
                        context.setSanitizedSource(builder.toString());
                        context.setSanitization(sanitizing);
                        return true;
                    }
                }
            }
        } else if (sanitizing == Sanitize.SYNTAX_ERROR_PREVIOUS) {
            List<? extends FilterableError> errors = errorManager.getErrors();
            if (!errors.isEmpty()) {
                Error error = (Error)errors.get(0);
                int n = error.getStartPosition();
                return this.sanitizePrevious(sanitizing, context, n, new TokenCondition(){

                    @Override
                    public boolean found(JsTokenId id) {
                        return id != JsTokenId.WHITESPACE && id != JsTokenId.EOL && id != JsTokenId.DOC_COMMENT && id != JsTokenId.LINE_COMMENT && id != JsTokenId.BLOCK_COMMENT;
                    }
                });
            }
        } else if (sanitizing == Sanitize.MISSING_PAREN) {
            List<? extends FilterableError> errors = errorManager.getErrors();
            if (!errors.isEmpty()) {
                Error error = (Error)errors.get(0);
                int n = error.getStartPosition();
                return this.sanitizeBrackets(sanitizing, context, n, '(', ')');
            }
        } else if (sanitizing == Sanitize.ERROR_DOT) {
            List<? extends FilterableError> errors = errorManager.getErrors();
            if (!errors.isEmpty()) {
                Error error = (Error)errors.get(0);
                int n = error.getStartPosition();
                return this.sanitizePrevious(sanitizing, context, n, new TokenCondition(){

                    @Override
                    public boolean found(JsTokenId id) {
                        return id == JsTokenId.OPERATOR_DOT;
                    }
                });
            }
        } else if (sanitizing == Sanitize.ERROR_LINE) {
            List<? extends FilterableError> errors = errorManager.getErrors();
            if (!errors.isEmpty()) {
                Error error = (Error)errors.get(0);
                int n = error.getStartPosition();
                return this.sanitizeLine(sanitizing, context, n);
            }
        } else {
            if (sanitizing == Sanitize.EDITED_LINE) {
                int offset = context.getCaretOffset();
                return this.sanitizeLine(sanitizing, context, offset);
            }
            if (sanitizing == Sanitize.PREVIOUS_LINES) {
                StringBuilder result = new StringBuilder(context.getOriginalSource());
                for (Error error : errorManager.getErrors()) {
                    TokenSequence ts = LexUtilities.getTokenSequence((Snapshot)context.getSnapshot(), (int)error.getStartPosition(), this.language);
                    if (ts != null) {
                        ts.move(error.getStartPosition());
                        if (ts.movePrevious()) {
                            LexUtilities.findPreviousIncluding((TokenSequence)ts, Collections.singletonList(JsTokenId.EOL));
                            if (this.sanitizeLine(context.getOriginalSource(), result, ts.offset())) continue;
                            return false;
                        }
                        return false;
                    }
                    return false;
                }
                context.setSanitizedSource(result.toString());
                context.setSanitization(sanitizing);
                return true;
            }
        }
        return false;
    }

    private boolean sanitizePrevious(Sanitize sanitizing, Context context, int offset, TokenCondition condition) {
        TokenSequence ts = LexUtilities.getTokenSequence((Snapshot)context.getSnapshot(), (int)0, this.language);
        if (ts != null) {
            ts.move(offset);
            int start = -1;
            while (ts.movePrevious()) {
                if (!condition.found((JsTokenId)ts.token().id())) continue;
                start = ts.offset();
                break;
            }
            if (start >= 0) {
                int end = offset;
                if (ts.moveNext()) {
                    end = ts.offset();
                }
                StringBuilder builder = new StringBuilder(context.getOriginalSource());
                SanitizingParser.erase(builder, start, end);
                context.setSanitizedSource(builder.toString());
                context.setSanitization(sanitizing);
                return true;
            }
        }
        return false;
    }

    private boolean sanitizeLine(Sanitize sanitizing, Context context, int offset) {
        if (offset > -1) {
            StringBuilder builder;
            String source = context.getOriginalSource();
            if (!this.sanitizeLine(source, builder = new StringBuilder(source), offset)) {
                return false;
            }
            context.setSanitizedSource(builder.toString());
            context.setSanitization(sanitizing);
            return true;
        }
        return false;
    }

    private boolean sanitizeLine(String source, StringBuilder result, int offset) {
        if (offset > -1 && !source.isEmpty()) {
            int start = offset > 0 ? offset - 1 : offset;
            int end = start + 1;
            boolean incPosition = false;
            char c = source.charAt(start);
            while (start > 0 && c != '\n' && c != '\r' && c != '{' && c != '}') {
                c = source.charAt(--start);
                if (start <= 0) {
                    incPosition = false;
                    continue;
                }
                incPosition = true;
            }
            if (incPosition) {
                ++start;
            }
            boolean decPosition = false;
            if (end < source.length()) {
                c = source.charAt(end);
                while (end < source.length() && c != '\n' && c != '\r' && c != '{' && c != '}') {
                    c = source.charAt(end++);
                    if (end >= source.length()) {
                        decPosition = false;
                        continue;
                    }
                    decPosition = true;
                }
            }
            if (decPosition) {
                --end;
            }
            SanitizingParser.erase(result, start, end);
            return true;
        }
        return false;
    }

    private boolean sanitizeBrackets(Sanitize sanitizing, Context context, int offset, char left, char right) {
        char current;
        String source = context.getOriginalSource();
        int balance = 0;
        for (int i = 0; i < source.length(); ++i) {
            current = source.charAt(i);
            if (current == left) {
                ++balance;
                continue;
            }
            if (current != right) continue;
            --balance;
        }
        if (balance != 0) {
            StringBuilder builder = new StringBuilder(source);
            if (balance < 0) {
                int index;
                while (balance < 0 && (index = builder.lastIndexOf(Character.toString(right))) >= 0) {
                    SanitizingParser.erase(builder, index, index + 1);
                    ++balance;
                }
            } else if (balance > 0) {
                if (offset >= source.length()) {
                    while (balance > 0) {
                        builder.append(right);
                        --balance;
                    }
                } else {
                    while (balance > 0 && offset - balance >= 0) {
                        current = source.charAt(offset - balance);
                        if (Character.isWhitespace(current)) {
                            builder.replace(offset - balance, offset - balance + 1, Character.toString(right));
                            --balance;
                            continue;
                        }
                        return false;
                    }
                    if (balance > 0) {
                        return false;
                    }
                }
            }
            context.setSanitizedSource(builder.toString());
            context.setSanitization(sanitizing);
            return true;
        }
        return false;
    }

    public final Parser.Result getResult(Task task) throws ParseException {
        return this.lastResult;
    }

    public final void addChangeListener(@NonNull ChangeListener changeListener) {
        LOGGER.log(Level.FINE, "Adding changeListener: {0}", changeListener);
        this.listeners.addChangeListener(changeListener);
    }

    public final void removeChangeListener(@NonNull ChangeListener changeListener) {
        LOGGER.log(Level.FINE, "Removing changeListener: {0}", changeListener);
        this.listeners.removeChangeListener(changeListener);
    }

    protected final void fireChange() {
        this.listeners.fireChange();
    }

    private static void erase(StringBuilder builder, int start, int end) {
        builder.delete(start, end);
        for (int i = start; i < end; ++i) {
            builder.insert(i, ' ');
        }
    }

    private static abstract class TokenCondition {
        private TokenCondition() {
        }

        public abstract boolean found(JsTokenId var1);
    }

    public static enum Sanitize {
        NEVER{

            @Override
            public Sanitize next() {
                return NEVER;
            }
        }
        ,
        NONE{

            @Override
            public Sanitize next() {
                return MISSING_CURLY;
            }
        }
        ,
        MISSING_CURLY{

            @Override
            public Sanitize next() {
                return MISSING_SEMICOLON;
            }
        }
        ,
        MISSING_SEMICOLON{

            @Override
            public Sanitize next() {
                return SYNTAX_ERROR_CURRENT;
            }
        }
        ,
        SYNTAX_ERROR_CURRENT{

            @Override
            public Sanitize next() {
                return SYNTAX_ERROR_PREVIOUS;
            }
        }
        ,
        SYNTAX_ERROR_PREVIOUS{

            @Override
            public Sanitize next() {
                return MISSING_PAREN;
            }
        }
        ,
        MISSING_PAREN{

            @Override
            public Sanitize next() {
                return EDITED_DOT;
            }
        }
        ,
        EDITED_DOT{

            @Override
            public Sanitize next() {
                return ERROR_DOT;
            }
        }
        ,
        ERROR_DOT{

            @Override
            public Sanitize next() {
                return ERROR_LINE;
            }
        }
        ,
        ERROR_LINE{

            @Override
            public Sanitize next() {
                return EDITED_LINE;
            }
        }
        ,
        EDITED_LINE{

            @Override
            public Sanitize next() {
                return PREVIOUS_LINES;
            }
        }
        ,
        PREVIOUS_LINES{

            @Override
            public Sanitize next() {
                return NEVER;
            }
        };


        public abstract Sanitize next();
    }

    protected static final class Context {
        private static final List<JsTokenId> IMPORT_EXPORT = new ArrayList<JsTokenId>(2);
        private final String name;
        private final Snapshot snapshot;
        private final int caretOffset;
        private final Language<JsTokenId> language;
        private String source;
        private String sanitizedSource;
        private Sanitize sanitization;
        private Boolean isModule = null;

        Context(String name, Snapshot snapshot, int caretOffset, Language<JsTokenId> language) {
            this.name = name;
            this.snapshot = snapshot;
            this.caretOffset = caretOffset;
            this.language = language;
        }

        public String getName() {
            return this.name;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public int getCaretOffset() {
            return this.snapshot.getEmbeddedOffset(this.caretOffset);
        }

        public String getSource() {
            if (this.sanitizedSource != null) {
                return this.sanitizedSource;
            }
            return this.getOriginalSource();
        }

        public String getOriginalSource() {
            if (this.source == null) {
                this.source = this.snapshot.getText().toString();
            }
            return this.source;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public void setSanitizedSource(String sanitizedSource) {
            this.sanitizedSource = sanitizedSource;
        }

        public Sanitize getSanitization() {
            return this.sanitization;
        }

        public void setSanitization(Sanitize sanitization) {
            this.sanitization = sanitization;
        }

        public boolean isModule() {
            if (this.isModule == null) {
                this.isModule = Context.isModule(this.snapshot, this.language);
            }
            return this.isModule;
        }

        private static boolean isModule(Snapshot snapshot, Language<JsTokenId> language) {
            if (BaseParserResult.isEmbedded(snapshot)) {
                return Context.isModule(snapshot, language, 0, Integer.MAX_VALUE);
            }
            TokenSequence seq = LexUtilities.getJsPositionedSequence((Snapshot)snapshot, (int)0);
            if (seq == null) {
                return false;
            }
            Token token = LexUtilities.findNextToken((TokenSequence)seq, IMPORT_EXPORT);
            return token != null && IMPORT_EXPORT.contains(token.id());
        }

        private static boolean isModule(Snapshot snapshot, Language<JsTokenId> language, int offset, int max) {
            Token token;
            assert (BaseParserResult.isEmbedded(snapshot));
            TokenSequence seq = LexUtilities.getNextJsTokenSequence((Snapshot)snapshot, (int)offset, (int)Integer.MAX_VALUE, language);
            if (seq != null && (token = LexUtilities.findNextToken((TokenSequence)seq, IMPORT_EXPORT)) != null) {
                if (IMPORT_EXPORT.contains(token.id())) {
                    return true;
                }
                return Context.isModule(snapshot, language, seq.offset() + token.length(), max);
            }
            return false;
        }

        static {
            Collections.addAll(IMPORT_EXPORT, JsTokenId.KEYWORD_IMPORT, JsTokenId.KEYWORD_EXPORT);
        }
    }
}

