/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class JavaPluginUtils {
    private static final Logger LOG = Logger.getLogger(JavaPluginUtils.class.getName());
    public static final String DEFAULT_NAME = "par";

    public static Problem isSourceElement(Element el, CompilationInfo info) {
        Element typeElement;
        if (el == null) {
            return null;
        }
        if (el.getKind() != ElementKind.PACKAGE) {
            typeElement = info.getElementUtilities().enclosingTypeElement(el);
            if (typeElement == null) {
                typeElement = el;
            }
        } else {
            typeElement = el;
        }
        ElementHandle handle = null;
        try {
            handle = ElementHandle.create((Element)typeElement);
        }
        catch (IllegalArgumentException ex) {
            LOG.log(Level.WARNING, "Cannot create handle for source element", ex);
        }
        if (handle == null || JavaRefactoringUtils.isFromLibrary((ElementHandle<? extends Element>)handle, info.getClasspathInfo())) {
            Problem preCheckProblem = new Problem(true, NbBundle.getMessage(JavaPluginUtils.class, (String)"ERR_CannotRefactorLibraryClass", (Object)(el.getKind() == ElementKind.PACKAGE ? el : el.getEnclosingElement())));
            return preCheckProblem;
        }
        FileObject file = SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo());
        if (!RefactoringUtils.isFileInOpenProject(file)) {
            Problem preCheckProblem = new Problem(true, NbBundle.getMessage(JavaPluginUtils.class, (String)"ERR_ProjectNotOpened", (Object)FileUtil.getFileDisplayName((FileObject)file)));
            return preCheckProblem;
        }
        return null;
    }

    public static Problem isSourceFile(FileObject fo, CompilationInfo info) {
        if (fo == null || FileUtil.getArchiveFile((FileObject)fo) != null) {
            Problem preCheckProblem = new Problem(true, NbBundle.getMessage(JavaPluginUtils.class, (String)"ERR_CannotRefactorLibraryClass", (Object)FileUtil.getFileDisplayName((FileObject)fo)));
            return preCheckProblem;
        }
        if (!RefactoringUtils.isFileInOpenProject(fo)) {
            Problem preCheckProblem = new Problem(true, NbBundle.getMessage(JavaPluginUtils.class, (String)"ERR_ProjectNotOpened", (Object)FileUtil.getFileDisplayName((FileObject)fo)));
            return preCheckProblem;
        }
        return null;
    }

    public static TreePath findMethod(TreePath path) {
        while (path != null) {
            if (path.getLeaf().getKind() == Tree.Kind.METHOD) {
                return path;
            }
            if (path.getLeaf().getKind() == Tree.Kind.BLOCK && path.getParentPath() != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getParentPath().getLeaf().getKind())) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    public static TreePath findStatement(TreePath statementPath) {
        while (statementPath != null && (!StatementTree.class.isAssignableFrom(statementPath.getLeaf().getKind().asInterface()) || statementPath.getParentPath() != null && statementPath.getParentPath().getLeaf().getKind() != Tree.Kind.BLOCK)) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)statementPath.getLeaf().getKind())) {
                return null;
            }
            statementPath = statementPath.getParentPath();
        }
        return statementPath;
    }

    public static boolean isParentOf(TreePath parent, TreePath path) {
        Tree parentLeaf = parent.getLeaf();
        while (path != null && path.getLeaf() != parentLeaf) {
            path = path.getParentPath();
        }
        return path != null;
    }

    public static boolean isParentOf(TreePath parent, List<? extends TreePath> candidates) {
        for (TreePath treePath : candidates) {
            if (JavaPluginUtils.isParentOf(parent, treePath)) continue;
            return false;
        }
        return true;
    }

    public static Problem chainProblems(Problem result, Problem problem) {
        Problem value;
        if (result == null) {
            return problem;
        }
        if (problem == null) {
            return result;
        }
        if (problem.isFatal()) {
            problem.setNext(result);
            value = problem;
        } else {
            Problem next = value = result;
            while (next.getNext() != null) {
                next = next.getNext();
            }
            next.setNext(problem);
        }
        return value;
    }

    public static TypeMirror convertIfAnonymous(TypeMirror tm) {
        Element el;
        EnumSet<ElementKind> fm = EnumSet.of(ElementKind.METHOD, ElementKind.FIELD);
        if (tm instanceof DeclaredType && (el = ((DeclaredType)tm).asElement()) != null && (el.getSimpleName().length() == 0 || fm.contains((Object)el.getEnclosingElement().getKind()))) {
            List<? extends TypeMirror> interfaces = ((TypeElement)el).getInterfaces();
            tm = interfaces.isEmpty() ? ((TypeElement)el).getSuperclass() : interfaces.get(0);
        }
        return tm;
    }

    public static TypeMirror resolveCapturedType(CompilationInfo info, TypeMirror tm) {
        TypeMirror type = JavaPluginUtils.resolveCapturedTypeInt(info, tm);
        if (type.getKind() == TypeKind.WILDCARD) {
            TypeMirror tmirr = ((WildcardType)type).getExtendsBound();
            if (tmirr != null) {
                return tmirr;
            }
            return info.getElements().getTypeElement("java.lang.Object").asType();
        }
        return type;
    }

    private static TypeMirror resolveCapturedTypeInt(CompilationInfo info, TypeMirror tm) {
        WildcardType orig = SourceUtils.resolveCapturedType((TypeMirror)tm);
        if (orig != null) {
            TypeMirror extendsBound;
            WildcardType rct;
            if (orig.getKind() == TypeKind.WILDCARD && (rct = SourceUtils.resolveCapturedType((TypeMirror)((extendsBound = orig.getExtendsBound()) != null ? extendsBound : orig.getSuperBound()))) != null) {
                return rct;
            }
            return orig;
        }
        if (tm.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)tm;
            LinkedList<TypeMirror> typeArguments = new LinkedList<TypeMirror>();
            for (TypeMirror typeMirror : dt.getTypeArguments()) {
                typeArguments.add(JavaPluginUtils.resolveCapturedTypeInt(info, typeMirror));
            }
            TypeMirror enclosingType = dt.getEnclosingType();
            if (enclosingType.getKind() == TypeKind.DECLARED) {
                return info.getTypes().getDeclaredType((DeclaredType)enclosingType, (TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
            }
            return info.getTypes().getDeclaredType((TypeElement)dt.asElement(), typeArguments.toArray(new TypeMirror[0]));
        }
        if (tm.getKind() == TypeKind.ARRAY) {
            ArrayType at = (ArrayType)tm;
            return info.getTypes().getArrayType(JavaPluginUtils.resolveCapturedTypeInt(info, at.getComponentType()));
        }
        return tm;
    }

    public static JavaSource createSource(FileObject file, ClasspathInfo cpInfo, TreePathHandle tph) throws IllegalArgumentException {
        JavaSource source;
        if (file != null) {
            ClassPath mergedPlatformPath = RefactoringUtils.merge(cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), ClassPath.getClassPath((FileObject)file, (String)"classpath/boot"));
            ClassPath mergedModulePlatformPath = RefactoringUtils.merge(cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_BOOT), ClassPath.getClassPath((FileObject)file, (String)"modules/boot"));
            ClassPath mergedCompilePath = RefactoringUtils.merge(cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE), ClassPath.getClassPath((FileObject)file, (String)"classpath/compile"));
            ClassPath mergedModuleCompilePath = RefactoringUtils.merge(cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_COMPILE), ClassPath.getClassPath((FileObject)file, (String)"modules/compile"));
            ClassPath mergedModuleClassPath = RefactoringUtils.merge(cpInfo.getClassPath(ClasspathInfo.PathKind.MODULE_CLASS), ClassPath.getClassPath((FileObject)file, (String)"modules/classpath"));
            ClassPath mergedSourcePath = RefactoringUtils.merge(cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), ClassPath.getClassPath((FileObject)file, (String)"classpath/source"));
            ClasspathInfo mergedInfo = new ClasspathInfo.Builder(mergedPlatformPath).setModuleBootPath(mergedModulePlatformPath).setClassPath(mergedCompilePath).setModuleCompilePath(mergedModuleCompilePath).setModuleClassPath(mergedModuleClassPath).setSourcePath(mergedSourcePath).build();
            source = JavaSource.create((ClasspathInfo)mergedInfo, (FileObject[])new FileObject[]{tph.getFileObject()});
        } else {
            source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        }
        return source;
    }

    public static boolean hasGetter(CompilationInfo info, TypeElement typeElement, VariableElement field, Map<String, List<ExecutableElement>> methods, CodeStyle cs) {
        Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = field.asType();
        boolean isStatic = field.getModifiers().contains((Object)Modifier.STATIC);
        String getterName = CodeStyleUtils.computeGetterName((CharSequence)name, (type.getKind() == TypeKind.BOOLEAN ? 1 : 0) != 0, (boolean)isStatic, (CodeStyle)cs);
        Types types = info.getTypes();
        List<ExecutableElement> candidates = methods.get(getterName);
        if (candidates != null) {
            for (ExecutableElement candidate : candidates) {
                if (candidate.getModifiers().contains((Object)Modifier.ABSTRACT) && candidate.getEnclosingElement() != typeElement || !candidate.getParameters().isEmpty() || !types.isSameType(candidate.getReturnType(), type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSetter(CompilationInfo info, TypeElement typeElement, VariableElement field, Map<String, List<ExecutableElement>> methods, CodeStyle cs) {
        Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = field.asType();
        boolean isStatic = field.getModifiers().contains((Object)Modifier.STATIC);
        String setterName = CodeStyleUtils.computeSetterName((CharSequence)name, (boolean)isStatic, (CodeStyle)cs);
        Types types = info.getTypes();
        List<ExecutableElement> candidates = methods.get(setterName);
        if (candidates != null) {
            for (ExecutableElement candidate : candidates) {
                if (candidate.getModifiers().contains((Object)Modifier.ABSTRACT) && candidate.getEnclosingElement() != typeElement || candidate.getReturnType().getKind() != TypeKind.VOID || candidate.getParameters().size() != 1 || !types.isSameType(candidate.getParameters().get(0).asType(), type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSyntheticPath(CompilationInfo ci, TreePath path) {
        TreeUtilities tu = ci.getTreeUtilities();
        if (path == null) {
            throw new NullPointerException();
        }
        while (path != null) {
            AssignmentTree aTree;
            if (JavaPluginUtils.isSynthetic(ci, path.getCompilationUnit(), path.getLeaf()) && (path.getLeaf().getKind() != Tree.Kind.ASSIGNMENT || path.getParentPath() == null || path.getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION || (aTree = (AssignmentTree)path.getLeaf()).getVariable().getKind() != Tree.Kind.IDENTIFIER || !((IdentifierTree)aTree.getVariable()).getName().contentEquals("value"))) {
                return true;
            }
            path = path.getParentPath();
        }
        return false;
    }

    static boolean isSynthetic(CompilationInfo info, CompilationUnitTree cut, Tree leaf) throws NullPointerException {
        IdentifierTree it;
        MethodInvocationTree mit;
        ExpressionStatementTree est;
        JCTree tree = (JCTree)leaf;
        if (tree.pos == -1) {
            return true;
        }
        if (leaf.getKind() == Tree.Kind.METHOD) {
            return (((JCTree.JCMethodDecl)leaf).mods.flags & 0x1000000000L) != 0L;
        }
        if (leaf.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (est = (ExpressionStatementTree)leaf).getExpression().getKind() == Tree.Kind.METHOD_INVOCATION && (mit = (MethodInvocationTree)est.getExpression()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals((it = (IdentifierTree)mit.getMethodSelect()).getName().toString())) {
            SourcePositions sp = info.getTrees().getSourcePositions();
            return sp.getEndPosition(cut, leaf) == -1L;
        }
        return false;
    }

    public static String makeNameUnique(CompilationInfo info, Scope s, String name) {
        return JavaPluginUtils.makeNameUnique(info, s, name, Collections.EMPTY_LIST, null, null);
    }

    public static String makeNameUnique(CompilationInfo info, Scope s, String name, List<String> definedIds) {
        return JavaPluginUtils.makeNameUnique(info, s, name, definedIds, null, null);
    }

    public static String makeNameUnique(CompilationInfo info, Scope s, String name, String prefix, String suffix) {
        return JavaPluginUtils.makeNameUnique(info, s, name, Collections.EMPTY_LIST, prefix, suffix);
    }

    public static String makeNameUnique(CompilationInfo info, Scope s, String name, List<String> definedIds, String prefix, String suffix) {
        String proposedName;
        boolean cont;
        name = CodeStyleUtils.addPrefixSuffix((CharSequence)name, (String)prefix, null);
        int counter = 0;
        block0: do {
            proposedName = name + (counter != 0 ? String.valueOf(counter) : "") + JavaPluginUtils.safeString(suffix);
            cont = false;
            if (s == null) continue;
            for (String id : definedIds) {
                if (!proposedName.equals(id)) continue;
                ++counter;
                cont = true;
                break;
            }
            for (Element e : info.getElementUtilities().getLocalMembersAndVars(s, (ElementUtilities.ElementAcceptor)new VariablesFilter())) {
                if (!proposedName.equals(e.getSimpleName().toString())) continue;
                ++counter;
                cont = true;
                continue block0;
            }
        } while (cont);
        return proposedName;
    }

    private static String safeString(String str) {
        return str == null ? "" : str;
    }

    public static String getName(TypeMirror tm) {
        if (tm.getKind().isPrimitive()) {
            return "" + Character.toLowerCase(tm.getKind().name().charAt(0));
        }
        switch (tm.getKind()) {
            case DECLARED: {
                DeclaredType dt = (DeclaredType)tm;
                return JavaPluginUtils.firstToLower(dt.asElement().getSimpleName().toString());
            }
            case ARRAY: {
                return JavaPluginUtils.getName(((ArrayType)tm).getComponentType());
            }
        }
        return DEFAULT_NAME;
    }

    public static String getName(ExpressionTree et) {
        return JavaPluginUtils.getName((Tree)et);
    }

    public static String getName(Tree et) {
        return JavaPluginUtils.adjustName(JavaPluginUtils.getNameRaw(et));
    }

    private static String getNameRaw(Tree et) {
        if (et == null) {
            return null;
        }
        switch (et.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)et).getName().toString();
            }
            case METHOD_INVOCATION: {
                return JavaPluginUtils.getNameRaw(((MethodInvocationTree)et).getMethodSelect());
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)et).getIdentifier().toString();
            }
            case NEW_CLASS: {
                return JavaPluginUtils.firstToLower(JavaPluginUtils.getNameRaw(((NewClassTree)et).getIdentifier()));
            }
            case PARAMETERIZED_TYPE: {
                return JavaPluginUtils.firstToLower(JavaPluginUtils.getNameRaw(((ParameterizedTypeTree)et).getType()));
            }
            case STRING_LITERAL: {
                String name = JavaPluginUtils.guessLiteralName((String)((LiteralTree)et).getValue());
                if (name == null) {
                    return JavaPluginUtils.firstToLower(String.class.getSimpleName());
                }
                return JavaPluginUtils.firstToLower(name);
            }
            case VARIABLE: {
                return ((VariableTree)et).getName().toString();
            }
        }
        return null;
    }

    static String adjustName(String name) {
        if (name == null) {
            return null;
        }
        String shortName = null;
        if (name.startsWith("get") && name.length() > 3) {
            shortName = name.substring(3);
        }
        if (name.startsWith("is") && name.length() > 2) {
            shortName = name.substring(2);
        }
        if (shortName != null) {
            return JavaPluginUtils.firstToLower(shortName);
        }
        if (SourceVersion.isKeyword(name)) {
            return "a" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    private static String firstToLower(String name) {
        if (name.length() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean toLower = true;
        char last = Character.toLowerCase(name.charAt(0));
        for (int i = 1; i < name.length(); ++i) {
            if (toLower && (Character.isUpperCase(name.charAt(i)) || name.charAt(i) == '_')) {
                result.append(Character.toLowerCase(last));
            } else {
                result.append(last);
                toLower = false;
            }
            last = name.charAt(i);
        }
        result.append(toLower ? Character.toLowerCase(last) : last);
        if (SourceVersion.isKeyword(result)) {
            return "a" + name;
        }
        return result.toString();
    }

    private static String guessLiteralName(String str) {
        if (str.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == ' ') {
                sb.append('_');
            } else if (sb.length() == 0 ? Character.isJavaIdentifierStart(ch) : Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
            }
            if (sb.length() > 40) break;
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public static CompilationUnitTree createCompilationUnit(FileObject sourceRoot, String relativePath, Tree typeDecl, WorkingCopy workingCopy, TreeMaker make) {
        CompilationUnitTree newCompilation;
        GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)workingCopy);
        try {
            newCompilation = genUtils.createFromTemplate(sourceRoot, relativePath, ElementKind.CLASS);
            List<? extends Tree> typeDecls = newCompilation.getTypeDecls();
            if (typeDecls.isEmpty()) {
                newCompilation = make.addCompUnitTypeDecl(newCompilation, typeDecl);
            } else {
                LinkedList<? extends Tree> typeDeclarations = new LinkedList<Tree>(newCompilation.getTypeDecls());
                Tree templateClazz = (Tree)typeDeclarations.remove(0);
                workingCopy.getTreeMaker().asRemoved(templateClazz);
                typeDecl = genUtils.importComments(typeDecl, newCompilation);
                if (workingCopy.getTreeUtilities().getComments(typeDecl, true).isEmpty()) {
                    genUtils.copyComments(templateClazz, typeDecl, true);
                } else if (workingCopy.getTreeUtilities().getComments(typeDecl, false).isEmpty()) {
                    genUtils.copyComments(templateClazz, typeDecl, false);
                }
                typeDeclarations.add(0, typeDecl);
                newCompilation = make.CompilationUnit(newCompilation.getPackageAnnotations(), sourceRoot, relativePath, newCompilation.getImports(), typeDeclarations);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            newCompilation = make.CompilationUnit(sourceRoot, relativePath, null, Collections.singletonList(typeDecl));
        }
        return newCompilation;
    }

    public static final class VariablesFilter
    implements ElementUtilities.ElementAcceptor {
        private static final Set<ElementKind> ACCEPTABLE_KINDS = EnumSet.of(ElementKind.ENUM_CONSTANT, ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

        public boolean accept(Element e, TypeMirror type) {
            return ACCEPTABLE_KINDS.contains((Object)e.getKind());
        }
    }
}

