/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import com.sun.jdi.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import jdk.jshell.execution.DemultiplexInput;
import jdk.jshell.execution.ExecutionControlForwarder;
import jdk.jshell.execution.JdiEventHandler;
import jdk.jshell.execution.MultiplexingOutputStream;
import jdk.jshell.execution.PipeInputStream;
import jdk.jshell.spi.ExecutionControl;

public class Util {
    private static final int TAG_DATA = 0;
    private static final int TAG_CLOSED = 1;
    private static final int TAG_EXCEPTION = 2;

    private Util() {
    }

    public static void forwardExecutionControl(ExecutionControl ec, ObjectInput in, ObjectOutput out) {
        new ExecutionControlForwarder(ec, in, out).commandLoop();
    }

    public static void forwardExecutionControlAndIO(ExecutionControl ec, InputStream inStream, OutputStream outStream, Map<String, Consumer<OutputStream>> outputStreamMap, Map<String, Consumer<InputStream>> inputStreamMap) throws IOException {
        for (Map.Entry<String, Consumer<OutputStream>> e : outputStreamMap.entrySet()) {
            e.getValue().accept(Util.multiplexingOutputStream(e.getKey(), outStream));
        }
        ObjectOutputStream cmdOut = new ObjectOutputStream(Util.multiplexingOutputStream("$command", outStream));
        PipeInputStream cmdInPipe = new PipeInputStream();
        HashMap<String, OutputStream> inputs = new HashMap<String, OutputStream>();
        inputs.put("$command", cmdInPipe.createOutput());
        for (Map.Entry<String, Consumer<InputStream>> e : inputStreamMap.entrySet()) {
            final OutputStream inputSignal = Util.multiplexingOutputStream("$" + e.getKey() + "-input-requested", outStream);
            PipeInputStream inputPipe = new PipeInputStream(){

                @Override
                protected void inputNeeded() throws IOException {
                    inputSignal.write(49);
                    inputSignal.flush();
                }

                @Override
                public synchronized int read() throws IOException {
                    int tag = super.read();
                    switch (tag) {
                        case 0: {
                            return super.read();
                        }
                        case 1: {
                            this.close();
                            return -1;
                        }
                        case 2: {
                            int len = (super.read() << 0) + (super.read() << 8) + (super.read() << 16) + (super.read() << 24);
                            byte[] message = new byte[len];
                            for (int i = 0; i < len; ++i) {
                                message[i] = (byte)super.read();
                            }
                            throw new IOException(new String(message, "UTF-8"));
                        }
                        case -1: {
                            return -1;
                        }
                    }
                    throw new IOException("Internal error: unrecognized message tag: " + tag);
                }
            };
            inputs.put(e.getKey(), inputPipe.createOutput());
            e.getValue().accept(inputPipe);
        }
        new DemultiplexInput(inStream, inputs, inputs.values()).start();
        ObjectInputStream cmdIn = new ObjectInputStream(cmdInPipe);
        Util.forwardExecutionControl(ec, cmdIn, cmdOut);
    }

    static OutputStream multiplexingOutputStream(String label, OutputStream outputStream) {
        return new MultiplexingOutputStream(label, outputStream);
    }

    public static ExecutionControl remoteInputOutput(InputStream input, OutputStream output, Map<String, OutputStream> outputStreamMap, Map<String, InputStream> inputStreamMap, BiFunction<ObjectInput, ObjectOutput, ExecutionControl> factory) throws IOException {
        final ExecutionControl[] result = new ExecutionControl[1];
        HashMap<String, OutputStream> augmentedStreamMap = new HashMap<String, OutputStream>(outputStreamMap);
        ObjectOutputStream commandOut = new ObjectOutputStream(Util.multiplexingOutputStream("$command", output));
        for (final Map.Entry<String, InputStream> e : inputStreamMap.entrySet()) {
            final InputStream in = e.getValue();
            final OutputStream inTarget = Util.multiplexingOutputStream(e.getKey(), output);
            augmentedStreamMap.put("$" + e.getKey() + "-input-requested", new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    try {
                        int r = in.read();
                        if (r == -1) {
                            inTarget.write(1);
                        } else {
                            inTarget.write(new byte[]{0, (byte)r});
                        }
                    }
                    catch (InterruptedIOException exc) {
                        try {
                            result[0].stop();
                        }
                        catch (ExecutionControl.ExecutionControlException ex) {
                            Util.debug(ex, "$" + (String)e.getKey() + "-input-requested.write");
                        }
                    }
                    catch (IOException exc) {
                        byte[] message = exc.getMessage().getBytes("UTF-8");
                        inTarget.write(2);
                        inTarget.write(message.length >> 0 & 0xFF);
                        inTarget.write(message.length >> 8 & 0xFF);
                        inTarget.write(message.length >> 16 & 0xFF);
                        inTarget.write(message.length >> 24 & 0xFF);
                        inTarget.write(message);
                    }
                }
            });
        }
        PipeInputStream commandIn = new PipeInputStream();
        OutputStream commandInTarget = commandIn.createOutput();
        augmentedStreamMap.put("$command", commandInTarget);
        new DemultiplexInput(input, augmentedStreamMap, Arrays.asList(commandInTarget)).start();
        result[0] = factory.apply(new ObjectInputStream(commandIn), commandOut);
        return result[0];
    }

    public static void detectJdiExitEvent(VirtualMachine vm, Consumer<String> unbiddenExitHandler) {
        if (vm.canBeModified()) {
            new JdiEventHandler(vm, unbiddenExitHandler).start();
        }
    }

    private static void debug(Throwable ex, String where) {
    }
}

