/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.DocTreePathHandle;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagType;
import org.netbeans.modules.javadoc.hints.Access;
import org.netbeans.modules.javadoc.hints.AddTagFix;
import org.netbeans.modules.javadoc.hints.Bundle;
import org.netbeans.modules.javadoc.hints.JavadocUtilities;
import org.netbeans.modules.javadoc.hints.RemoveTagFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

final class Analyzer
extends DocTreePathScanner<Void, List<ErrorDescription>> {
    private static final HtmlModel model = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.XHTML5);
    private final CompilationInfo javac;
    private final FileObject file;
    private final TreePath currentPath;
    private final SourceVersion sourceVersion;
    private final Access access;
    private Deque<StartElementTree> tagStack = new LinkedList<StartElementTree>();
    private Set<Element> foundParams = new HashSet<Element>();
    private Set<TypeMirror> foundThrows = new HashSet<TypeMirror>();
    private TypeMirror returnType = null;
    private boolean returnTypeFound = false;
    private boolean foundInheritDoc = false;
    private Element currentElement;
    private final HintContext ctx;
    private static final Logger LOG = Logger.getLogger(Analyzer.class.getName());
    private static final Set<String> NON_VOID_TAGS = new HashSet<String>(Arrays.asList("menuitem", "noscript", "script", "style"));

    Analyzer(CompilationInfo javac, TreePath currentPath, Access access, HintContext ctx) {
        this.javac = javac;
        this.file = javac.getFileObject();
        this.currentPath = currentPath;
        this.sourceVersion = JavadocUtilities.resolveSourceVersion(javac.getFileObject());
        this.access = access;
        this.ctx = ctx;
    }

    public List<ErrorDescription> analyze() {
        if (this.ctx.isCanceled()) {
            return Collections.emptyList();
        }
        List<ErrorDescription> errors = Collections.emptyList();
        Tree node = this.currentPath.getLeaf();
        if (this.javac.getTreeUtilities().isSynthetic(this.currentPath) || !this.access.isAccessible(this.javac, this.currentPath, false)) {
            return errors;
        }
        this.currentElement = this.javac.getTrees().getElement(this.currentPath);
        if (this.currentElement == null) {
            Logger.getLogger(Analyzer.class.getName()).log(Level.INFO, "Cannot resolve element for {0} in {1}", new Object[]{node, this.file});
            return errors;
        }
        if (this.ctx.isCanceled()) {
            return Collections.emptyList();
        }
        DocCommentTree docCommentTree = this.javac.getDocTrees().getDocCommentTree(this.currentPath);
        if (docCommentTree != null) {
            errors = new ArrayList<ErrorDescription>();
            if (node.getKind() == Tree.Kind.METHOD) {
                ExecutableElement methodElm = (ExecutableElement)this.currentElement;
                this.returnType = methodElm.getReturnType();
            }
            DocTreePath docTreePath = new DocTreePath(this.currentPath, docCommentTree);
            this.scan(docTreePath, errors);
            if (this.ctx.isCanceled()) {
                return Collections.emptyList();
            }
            HashSet<String> inheritedParams = new HashSet<String>();
            HashSet<String> inheritedTypeParams = new HashSet<String>();
            HashSet<String> inheritedThrows = new HashSet<String>();
            block0 : switch (this.currentElement.getKind()) {
                case METHOD: {
                    ExecutableElement method = (ExecutableElement)this.currentElement;
                    ElementUtilities elUtils = this.javac.getElementUtilities();
                    if (this.ctx.isCanceled()) break;
                    TypeElement typeElement = elUtils.enclosingTypeElement(this.currentElement);
                    this.findInheritedParams(method, typeElement, inheritedParams, inheritedTypeParams, inheritedThrows);
                    if (this.ctx.isCanceled()) break;
                }
                case CONSTRUCTOR: {
                    MethodTree methodTree = (MethodTree)this.currentPath.getLeaf();
                    ExecutableElement ee = (ExecutableElement)this.currentElement;
                    if (this.ctx.isCanceled()) break;
                    this.checkParamsDocumented(ee.getTypeParameters(), methodTree.getTypeParameters(), docTreePath, inheritedTypeParams, errors);
                    if (this.ctx.isCanceled()) break;
                    this.checkParamsDocumented(ee.getParameters(), methodTree.getParameters(), docTreePath, inheritedParams, errors);
                    if (this.ctx.isCanceled()) break;
                    this.checkThrowsDocumented(ee.getThrownTypes(), methodTree.getThrows(), docTreePath, inheritedThrows, errors);
                    if (this.ctx.isCanceled()) break;
                    switch (ee.getReturnType().getKind()) {
                        case VOID: 
                        case NONE: {
                            break block0;
                        }
                    }
                    if (this.returnTypeFound || this.foundInheritDoc || this.javac.getTypes().isSameType(ee.getReturnType(), this.javac.getElements().getTypeElement("java.lang.Void").asType())) break;
                    Tree returnTree = methodTree.getReturnType();
                    DocTreePathHandle dtph = DocTreePathHandle.create((DocTreePath)docTreePath, (CompilationInfo)this.javac);
                    if (dtph == null) break;
                    errors.add(ErrorDescriptionFactory.forTree((HintContext)this.ctx, (Tree)returnTree, (String)Bundle.MISSING_RETURN_DESC(), (Fix[])new Fix[]{AddTagFix.createAddReturnTagFix(dtph).toEditorFix()}));
                    break;
                }
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case ANNOTATION_TYPE: {
                    ClassTree classTree = (ClassTree)this.currentPath.getLeaf();
                    TypeElement typeElement = (TypeElement)this.currentElement;
                    if (this.ctx.isCanceled()) break;
                    this.checkParamsDocumented(typeElement.getTypeParameters(), classTree.getTypeParameters(), docTreePath, inheritedParams, errors);
                    break;
                }
            }
        }
        if (this.ctx.isCanceled()) {
            return Collections.emptyList();
        }
        return errors;
    }

    @Override
    public Void visitAttribute(AttributeTree node, List<ErrorDescription> errors) {
        return (Void)super.visitAttribute(node, errors);
    }

    @Override
    public Void visitAuthor(AuthorTree node, List<ErrorDescription> errors) {
        boolean oldInheritDoc = this.foundInheritDoc;
        super.visitAuthor(node, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    @Override
    public Void visitComment(CommentTree node, List<ErrorDescription> errors) {
        return (Void)super.visitComment(node, errors);
    }

    @Override
    public Void visitDeprecated(DeprecatedTree node, List<ErrorDescription> errors) {
        boolean oldInheritDoc = this.foundInheritDoc;
        super.visitDeprecated(node, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    @Override
    public Void visitDocComment(DocCommentTree node, List<ErrorDescription> errors) {
        DocTreePath currentDocPath = this.getCurrentPath();
        Void value = (Void)super.visitDocComment(node, errors);
        DocSourcePositions sp = (DocSourcePositions)this.javac.getTrees().getSourcePositions();
        while (!this.tagStack.isEmpty()) {
            StartElementTree startTree = this.tagStack.pop();
            Name tagName = startTree.getName();
            HtmlTag tag = Analyzer.getTag(tagName);
            if (tag == null || tag.hasOptionalEndTag() || this.isVoid(tag)) continue;
            int s = (int)sp.getStartPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), startTree);
            int e = (int)sp.getEndPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), startTree);
            errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)s, (int)e, (String)Bundle.TAG_START_UNMATCHED(tagName), (Fix[])new Fix[0]));
        }
        return value;
    }

    @Override
    public Void visitDocRoot(DocRootTree node, List<ErrorDescription> errors) {
        return (Void)super.visitDocRoot(node, errors);
    }

    @Override
    public Void visitEndElement(EndElementTree node, List<ErrorDescription> errors) {
        DocTreePath currentDocPath = this.getCurrentPath();
        DocTreePathHandle dtph = DocTreePathHandle.create((DocTreePath)currentDocPath, (CompilationInfo)this.javac);
        if (dtph == null) {
            return null;
        }
        DocSourcePositions sp = (DocSourcePositions)this.javac.getTrees().getSourcePositions();
        int start = (int)sp.getStartPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), node);
        int end = (int)sp.getEndPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), node);
        Name treeName = node.getName();
        HtmlTag t = Analyzer.getTag(treeName);
        if (t == null) {
            errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.TAG_END_UNKNOWN(treeName), (Fix[])new Fix[0]));
        } else if (this.isVoid(t)) {
            errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.TAG_END_NOT_PERMITTED(treeName), (Fix[])new Fix[0]));
        } else {
            boolean done = false;
            while (!this.tagStack.isEmpty()) {
                StartElementTree startTree = this.tagStack.peek();
                Name tagName = startTree.getName();
                HtmlTag tag = Analyzer.getTag(tagName);
                if (Objects.equals(t, tag)) {
                    this.tagStack.pop();
                    done = true;
                    break;
                }
                if (tag != null && tag.hasOptionalEndTag()) {
                    this.tagStack.pop();
                    continue;
                }
                boolean found = false;
                for (StartElementTree set : this.tagStack) {
                    HtmlTag si = Analyzer.getTag(set.getName());
                    if (!Objects.equals(si, t)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    int s = (int)sp.getStartPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), startTree);
                    int e = (int)sp.getEndPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), startTree);
                    errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)s, (int)e, (String)Bundle.TAG_START_UNMATCHED(tagName), (Fix[])new Fix[0]));
                    this.tagStack.pop();
                    continue;
                }
                errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.TAG_END_UNEXPECTED(treeName), (Fix[])new Fix[0]));
                done = true;
                break;
            }
            if (!done && this.tagStack.isEmpty()) {
                errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.TAG_END_UNEXPECTED(treeName), (Fix[])new Fix[0]));
            }
        }
        return (Void)super.visitEndElement(node, errors);
    }

    @Override
    public Void visitEntity(EntityTree node, List<ErrorDescription> errors) {
        return (Void)super.visitEntity(node, errors);
    }

    @Override
    public Void visitErroneous(ErroneousTree node, List<ErrorDescription> errors) {
        return (Void)super.visitErroneous(node, errors);
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, List<ErrorDescription> errors) {
        return (Void)super.visitIdentifier(node, errors);
    }

    @Override
    public Void visitInheritDoc(InheritDocTree node, List<ErrorDescription> errors) {
        this.foundInheritDoc = true;
        return (Void)super.visitInheritDoc(node, errors);
    }

    @Override
    public Void visitLink(LinkTree node, List<ErrorDescription> errors) {
        return (Void)super.visitLink(node, errors);
    }

    @Override
    public Void visitLiteral(LiteralTree node, List<ErrorDescription> errors) {
        return (Void)super.visitLiteral(node, errors);
    }

    @Override
    public Void visitParam(ParamTree tree, List<ErrorDescription> errors) {
        boolean oldInheritDoc = this.foundInheritDoc;
        DocTreePath currentDocPath = this.getCurrentPath();
        DocTreePathHandle dtph = DocTreePathHandle.create((DocTreePath)currentDocPath, (CompilationInfo)this.javac);
        if (dtph == null) {
            return null;
        }
        DocSourcePositions sp = (DocSourcePositions)this.javac.getTrees().getSourcePositions();
        int start = (int)sp.getStartPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), tree);
        int end = (int)sp.getEndPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), tree);
        if (this.ctx.isCanceled()) {
            return null;
        }
        boolean typaram = tree.isTypeParameter();
        switch (this.currentElement.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                ExecutableElement ee = (ExecutableElement)this.currentElement;
                this.checkParamDeclared(tree, typaram ? ee.getTypeParameters() : ee.getParameters(), dtph, start, end, errors);
                break;
            }
            case CLASS: 
            case INTERFACE: {
                TypeElement te = (TypeElement)this.currentElement;
                if (typaram) {
                    this.checkParamDeclared(tree, te.getTypeParameters(), dtph, start, end, errors);
                    break;
                }
                errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.INVALID_TAG_DESC("@param", (Object)this.currentElement.getKind()), (Fix[])new Fix[]{new RemoveTagFix(dtph, "@param").toEditorFix()}));
                break;
            }
            default: {
                errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.INVALID_TAG_DESC("@param", (Object)this.currentElement.getKind()), (Fix[])new Fix[]{new RemoveTagFix(dtph, "@param").toEditorFix()}));
            }
        }
        this.warnIfEmpty(tree, tree.getDescription());
        super.visitParam(tree, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    private void checkParamDeclared(ParamTree tree, List<? extends Element> list, DocTreePathHandle dtph, int start, int end, List<ErrorDescription> errors) {
        Name name = tree.getName().getName();
        boolean found = false;
        for (Element element : list) {
            if (this.ctx.isCanceled()) {
                return;
            }
            if (!name.equals(element.getSimpleName())) continue;
            if (!this.foundParams.add(element)) {
                errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.DUPLICATE_PARAM_DESC(name), (Fix[])new Fix[]{new RemoveTagFix(dtph, "@param").toEditorFix()}));
            }
            found = true;
        }
        if (!found) {
            errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.UNKNOWN_TYPEPARAM_DESC(name), (Fix[])new Fix[]{new RemoveTagFix(dtph, "@param").toEditorFix()}));
        }
    }

    private void checkParamsDocumented(List<? extends Element> list, List<? extends Tree> trees, DocTreePath docTreePath, Set<String> inheritedParams, List<ErrorDescription> errors) {
        if (this.foundInheritDoc) {
            return;
        }
        for (int i = 0; i < list.size() && i < trees.size(); ++i) {
            if (this.ctx.isCanceled()) {
                return;
            }
            Element e = list.get(i);
            Tree t = trees.get(i);
            if (this.foundParams.contains(e) || inheritedParams.contains(e.getSimpleName().toString())) continue;
            boolean isTypeParam = e.getKind() == ElementKind.TYPE_PARAMETER;
            Name paramName = isTypeParam ? "<" + e.getSimpleName() + ">" : e.getSimpleName();
            DocTreePathHandle dtph = DocTreePathHandle.create((DocTreePath)docTreePath, (CompilationInfo)this.javac);
            if (dtph == null) continue;
            errors.add(ErrorDescriptionFactory.forTree((HintContext)this.ctx, (Tree)t, (String)Bundle.MISSING_PARAM_DESC(paramName), (Fix[])new Fix[]{AddTagFix.createAddParamTagFix(dtph, e.getSimpleName().toString(), isTypeParam, i).toEditorFix()}));
        }
    }

    private void checkThrowsDeclared(ThrowsTree tree, Element ex, String fqn, List<? extends TypeMirror> list, DocTreePathHandle dtph, int start, int end, List<ErrorDescription> errors) {
        TypeElement typeElement;
        boolean found = false;
        TypeMirror type = ex != null ? ex.asType() : ((typeElement = this.javac.getElements().getTypeElement(fqn)) != null ? typeElement.asType() : null);
        for (TypeMirror typeMirror : list) {
            if (this.ctx.isCanceled()) {
                return;
            }
            if (type != null && this.javac.getTypes().isAssignable(type, typeMirror)) {
                if (!this.foundThrows.add(type)) {
                    errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.DUPLICATE_THROWS_DESC(tree.getTagName(), fqn), (Fix[])new Fix[]{new RemoveTagFix(dtph, "@" + tree.getTagName()).toEditorFix()}));
                }
                found = true;
                break;
            }
            if (type != null || !fqn.equals(typeMirror.toString())) continue;
            if (!this.foundThrows.add(typeMirror)) {
                errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.DUPLICATE_THROWS_DESC(tree.getTagName(), fqn), (Fix[])new Fix[]{new RemoveTagFix(dtph, "@" + tree.getTagName()).toEditorFix()}));
            }
            found = true;
            break;
        }
        if (!found) {
            errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.UNKNOWN_THROWABLE_DESC(tree.getTagName(), fqn), (Fix[])new Fix[]{new RemoveTagFix(dtph, "@" + tree.getTagName()).toEditorFix()}));
        }
    }

    private void checkThrowsDocumented(List<? extends TypeMirror> list, List<? extends ExpressionTree> trees, DocTreePath docTreePath, Set<String> inheritedThrows, List<ErrorDescription> errors) {
        if (this.foundInheritDoc) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            DocTreePathHandle dtph;
            if (this.ctx.isCanceled()) {
                return;
            }
            TypeMirror e = list.get(i);
            Tree t = trees.get(i);
            Types types = this.javac.getTypes();
            if (this.foundThrows.contains(e) || inheritedThrows.contains(e.toString()) || types.isAssignable(e, this.javac.getElements().getTypeElement("java.lang.Error").asType()) || types.isAssignable(e, this.javac.getElements().getTypeElement("java.lang.RuntimeException").asType())) continue;
            boolean found = false;
            for (TypeMirror typeMirror : this.foundThrows) {
                if (!types.isAssignable(typeMirror, e)) continue;
                found = true;
                break;
            }
            if (found || (dtph = DocTreePathHandle.create((DocTreePath)docTreePath, (CompilationInfo)this.javac)) == null) continue;
            errors.add(ErrorDescriptionFactory.forTree((HintContext)this.ctx, (Tree)t, (String)NbBundle.getMessage(Analyzer.class, (String)"MISSING_THROWS_DESC", (Object)e.toString()), (Fix[])new Fix[]{AddTagFix.createAddThrowsTagFix(dtph, e.toString(), i).toEditorFix()}));
        }
    }

    void warnIfEmpty(DocTree tree, List<? extends DocTree> list) {
    }

    @Override
    public Void visitReference(ReferenceTree node, List<ErrorDescription> errors) {
        return (Void)super.visitReference(node, errors);
    }

    @Override
    public Void visitReturn(ReturnTree node, List<ErrorDescription> errors) {
        boolean oldInheritDoc = this.foundInheritDoc;
        DocTreePath currentDocPath = this.getCurrentPath();
        DocTreePathHandle dtph = DocTreePathHandle.create((DocTreePath)currentDocPath, (CompilationInfo)this.javac);
        if (dtph == null) {
            return null;
        }
        DocSourcePositions sp = (DocSourcePositions)this.javac.getTrees().getSourcePositions();
        int start = (int)sp.getStartPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), node);
        int end = (int)sp.getEndPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), node);
        if (this.returnType == null) {
            errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.WRONG_CONSTRUCTOR_RETURN_DESC(), (Fix[])new Fix[]{new RemoveTagFix(dtph, "@return").toEditorFix()}));
        } else if (this.returnType.getKind() == TypeKind.VOID) {
            errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.WRONG_RETURN_DESC(), (Fix[])new Fix[]{new RemoveTagFix(dtph, "@return").toEditorFix()}));
        } else if (this.returnTypeFound) {
            errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.DUPLICATE_RETURN_DESC(), (Fix[])new Fix[]{new RemoveTagFix(dtph, "@return").toEditorFix()}));
        } else {
            this.returnTypeFound = true;
        }
        super.visitReturn(node, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    @Override
    public Void visitSee(SeeTree node, List<ErrorDescription> errors) {
        boolean oldInheritDoc = this.foundInheritDoc;
        super.visitSee(node, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    @Override
    public Void visitSerial(SerialTree node, List<ErrorDescription> errors) {
        boolean oldInheritDoc = this.foundInheritDoc;
        super.visitSerial(node, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    @Override
    public Void visitSerialData(SerialDataTree node, List<ErrorDescription> errors) {
        boolean oldInheritDoc = this.foundInheritDoc;
        super.visitSerialData(node, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    @Override
    public Void visitSerialField(SerialFieldTree node, List<ErrorDescription> errors) {
        boolean oldInheritDoc = this.foundInheritDoc;
        super.visitSerialField(node, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    @Override
    public Void visitSince(SinceTree node, List<ErrorDescription> errors) {
        boolean oldInheritDoc = this.foundInheritDoc;
        super.visitSince(node, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    @Override
    public Void visitStartElement(StartElementTree node, List<ErrorDescription> errors) {
        DocTreePath currentDocPath = this.getCurrentPath();
        DocTreePathHandle dtph = DocTreePathHandle.create((DocTreePath)currentDocPath, (CompilationInfo)this.javac);
        if (dtph == null) {
            return null;
        }
        DocSourcePositions sp = (DocSourcePositions)this.javac.getTrees().getSourcePositions();
        int start = (int)sp.getStartPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), node);
        int end = (int)sp.getEndPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), node);
        Name treeName = node.getName();
        HtmlTag t = Analyzer.getTag(treeName);
        if (t == null) {
            errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.TAG_UNKNOWN(treeName), (Fix[])new Fix[0]));
        } else if (!this.isVoid(t)) {
            this.tagStack.push(node);
        }
        if (node.isSelfClosing()) {
            errors.add(ErrorDescriptionFactory.forSpan((HintContext)this.ctx, (int)start, (int)end, (String)Bundle.TAG_SELF_CLOSING(), (Fix[])new Fix[0]));
        }
        return (Void)super.visitStartElement(node, errors);
    }

    @Override
    public Void visitText(TextTree node, List<ErrorDescription> errors) {
        return (Void)super.visitText(node, errors);
    }

    @Override
    public Void visitThrows(ThrowsTree tree, List<ErrorDescription> errors) {
        boolean isType;
        boolean oldInheritDoc = this.foundInheritDoc;
        ReferenceTree exName = tree.getExceptionName();
        DocTreePath refPath = new DocTreePath(this.getCurrentPath(), tree.getExceptionName());
        Element ex = this.javac.getDocTrees().getElement(refPath);
        Types types = this.javac.getTypes();
        Elements elements = this.javac.getElements();
        TypeElement throwableEl = elements.getTypeElement("java.lang.Throwable");
        TypeElement errorEl = elements.getTypeElement("java.lang.Error");
        TypeElement runtimeEl = elements.getTypeElement("java.lang.RuntimeException");
        if (throwableEl == null || errorEl == null || runtimeEl == null) {
            LOG.warning("Broken java-platform, cannot resolve " + throwableEl == null ? "java.lang.Throwable" : (errorEl == null ? "java.lang.Error" : "java.lang.RuntimeException"));
            return null;
        }
        TypeMirror throwable = throwableEl.asType();
        TypeMirror error = errorEl.asType();
        TypeMirror runtime = runtimeEl.asType();
        DocTreePath currentDocPath = this.getCurrentPath();
        DocTreePathHandle dtph = DocTreePathHandle.create((DocTreePath)currentDocPath, (CompilationInfo)this.javac);
        if (dtph == null) {
            return null;
        }
        DocSourcePositions sp = (DocSourcePositions)this.javac.getTrees().getSourcePositions();
        int start = (int)sp.getStartPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), tree);
        int end = (int)sp.getEndPosition(this.javac.getCompilationUnit(), currentDocPath.getDocComment(), tree);
        boolean bl = isType = ex != null && (ex.asType().getKind() == TypeKind.DECLARED || ex.asType().getKind() == TypeKind.TYPEVAR);
        if (ex == null || isType && types.isAssignable(ex.asType(), throwable)) {
            switch (this.currentElement.getKind()) {
                case METHOD: 
                case CONSTRUCTOR: {
                    String fqn;
                    if (ex != null && (types.isAssignable(ex.asType(), error) || types.isAssignable(ex.asType(), runtime))) break;
                    ExecutableElement ee = (ExecutableElement)this.currentElement;
                    if (ex == null) {
                        ExpressionTree referenceClass = this.javac.getTreeUtilities().getReferenceClass(new DocTreePath(currentDocPath, exName));
                        if (referenceClass == null) break;
                        fqn = referenceClass.toString();
                    } else {
                        fqn = ex.asType().getKind() == TypeKind.TYPEVAR ? ex.getSimpleName().toString() : ((TypeElement)ex).getQualifiedName().toString();
                    }
                    this.checkThrowsDeclared(tree, ex, fqn, ee.getThrownTypes(), dtph, start, end, errors);
                    break;
                }
            }
        }
        this.warnIfEmpty(tree, tree.getDescription());
        super.visitThrows(tree, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    @Override
    public Void visitUnknownBlockTag(UnknownBlockTagTree node, List<ErrorDescription> errors) {
        boolean oldInheritDoc = this.foundInheritDoc;
        super.visitUnknownBlockTag(node, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    @Override
    public Void visitUnknownInlineTag(UnknownInlineTagTree node, List<ErrorDescription> errors) {
        return (Void)super.visitUnknownInlineTag(node, errors);
    }

    @Override
    public Void visitValue(ValueTree node, List<ErrorDescription> errors) {
        return (Void)super.visitValue(node, errors);
    }

    @Override
    public Void visitVersion(VersionTree node, List<ErrorDescription> errors) {
        boolean oldInheritDoc = this.foundInheritDoc;
        super.visitVersion(node, errors);
        this.foundInheritDoc = oldInheritDoc;
        return null;
    }

    @Override
    public Void visitOther(DocTree node, List<ErrorDescription> errors) {
        return (Void)super.visitOther(node, errors);
    }

    @Override
    public Void scan(DocTree tree, List<ErrorDescription> p) {
        if (this.ctx.isCanceled()) {
            return null;
        }
        return (Void)super.scan(tree, p);
    }

    private void findInheritedParams(ExecutableElement method, TypeElement typeElement, Set<String> inheritedParams, Set<String> inheritedTypeParams, Set<String> inheritedThrows) {
        if (typeElement == null) {
            return;
        }
        ArrayList<? extends TypeMirror> superTypes = new ArrayList<TypeMirror>();
        superTypes.add(typeElement.getSuperclass());
        superTypes.addAll(typeElement.getInterfaces());
        for (TypeMirror typeMirror : superTypes) {
            for (Element el : this.javac.getElementUtilities().getMembers(typeMirror, (e, type) -> e.getKind() == ElementKind.METHOD)) {
                ElementHandle overriddenMethod;
                FileObject source;
                if (this.ctx.isCanceled()) {
                    return;
                }
                if (!this.javac.getElements().overrides(method, (ExecutableElement)el, typeElement) || (source = SourceUtils.getFile((ElementHandle)(overriddenMethod = ElementHandle.create((Element)((ExecutableElement)el))), (ClasspathInfo)this.ctx.getInfo().getClasspathInfo())) == null) continue;
                try {
                    JavaSource.forFileObject((FileObject)source).runUserActionTask(cc -> {
                        TreePath tp;
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        if (this.ctx.isCanceled()) {
                            return;
                        }
                        ExecutableElement m = (ExecutableElement)overriddenMethod.resolve((CompilationInfo)cc);
                        TreePath treePath = tp = m != null ? cc.getTrees().getPath(m) : null;
                        if (tp == null) {
                            return;
                        }
                        DocCommentTree methodDoc = cc.getDocTrees().getDocCommentTree(tp);
                        if (methodDoc != null) {
                            for (DocTree docTree : methodDoc.getBlockTags()) {
                                switch (docTree.getKind()) {
                                    case PARAM: {
                                        String name = ((ParamTree)docTree).getName().getName().toString();
                                        if (((ParamTree)docTree).isTypeParameter()) {
                                            inheritedTypeParams.add(name);
                                            break;
                                        }
                                        inheritedParams.add(name);
                                        break;
                                    }
                                    case THROWS: {
                                        Element thrownType = cc.getDocTrees().getElement(new DocTreePath(new DocTreePath(new DocTreePath(tp, methodDoc), docTree), ((ThrowsTree)docTree).getExceptionName()));
                                        if (thrownType == null || !thrownType.getKind().isClass()) break;
                                        inheritedThrows.add(((TypeElement)thrownType).getQualifiedName().toString());
                                        break;
                                    }
                                    case RETURN: {
                                        this.returnTypeFound |= true;
                                    }
                                }
                            }
                        }
                    }, true);
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
            }
        }
    }

    private static HtmlTag getTag(Name tagName) {
        HtmlTag t = model.getTag(tagName.toString());
        return t.getTagClass() == HtmlTagType.HTML ? t : null;
    }

    private boolean isVoid(HtmlTag tag) {
        return tag.isEmpty() && !NON_VOID_TAGS.contains(tag.getName());
    }
}

