/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.options;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.options.DepScanningSettings;
import org.netbeans.modules.java.hints.spiimpl.options.HintsPanel;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Configuration;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Utilities;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.editor.hints.settings.FileHintPreferences;
import org.netbeans.spi.java.hints.Hint;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HintsPanelLogic
implements MouseListener,
KeyListener,
TreeSelectionListener,
ChangeListener,
ActionListener,
ItemListener {
    private Map<HintMetadata, ModifiedPreferences> changes = new HashMap<HintMetadata, ModifiedPreferences>();
    private DepScanningSettings.DependencyTracking depScn = null;
    private static final Map<Severity, Integer> severity2index = new EnumMap<Severity, Integer>(Severity.class);
    private static final Map<Integer, Severity> index2Severity;
    private static final Map<DepScanningSettings.DependencyTracking, Integer> deptracking2index;
    private static final String DESCRIPTION_HEADER = "<html><head></head><body>";
    private static final String DESCRIPTION_FOOTER = "</body></html>";
    private JTree errorTree;
    DefaultTreeModel errorTreeModel;
    private JLabel severityLabel;
    private JComboBox severityComboBox;
    private JCheckBox tasklistCheckBox;
    private JPanel customizerPanel;
    private JEditorPane descriptionTextArea;
    private DefaultComboBoxModel<String> defModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel<String> depScanningModel = new DefaultComboBoxModel();
    private String defLabel = NbBundle.getMessage(HintsPanel.class, (String)"CTL_ShowAs_Label");
    private String depScanningLabel = NbBundle.getMessage(HintsPanel.class, (String)"CTL_Scope_Label");
    private String depScanningDescription = NbBundle.getMessage(HintsPanel.class, (String)"CTL_Scope_Desc");
    private JComboBox configCombo;
    private JButton editScript;
    private HintsSettings originalSettings;
    WritableSettings writableSettings;
    private boolean direct;
    private boolean ignoreControlChanges;
    private static final AbstractPreferences FAKE_ROOT;

    HintsPanelLogic() {
        this.defModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AsError"));
        this.defModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AsWarning"));
        this.defModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_WarningOnCurrentLine"));
        this.depScanningModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_AllProjects"));
        this.depScanningModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_Project"));
        this.depScanningModel.addElement(NbBundle.getMessage(HintsPanel.class, (String)"CTL_SrcRoot"));
    }

    void connect(JTree errorTree, DefaultTreeModel errorTreeModel, JLabel severityLabel, JComboBox severityComboBox, JCheckBox tasklistCheckBox, JPanel customizerPanel, JEditorPane descriptionTextArea, JComboBox configCombo, JButton editScript, HintsSettings settings, boolean direct) {
        this.errorTree = errorTree;
        this.errorTreeModel = errorTreeModel;
        this.severityLabel = severityLabel;
        this.severityComboBox = severityComboBox;
        this.tasklistCheckBox = tasklistCheckBox;
        this.customizerPanel = customizerPanel;
        this.descriptionTextArea = descriptionTextArea;
        this.configCombo = configCombo;
        this.editScript = editScript;
        this.direct = direct;
        this.originalSettings = configCombo.getSelectedItem() != null ? ((Configuration)configCombo.getSelectedItem()).getSettings() : (settings != null ? settings : HintsSettings.getGlobalSettings());
        this.writableSettings = new WritableSettings(this.originalSettings, direct);
        this.valueChanged(null);
        errorTree.addKeyListener(this);
        errorTree.addMouseListener(this);
        errorTree.getSelectionModel().addTreeSelectionListener(this);
        this.configCombo.addItemListener(this);
        severityComboBox.addActionListener(this);
        tasklistCheckBox.addChangeListener(this);
    }

    void disconnect() {
        this.errorTree.removeKeyListener(this);
        this.errorTree.removeMouseListener(this);
        this.errorTree.getSelectionModel().removeTreeSelectionListener(this);
        this.severityComboBox.removeActionListener(this);
        this.tasklistCheckBox.removeChangeListener(this);
        this.configCombo.removeItemListener(this);
        this.componentsSetEnabled(false);
    }

    synchronized void setOverlayPreferences(HintsSettings settings, boolean direct) {
        this.applyChanges();
        this.originalSettings = settings != null ? settings : HintsSettings.getGlobalSettings();
        this.writableSettings = new WritableSettings(this.originalSettings, direct);
        this.valueChanged(null);
        this.errorTree.repaint();
    }

    synchronized HintsSettings getOverlayPreferences() {
        return this.originalSettings;
    }

    synchronized void applyChanges() {
        boolean containsChanges = this.writableSettings.isModified();
        this.writableSettings.commit();
        if (containsChanges) {
            FileHintPreferences.fireChange();
        }
        if (this.depScn != null) {
            DepScanningSettings.setDependencyTracking(this.depScn);
        }
    }

    boolean isChanged() {
        return this.writableSettings.isModified() || this.depScn != null && this.depScn != DepScanningSettings.getDependencyTracking();
    }

    synchronized DepScanningSettings.DependencyTracking getCurrentDependencyTracking() {
        return this.depScn != null ? this.depScn : DepScanningSettings.getDependencyTracking();
    }

    static Object getUserObject(TreePath path) {
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode tn = (DefaultMutableTreeNode)path.getLastPathComponent();
        return tn.getUserObject();
    }

    static Object getUserObject(DefaultMutableTreeNode node) {
        return node.getUserObject();
    }

    HintsPanel.State isSelected(DefaultMutableTreeNode node) {
        boolean hasEnabled = false;
        boolean hasDisabled = false;
        LinkedList<DefaultMutableTreeNode> todo = new LinkedList<DefaultMutableTreeNode>();
        todo.add(node);
        while (!todo.isEmpty()) {
            DefaultMutableTreeNode current = (DefaultMutableTreeNode)todo.remove(0);
            Object o = current.getUserObject();
            if (o instanceof HintMetadata) {
                HintMetadata hint = (HintMetadata)o;
                if (this.isEnabled(hint)) {
                    hasEnabled = true;
                    continue;
                }
                hasDisabled = true;
                continue;
            }
            if (!(o instanceof HintCategory)) continue;
            for (int i = 0; i < current.getChildCount(); ++i) {
                todo.add((DefaultMutableTreeNode)current.getChildAt(i));
            }
        }
        return hasEnabled ? (hasDisabled ? HintsPanel.State.OTHER : HintsPanel.State.SELECTED) : HintsPanel.State.NOT_SELECTED;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Rectangle r;
        Point p = e.getPoint();
        TreePath path = this.errorTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
        if (path != null && (r = this.errorTree.getPathBounds(path)) != null) {
            r.width = r.height;
            if (r.contains(p)) {
                this.toggle(path);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        JTree tree;
        TreePath path;
        if (e.getKeyCode() == 32 && e.getSource() instanceof JTree && this.toggle(path = (tree = (JTree)e.getSource()).getSelectionPath())) {
            e.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent ex) {
        Object o = HintsPanelLogic.getUserObject(this.errorTree.getSelectionPath());
        this.editScript.setEnabled(false);
        this.ignoreControlChanges = true;
        try {
            if (o instanceof HintMetadata) {
                JComponent c;
                if (this.defModel != this.severityComboBox.getModel()) {
                    this.severityComboBox.setModel(this.defModel);
                    Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)this.defLabel);
                }
                HintMetadata hint = (HintMetadata)o;
                this.componentsSetEnabled(true);
                this.editScript.setEnabled(hint.category.equals("custom"));
                if (hint.kind == Hint.Kind.ACTION) {
                    this.severityComboBox.setSelectedIndex(severity2index.get(Severity.HINT));
                    this.severityComboBox.setEnabled(false);
                } else {
                    Severity severity = this.writableSettings.getSeverity(hint);
                    if (severity != null) {
                        this.severityComboBox.setSelectedIndex(severity2index.get(severity));
                        this.severityComboBox.setEnabled(true);
                    } else {
                        this.severityComboBox.setSelectedIndex(severity2index.get(Severity.ERROR));
                        this.severityComboBox.setEnabled(false);
                    }
                }
                String description = hint.description;
                this.descriptionTextArea.setText(description == null ? "" : this.wrapDescription(description, hint));
                this.customizerPanel.removeAll();
                JComponent jComponent = c = hint.customizer != null ? hint.customizer.getCustomizer(this.writableSettings.getHintPreferences(hint)) : null;
                if (c != null) {
                    this.customizerPanel.add((Component)c, "Center");
                }
                this.customizerPanel.getParent().invalidate();
                ((JComponent)this.customizerPanel.getParent()).revalidate();
                this.customizerPanel.getParent().repaint();
            } else if (o instanceof String) {
                DepScanningSettings.DependencyTracking dt = this.getCurrentDependencyTracking();
                if (this.depScanningModel != this.severityComboBox.getModel()) {
                    this.severityComboBox.setModel(this.depScanningModel);
                    Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)this.depScanningLabel);
                }
                this.componentsSetEnabled(false);
                this.severityComboBox.setEnabled(true);
                this.descriptionTextArea.setEnabled(true);
                this.descriptionTextArea.setText(this.wrapDescription(this.depScanningDescription, null));
                this.descriptionTextArea.setCaretPosition(0);
                if (dt != DepScanningSettings.DependencyTracking.DISABLED) {
                    this.severityComboBox.setSelectedIndex(deptracking2index.get((Object)dt));
                }
            } else {
                if (this.defModel != this.severityComboBox.getModel()) {
                    this.severityComboBox.setModel(this.defModel);
                    Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)this.defLabel);
                }
                this.componentsSetEnabled(false);
            }
        }
        finally {
            this.ignoreControlChanges = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.errorTree.getSelectionPath() == null || !this.severityComboBox.equals(e.getSource()) || this.ignoreControlChanges) {
            return;
        }
        Object o = HintsPanelLogic.getUserObject(this.errorTree.getSelectionPath());
        if (o instanceof HintMetadata) {
            HintMetadata hint = (HintMetadata)o;
            if (this.writableSettings.getSeverity(hint) != null) {
                this.writableSettings.setSeverity(hint, this.index2severity(this.severityComboBox.getSelectedIndex()));
            }
        } else if (o instanceof String && this.getCurrentDependencyTracking() != DepScanningSettings.DependencyTracking.DISABLED) {
            this.depScn = this.index2deptracking(this.severityComboBox.getSelectedIndex());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    private String wrapDescription(String description, HintMetadata hint) {
        return new StringBuffer(DESCRIPTION_HEADER).append(description).append(HintsPanelLogic.getQueryWarning(hint)).append(DESCRIPTION_FOOTER).toString();
    }

    public static String getQueryWarning(HintMetadata hint) {
        if (hint == null || !hint.options.contains(HintMetadata.Options.QUERY)) {
            return "";
        }
        return NbBundle.getMessage(HintsPanelLogic.class, (String)"NO_REFACTORING");
    }

    private Severity index2severity(int index) {
        Severity s = index2Severity.get(index);
        if (s == null) {
            throw new IllegalStateException("Unknown severity");
        }
        return s;
    }

    private DepScanningSettings.DependencyTracking index2deptracking(int index) {
        for (Map.Entry<DepScanningSettings.DependencyTracking, Integer> e : deptracking2index.entrySet()) {
            if (e.getValue() != index) continue;
            return e.getKey();
        }
        throw new IllegalStateException("Unknown severity");
    }

    private boolean toggle(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        if (!(this.errorTree.getCellRenderer() instanceof HintsPanel.CheckBoxRenderer)) {
            return false;
        }
        Object o = HintsPanelLogic.getUserObject(treePath);
        DefaultTreeModel model = this.errorTreeModel;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (o instanceof HintMetadata) {
            HintMetadata hint;
            boolean value = this.isEnabled(hint = (HintMetadata)o);
            this.writableSettings.setEnabled(hint, !value);
            model.nodeChanged(node);
            model.nodeChanged(node.getParent());
        } else if (o instanceof HintCategory) {
            boolean value = this.isSelected(node) == HintsPanel.State.NOT_SELECTED;
            LinkedList<DefaultMutableTreeNode> todo = new LinkedList<DefaultMutableTreeNode>();
            todo.add(node);
            while (!todo.isEmpty()) {
                DefaultMutableTreeNode current = (DefaultMutableTreeNode)todo.remove(0);
                Object cho = current.getUserObject();
                if (cho instanceof HintMetadata) {
                    HintMetadata hint = (HintMetadata)cho;
                    boolean cv = this.isEnabled(hint);
                    if (cv == value) continue;
                    this.writableSettings.setEnabled(hint, value);
                    model.nodeChanged(current);
                    continue;
                }
                if (!(o instanceof HintCategory)) continue;
                for (int i = 0; i < current.getChildCount(); ++i) {
                    todo.add((DefaultMutableTreeNode)current.getChildAt(i));
                }
            }
            model.nodeChanged(node);
        } else if (o instanceof String) {
            DepScanningSettings.DependencyTracking value = this.getCurrentDependencyTracking();
            this.depScn = value != DepScanningSettings.DependencyTracking.DISABLED ? DepScanningSettings.DependencyTracking.DISABLED : this.index2deptracking(this.severityComboBox.getSelectedIndex());
            model.nodeChanged(node);
        }
        return false;
    }

    private void componentsSetEnabled(boolean enabled) {
        if (!enabled) {
            this.customizerPanel.removeAll();
            this.customizerPanel.getParent().invalidate();
            ((JComponent)this.customizerPanel.getParent()).revalidate();
            this.customizerPanel.getParent().repaint();
            this.severityComboBox.setSelectedIndex(severity2index.get(Severity.VERIFIER));
            this.tasklistCheckBox.setSelected(false);
            this.descriptionTextArea.setText("");
        }
        this.severityComboBox.setEnabled(enabled);
        this.tasklistCheckBox.setEnabled(enabled);
        this.descriptionTextArea.setEnabled(enabled);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object o = this.configCombo.getSelectedItem();
        if (o instanceof Configuration) {
            this.setOverlayPreferences(((Configuration)o).getSettings(), this.direct);
        }
    }

    public boolean isEnabled(HintMetadata hint) {
        return this.writableSettings.isEnabled(hint);
    }

    static {
        severity2index.put(Severity.ERROR, 0);
        severity2index.put(Severity.VERIFIER, 1);
        severity2index.put(Severity.HINT, 2);
        severity2index.put(Severity.WARNING, 1);
        index2Severity = new HashMap<Integer, Severity>();
        index2Severity.put(0, Severity.ERROR);
        index2Severity.put(1, Severity.VERIFIER);
        index2Severity.put(2, Severity.HINT);
        deptracking2index = new EnumMap<DepScanningSettings.DependencyTracking, Integer>(DepScanningSettings.DependencyTracking.class);
        deptracking2index.put(DepScanningSettings.DependencyTracking.ENABLED, 0);
        deptracking2index.put(DepScanningSettings.DependencyTracking.ENABLED_WITHIN_PROJECT, 1);
        deptracking2index.put(DepScanningSettings.DependencyTracking.ENABLED_WITHIN_ROOT, 2);
        FAKE_ROOT = new AbstractPreferences(null, ""){

            @Override
            protected void putSpi(String key, String value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            protected String getSpi(String key) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            protected void removeSpi(String key) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            protected void removeNodeSpi() throws BackingStoreException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            protected String[] keysSpi() throws BackingStoreException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            protected String[] childrenNamesSpi() throws BackingStoreException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            protected AbstractPreferences childSpi(String name) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            protected void syncSpi() throws BackingStoreException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            protected void flushSpi() throws BackingStoreException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    static final class WritableSettings
    extends HintsSettings {
        private final HintsSettings delegate;
        private final boolean direct;
        private Map<HintMetadata, ModifiedHint> changes = new HashMap<HintMetadata, ModifiedHint>();

        public WritableSettings(HintsSettings delegate, boolean direct) {
            this.delegate = delegate;
            this.direct = direct;
        }

        public boolean isEnabled(HintMetadata hint) {
            Boolean enabled;
            ModifiedHint modified = this.changes.get(hint);
            Boolean bl = enabled = modified != null ? modified.enabledOverride : null;
            if (enabled != null) {
                return enabled;
            }
            return this.delegate.isEnabled(hint);
        }

        private ModifiedHint forWriting(HintMetadata hint) {
            ModifiedHint result = this.changes.get(hint);
            if (result == null) {
                result = new ModifiedHint();
                this.changes.put(hint, result);
            }
            return result;
        }

        public void setEnabled(HintMetadata hint, boolean value) {
            if (this.direct) {
                this.delegate.setEnabled(hint, value);
            } else {
                this.forWriting(hint).enabledOverride = value;
            }
        }

        public Preferences getHintPreferences(HintMetadata hint) {
            if (this.direct) {
                return this.delegate.getHintPreferences(hint);
            }
            ModifiedPreferences prefs = this.forWriting(hint).preferencesOverride;
            if (prefs == null) {
                prefs = this.forWriting(hint).preferencesOverride = new ModifiedPreferences(this.delegate.getHintPreferences(hint));
            }
            return prefs;
        }

        public Severity getSeverity(HintMetadata hint) {
            Severity severity;
            ModifiedHint modified = this.changes.get(hint);
            Severity severity2 = severity = modified != null ? modified.severityOverride : null;
            if (severity != null) {
                return severity;
            }
            return this.delegate.getSeverity(hint);
        }

        public void setSeverity(HintMetadata hint, Severity severity) {
            if (this.direct) {
                this.delegate.setSeverity(hint, severity);
            } else {
                this.forWriting(hint).severityOverride = severity;
            }
        }

        public boolean isModified() {
            boolean isChanged = false;
            for (Map.Entry<HintMetadata, ModifiedHint> entry : this.changes.entrySet()) {
                Severity savedSeverity;
                String[] currentSeverity;
                Boolean savedEnabled;
                Boolean currentEnabled;
                HintMetadata hint = entry.getKey();
                ModifiedHint e = entry.getValue();
                if (e.enabledOverride != null && (isChanged |= (currentEnabled = e.enabledOverride) != (savedEnabled = Boolean.valueOf(this.delegate.isEnabled(hint))))) {
                    return true;
                }
                if (e.severityOverride != null && (isChanged |= (currentSeverity = e.severityOverride).compareTo((Enum)(savedSeverity = this.delegate.getSeverity(hint))) != 0)) {
                    return true;
                }
                if (e.preferencesOverride == null || e.preferencesOverride.isEmpty()) continue;
                try {
                    currentSeverity = e.preferencesOverride.keys();
                    int n = currentSeverity.length;
                    for (int i = 0; i < n; ++i) {
                        String key = currentSeverity[i];
                        String current = e.preferencesOverride.get(key, null);
                        String saved = this.delegate.getHintPreferences(hint).get(key, null);
                        if (saved == null) {
                            saved = e.preferencesOverride.getSavedValue(key);
                        }
                        boolean bl = current == null ? saved != null : !current.equals(saved);
                        if (!(isChanged |= bl)) continue;
                        return true;
                    }
                }
                catch (BackingStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return false;
        }

        public void commit() {
            for (Map.Entry<HintMetadata, ModifiedHint> e : this.changes.entrySet()) {
                if (e.getValue().preferencesOverride != null) {
                    e.getValue().preferencesOverride.store(this.delegate.getHintPreferences(e.getKey()));
                }
                if (e.getValue().enabledOverride != null) {
                    this.delegate.setEnabled(e.getKey(), e.getValue().enabledOverride.booleanValue());
                }
                if (e.getValue().severityOverride == null) continue;
                this.delegate.setSeverity(e.getKey(), e.getValue().severityOverride);
            }
            this.changes.clear();
        }

        private static final class ModifiedHint {
            private Boolean enabledOverride;
            private Severity severityOverride;
            private ModifiedPreferences preferencesOverride;

            private ModifiedHint() {
            }
        }
    }

    private static class ModifiedPreferences
    extends AbstractPreferences {
        private static final String MODIFIED_HINT_SETTINGS_MARKER = "MODIFIED_HINT_SETTINGS";
        private Map<String, Object> map = new HashMap<String, Object>();
        private final Map<String, String> mapSaved = new HashMap<String, String>();

        public ModifiedPreferences(Preferences node) {
            super(FAKE_ROOT, MODIFIED_HINT_SETTINGS_MARKER);
            try {
                for (String key : node.keys()) {
                    this.put(key, node.get(key, null));
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void store(Preferences target) {
            try {
                for (String key : this.keys()) {
                    target.put(key, this.get(key, null));
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public String getSavedValue(String key) {
            return this.mapSaved.get(key);
        }

        @Override
        protected void putSpi(String key, String value) {
            this.map.put(key, value);
            if (!this.mapSaved.containsKey(key)) {
                this.mapSaved.put(key, value);
            }
        }

        @Override
        protected String getSpi(String key) {
            return (String)this.map.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.map.remove(key);
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            String[] array = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(array);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        boolean isEmpty() {
            return this.map.isEmpty();
        }
    }

    public static final class HintCategory {
        public final String codeName;
        public final String displayName;
        public final List<HintCategory> subCategories = new ArrayList<HintCategory>();
        public final List<HintMetadata> hints = new ArrayList<HintMetadata>();

        public HintCategory(String codeName) {
            this.codeName = codeName;
            this.displayName = Utilities.categoryDisplayName(codeName);
        }
    }
}

