/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class WeakCacheMap<K, V extends KeyedValue<K>>
extends AbstractMap<K, V> {
    private final Map<Integer, List<Reference<V>>> cache = new HashMap<Integer, List<Reference<V>>>();

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (List<Reference<V>> values : this.cache.values()) {
            for (Reference<V> rv : values) {
                KeyedValue v = (KeyedValue)rv.get();
                if (!value.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Integer hash = key.hashCode();
        List<Reference<V>> values = this.cache.get(hash);
        if (values != null) {
            KeyedValue retv = null;
            LinkedList<Reference<V>> staledValues = null;
            for (Reference<V> rv : values) {
                KeyedValue v = (KeyedValue)rv.get();
                if (v == null) {
                    if (staledValues == null) {
                        staledValues = new LinkedList<Reference<V>>();
                    }
                    staledValues.add(rv);
                    continue;
                }
                if (retv != null || !key.equals(v.getKey())) continue;
                retv = v;
            }
            if (staledValues != null) {
                values.removeAll(staledValues);
            }
            return (V)retv;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Integer hash = key.hashCode();
        List<Reference<V>> values = this.cache.get(hash);
        KeyedValue existingv = null;
        if (values == null) {
            values = new LinkedList<Reference<V>>();
            this.cache.put(hash, values);
        } else {
            LinkedList<Reference<V>> staledValues = null;
            for (Reference<V> rv : values) {
                KeyedValue v = (KeyedValue)rv.get();
                if (v == null) {
                    if (staledValues == null) {
                        staledValues = new LinkedList<Reference<V>>();
                    }
                    staledValues.add(rv);
                    continue;
                }
                if (existingv != null || !key.equals(v.getKey())) continue;
                existingv = v;
                if (staledValues == null) {
                    staledValues = new LinkedList();
                }
                staledValues.add(rv);
            }
            if (staledValues != null) {
                values.removeAll(staledValues);
            }
        }
        values.add(new WeakReference<V>(value));
        return (V)existingv;
    }

    @Override
    public V remove(Object key) {
        Integer hash = key.hashCode();
        List<Reference<V>> values = this.cache.get(hash);
        if (values != null) {
            V retv = null;
            LinkedList<Reference<V>> staledValues = null;
            for (Reference<V> rv : values) {
                KeyedValue v = (KeyedValue)rv.get();
                if (v != null && (retv != null || !key.equals(v.getKey()))) continue;
                if (staledValues == null) {
                    staledValues = new LinkedList<Reference<V>>();
                }
                staledValues.add(rv);
            }
            if (staledValues != null) {
                values.removeAll(staledValues);
            }
            return retv;
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static interface KeyedValue<K> {
        public K getKey();
    }
}

