/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

public class NodePropertySupport
extends PropertySupport {
    public static final String CUSTOM_EDITOR = "NodePropertySupport.customEditor";
    public static final String NODE = "NodePropertySupport.Node";
    private BaseNode node;
    private String key;

    public NodePropertySupport(BaseNode node, String name, Class type, String displayName, String shortDescription, boolean writable) {
        super(name, type, displayName, shortDescription, true, writable);
        this.key = name;
        this.node = node;
        this.setValue(NODE, (Object)node);
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        Object result = this.node.getPropertyValue(this.key);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.node.setPropertyValue((Node.Property)this, val);
    }

    public PropertyEditor getPropertyEditor() {
        PropertyEditor result = null;
        Object potentialEditor = this.getValue(CUSTOM_EDITOR);
        if (potentialEditor instanceof PropertyEditor) {
            result = (PropertyEditor)potentialEditor;
        } else if (potentialEditor instanceof Class) {
            try {
                potentialEditor = ((Class)potentialEditor).newInstance();
                if (!(potentialEditor instanceof PropertyEditor)) {
                    throw new IllegalArgumentException("Editor class does not derive from property editor");
                }
                return (PropertyEditor)potentialEditor;
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (result == null) {
            result = super.getPropertyEditor();
        }
        return result;
    }
}

