/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project;

import org.netbeans.api.project.Project;
import org.netbeans.modules.fish.payara.micro.project.DeployOnSaveManager;
import org.netbeans.modules.fish.payara.micro.project.MicroApplication;
import org.netbeans.modules.fish.payara.micro.project.MicroIcon;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.j2ee.ProjectHookImpl;
import org.netbeans.modules.maven.spi.nodes.SpecialIcon;

public class MicroProjectHook
extends ProjectHookImpl {
    private final Project project;

    public MicroProjectHook(Project project) {
        super(project);
        this.project = project;
    }

    public void projectOpened() {
        if (MicroApplication.getInstance(this.project) != null) {
            this.addDeployOnSaveManager(this.project);
            this.updateMicroIcon();
        }
    }

    public void projectClosed() {
        if (MicroApplication.getInstance(this.project) != null) {
            this.removeDeployOnSaveManager(this.project);
        }
    }

    private void updateMicroIcon() {
        SpecialIcon specialIcon = (SpecialIcon)this.project.getLookup().lookup(SpecialIcon.class);
        if (!(specialIcon instanceof MicroIcon)) {
            return;
        }
        MicroIcon microIcon = (MicroIcon)specialIcon;
        microIcon.setProject(this.project);
    }

    private void addDeployOnSaveManager(Project project) {
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (moduleProvider != null) {
            DeployOnSaveManager.getDefault().startListening(project, moduleProvider);
        }
    }

    private void removeDeployOnSaveManager(Project project) {
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (moduleProvider != null) {
            DeployOnSaveManager.getDefault().stopListening(project, moduleProvider);
        }
    }
}

