/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.autoupdate;

import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.spi.autoupdate.PluginInstallerImplementation;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.UserCancelException;

public final class PluginInstaller {
    private static final Logger LOG = Logger.getLogger(PluginInstaller.class.getName());
    private static PluginInstaller INSTANCE;

    public static PluginInstaller getDefault() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = new PluginInstaller();
        return INSTANCE;
    }

    public Object install(@NonNull String codenamebase, @NonNull String displayName, Lookup context, Object ... alternativeOptions) {
        try {
            return this.install(Collections.singleton(codenamebase), displayName, context, alternativeOptions);
        }
        catch (UserCancelException ex) {
            LOG.log(Level.FINE, "User cancelled", ex);
            return NotifyDescriptor.CANCEL_OPTION;
        }
        catch (OperationException ex) {
            LOG.log(Level.WARNING, "Exception during install of " + codenamebase, ex);
            return NotifyDescriptor.CANCEL_OPTION;
        }
    }

    public Object install(@NonNull String codenamebase) {
        return this.install(codenamebase, null, null, new Object[0]);
    }

    public Object install(@NonNull Set<String> codenamebases, String displayName, Lookup context, Object ... alternativeOptions) throws OperationException, UserCancelException {
        PluginInstallerImplementation impl = (PluginInstallerImplementation)Lookup.getDefault().lookup(PluginInstallerImplementation.class);
        if (impl == null) {
            throw new UserCancelException();
        }
        Object o = impl.install(codenamebases, displayName, context == null ? Lookup.EMPTY : context, alternativeOptions);
        if (o == NotifyDescriptor.CLOSED_OPTION) {
            return NotifyDescriptor.CANCEL_OPTION;
        }
        return o;
    }
}

