/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeData;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.Document;
import org.netbeans.tax.spec.DocumentFragment;
import org.netbeans.tax.spec.DocumentType;
import org.netbeans.tax.spec.Element;
import org.netbeans.tax.spec.GeneralEntityReference;
import org.netbeans.tax.spec.ParameterEntityReference;

public class TreeProcessingInstruction
extends TreeData
implements Document.Child,
DocumentFragment.Child,
Element.Child,
GeneralEntityReference.Child,
DTD.Child,
ParameterEntityReference.Child,
DocumentType.Child,
ConditionalSection.Child {
    public static final String PROP_TARGET = "target";
    private String target;

    public TreeProcessingInstruction(String target, String data) throws InvalidArgumentException {
        super(data);
        this.checkTarget(target);
        this.target = target;
    }

    protected TreeProcessingInstruction(TreeProcessingInstruction processingInstruction) {
        super(processingInstruction);
        this.target = processingInstruction.target;
    }

    @Override
    public Object clone() {
        return new TreeProcessingInstruction(this);
    }

    @Override
    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeProcessingInstruction peer = (TreeProcessingInstruction)object;
        return Util.equals(this.getTarget(), peer.getTarget());
    }

    @Override
    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeProcessingInstruction peer = (TreeProcessingInstruction)treeObject;
        this.setTargetImpl(peer.getTarget());
    }

    @Override
    protected final void checkData(String data) throws InvalidArgumentException {
        TreeUtilities.checkProcessingInstructionData(data);
    }

    @Override
    protected TreeData createData(String data) throws InvalidArgumentException {
        return new TreeProcessingInstruction(this.target, data);
    }

    public final String getTarget() {
        return this.target;
    }

    private final void setTargetImpl(String newTarget) {
        String oldTarget = this.target;
        this.target = newTarget;
        this.firePropertyChange(PROP_TARGET, oldTarget, newTarget);
    }

    public final void setTarget(String newTarget) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.target, newTarget)) {
            return;
        }
        this.checkReadOnly();
        this.checkTarget(newTarget);
        this.setTargetImpl(newTarget);
    }

    public final void checkTarget(String target) throws InvalidArgumentException {
        TreeUtilities.checkProcessingInstructionTarget(target);
    }
}

