/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper.swing;

import java.awt.Toolkit;
import javax.swing.JButton;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;

public class NbiButton
extends JButton {
    public static final String DEFAULT_TEXT = " ";
    public static final char DEFAULT_MNEMONIC = '\u0000';
    private static final String WINDOWS_XP_THEME_MARKER_PROPERTY = "win.xpstyle.themeActive";

    public NbiButton() {
        boolean xpThemeActive;
        Object object;
        if (SystemUtils.isWindows() && (object = Toolkit.getDefaultToolkit().getDesktopProperty(WINDOWS_XP_THEME_MARKER_PROPERTY)) != null && (xpThemeActive = ((Boolean)object).booleanValue())) {
            this.setOpaque(false);
        }
        this.setText(DEFAULT_TEXT);
        this.setMnemonic('\u0000');
    }

    @Override
    public void setText(String text) {
        super.setText(StringUtils.stripMnemonic(text));
        if (!SystemUtils.isMacOS()) {
            super.setMnemonic(StringUtils.fetchMnemonic(text));
        }
    }
}

