/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.ant.UpdateImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateProjectImpl
implements UpdateImplementation {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("webproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private Boolean isCurrent;
    private final AuxiliaryConfiguration cfg;
    private boolean alreadyAskedInWriteAccess;
    private final Project project;
    private final AntProjectHelper helper;
    private Element cachedElement;
    private static final String TAG_FILE = "file";
    private static final String TAG_LIBRARY = "library";
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";

    UpdateProjectImpl(Project project, AntProjectHelper helper, AuxiliaryConfiguration cfg) {
        assert (project != null && helper != null && cfg != null);
        this.project = project;
        this.helper = helper;
        this.cfg = cfg;
    }

    public boolean isCurrent() {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (UpdateProjectImpl.this.isCurrent == null) {
                        UpdateProjectImpl.this.isCurrent = UpdateProjectImpl.this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-earproject/1", true) == null ? Boolean.TRUE : Boolean.FALSE;
                    }
                    return UpdateProjectImpl.this.isCurrent;
                }
            }
        });
    }

    public boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean canUpdate = this.showUpdateDialog();
        if (!canUpdate) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                @Override
                public void run() {
                    UpdateProjectImpl.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return canUpdate;
    }

    private boolean showUpdateDialog() {
        JButton updateOption = new JButton(NbBundle.getMessage(UpdateProjectImpl.class, (String)"CTL_UpdateOption"));
        return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUpdate(EditableProperties props) throws IOException {
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-earproject/1", true);
        ProjectManager.getDefault().saveProject(this.project);
        UpdateProjectImpl updateProjectImpl = this;
        synchronized (updateProjectImpl) {
            this.isCurrent = Boolean.TRUE;
        }
    }

    public Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            String ns = "http://www.netbeans.org/ns/j2ee-earproject/2";
            Element oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-earproject/1", true);
            if (oldRoot != null) {
                Document doc = oldRoot.getOwnerDocument();
                Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "data");
                XMLUtil.copyDocument((Element)oldRoot, (Element)newRoot, (String)"http://www.netbeans.org/ns/j2ee-earproject/2");
                NodeList libList = newRoot.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", TAG_LIBRARY);
                for (int i = 0; i < libList.getLength(); ++i) {
                    if (libList.item(i).getNodeType() != 1) continue;
                    Element library = (Element)libList.item(i);
                    Node webFile = library.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", TAG_FILE).item(0);
                    String webFileText = XMLUtil.findText((Node)webFile);
                    if (!(webFileText = webFileText.substring(2, webFileText.length() - 1)).startsWith("libs.")) continue;
                    String libName = webFileText.substring(5, webFileText.indexOf(".classpath"));
                    List roots = LibraryManager.getDefault().getLibrary(libName).getContent("classpath");
                    ArrayList<FileObject> files = new ArrayList<FileObject>();
                    ArrayList<FileObject> dirs = new ArrayList<FileObject>();
                    for (URL rootUrl : roots) {
                        FileObject root = URLMapper.findFileObject((URL)rootUrl);
                        if ("jar".equals(rootUrl.getProtocol())) {
                            root = FileUtil.getArchiveFile((FileObject)root);
                        }
                        if (root == null) continue;
                        if (root.isData()) {
                            files.add(root);
                            continue;
                        }
                        dirs.add(root);
                    }
                    if (files.size() > 0) {
                        library.setAttribute(ATTR_FILES, "" + files.size());
                    }
                    if (dirs.size() <= 0) continue;
                    library.setAttribute(ATTR_DIRS, "" + dirs.size());
                }
                this.cachedElement = newRoot;
            }
        }
        return this.cachedElement;
    }

    public EditableProperties getUpdatedProjectProperties() {
        return this.helper.getProperties("nbproject/project.properties");
    }
}

