/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.repository;

import java.util.Collection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.bugtracking.commons.NBBugzillaUtils;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugzilla.commands.ValidateCommand;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.NBLoginPanel;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.team.spi.TeamAccessor;
import org.netbeans.modules.team.spi.TeamAccessorUtils;
import org.openide.util.NbBundle;

public class NBRepositorySupport
extends BugzillaRepository {
    private static final String NB_BUGZILLA_HOST = "netbeans.org";
    public static final String NB_BUGZILLA_URL = "https://netbeans.org/bugzilla";
    public static final String URL_NB_ORG_SIGNUP = "https://netbeans.org/people/new";
    private static NBRepositorySupport instance;
    private BugzillaRepository bugzillaRepository;
    private Repository nbRepository;
    private boolean isTeam;

    private NBRepositorySupport() {
    }

    public static synchronized NBRepositorySupport getInstance() {
        if (instance == null) {
            instance = new NBRepositorySupport();
        }
        return instance;
    }

    public Repository getNBRepository(boolean checkLogin) {
        Collection repos;
        boolean registered = false;
        if (this.nbRepository != null) {
            if (!this.isTeam) {
                repos = RepositoryManager.getInstance().getRepositories("org.netbeans.modules.bugzilla");
                for (Repository repo : repos) {
                    if (!NBBugzillaUtils.isNbRepository((String)repo.getUrl())) continue;
                    registered = true;
                    break;
                }
                if (!registered) {
                    this.nbRepository = null;
                }
            }
            if (registered) {
                return this.nbRepository;
            }
        }
        repos = RepositoryManager.getInstance().getRepositories("org.netbeans.modules.bugzilla");
        for (Repository repo : repos) {
            if (!NBBugzillaUtils.isNbRepository((String)repo.getUrl())) continue;
            this.nbRepository = repo;
            return repo;
        }
        if (NBRepositorySupport.isNBTeamServerRegistered()) {
            this.isTeam = true;
            this.nbRepository = this.createRepositoryIntern(checkLogin);
        }
        if (this.nbRepository == null) {
            this.nbRepository = this.createRepositoryIntern(checkLogin);
        }
        return this.nbRepository;
    }

    public void setNBBugzillaRepository(BugzillaRepository repo) {
        this.bugzillaRepository = repo;
    }

    public BugzillaRepository getNBBugzillaRepository(boolean checkLogin) {
        if (this.bugzillaRepository == null) {
            this.getNBRepository(checkLogin);
        }
        return this.bugzillaRepository;
    }

    private Repository createRepositoryIntern(boolean checkLogin) {
        char[] password = NBBugzillaUtils.getNBPassword();
        String username = NBBugzillaUtils.getNBUsername();
        String name = NbBundle.getMessage(NBRepositorySupport.class, (String)"LBL_NBRepository");
        RepositoryInfo info = new RepositoryInfo("NetbeansRepository" + System.currentTimeMillis(), "org.netbeans.modules.bugzilla", NB_BUGZILLA_URL, NbBundle.getMessage(NBRepositorySupport.class, (String)"LBL_NBRepository"), NbBundle.getMessage(NBRepositorySupport.class, (String)"LBL_RepositoryTooltip", (Object[])new Object[]{name, username, NB_BUGZILLA_URL}), username, null, password, null);
        BugzillaRepository repo = new BugzillaRepository(info);
        if (checkLogin && !NBRepositorySupport.checkLogin(repo)) {
            return null;
        }
        this.bugzillaRepository = repo;
        return BugzillaUtil.getRepository(this.bugzillaRepository);
    }

    private static boolean isNBTeamServerRegistered() {
        for (TeamAccessor ka : TeamAccessorUtils.getTeamAccessors()) {
            if (!ka.isNBTeamServerRegistered()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkLogin(BugzillaRepository repo) {
        if (repo.getUsername() != null && !repo.getUsername().equals("")) {
            return true;
        }
        String errorMsg = NbBundle.getMessage(NBLoginPanel.class, (String)"MSG_MISSING_USERNAME_PASSWORD");
        while (NBLoginPanel.show(repo, errorMsg)) {
            ValidateCommand cmd = new ValidateCommand(repo.getTaskRepository());
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(NBLoginPanel.class, (String)"MSG_CONNECTING_2_NBORG"));
            handle.start();
            try {
                repo.getExecutor().execute(cmd, false, false, false);
            }
            finally {
                handle.finish();
            }
            if (cmd.hasFailed()) {
                errorMsg = cmd.getErrorMessage();
                continue;
            }
            return true;
        }
        repo.setCredentials(null, null, null, null);
        return false;
    }
}

