/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.impl.ProjectColorTabDecorator;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.impl.TabDataRenderer;
import org.netbeans.swing.popupswitcher.SwitcherTable;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.awt.CloseButtonFactory;
import org.openide.windows.TopComponent;

class DocumentSwitcherTable
extends SwitcherTable {
    private final JButton btnClose;
    private final Controller controller;
    private final ProjectColorTabDecorator decorator;
    private final ItemBorder ITEM_BORDER = new ItemBorder();
    private final Border SEPARATOR_BORDER = BorderFactory.createEmptyBorder(2, 2, 0, 5);
    private int lastRow = -1;
    private int lastCol = -1;
    private boolean inCloseButtonRect = false;
    private static final SwitcherTableItem.Activatable NONACTIVATABLE = new SwitcherTableItem.Activatable(){

        public void activate() {
        }
    };
    static final Item NO_PROJECT_SEPARATOR = new Item("<no project>", "<html><b>&lt;no project&gt;", null, null);

    public DocumentSwitcherTable(Controller controller, SwitcherTableItem[] items, int y) {
        super(items, y);
        this.controller = controller;
        this.btnClose = this.createCloseButton();
        this.decorator = Settings.getDefault().isSameProjectSameColor() ? new ProjectColorTabDecorator() : null;
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
    }

    public Item getSelectedItem() {
        Item res = (Item)((Object)this.getValueAt(this.getSelectedRow(), this.getSelectedColumn()));
        return res;
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        TabData tab;
        Item item = (Item)((Object)this.getModel().getValueAt(row, column));
        boolean selected = row == this.getSelectedRow() && column == this.getSelectedColumn() && item != null;
        boolean separator = null != item && item.isSeparator();
        this.ITEM_BORDER.color = null;
        Component renComponent = super.prepareRenderer(renderer, row, column);
        JLabel lbl = null;
        if (renComponent instanceof JLabel) {
            lbl = (JLabel)renComponent;
            if (separator) {
                lbl.setBorder(this.SEPARATOR_BORDER);
                lbl.setIcon(null);
                lbl.setText(item.getHtmlName());
            } else {
                lbl.setBorder(this.ITEM_BORDER);
            }
        }
        if (selected) {
            JPanel res = new JPanel(new BorderLayout(5, 0));
            res.add(renComponent, "Center");
            if (separator || TabDataRenderer.isClosable(item.getTabData())) {
                res.add((Component)this.btnClose, "East");
            }
            res.setBackground(renComponent.getBackground());
            return res;
        }
        if (null != this.decorator && null != item && !selected && null != (tab = item.getTabData())) {
            this.ITEM_BORDER.color = this.decorator.getBackground(tab, selected);
        }
        return renComponent;
    }

    boolean onMouseEvent(MouseEvent e) {
        Point p = e.getPoint();
        p = SwingUtilities.convertPoint((Component)e.getSource(), p, (Component)((Object)this));
        int selRow = this.getSelectedRow();
        int selCol = this.getSelectedColumn();
        if (selRow < 0 || selCol < 0) {
            return false;
        }
        Rectangle rect = this.getCellRect(selRow, selCol, false);
        if (rect.contains(p)) {
            Dimension size = this.btnClose.getPreferredSize();
            int x = rect.x + rect.width - size.width;
            int y = rect.y + (rect.height - size.height) / 2;
            Rectangle btnRect = new Rectangle(x, y, size.width, size.height);
            boolean inButton = btnRect.contains(p);
            boolean mustRepaint = this.inCloseButtonRect != inButton;
            this.inCloseButtonRect = inButton;
            if (inButton && e.getID() == 501) {
                Item item = (Item)((Object)this.getModel().getValueAt(selRow, selCol));
                TabData tab = item.getTabData();
                int tabSize = this.controller.getTabModel().size();
                int tabIndex = this.controller.getTabModel().indexOf(tab);
                if (tabIndex >= 0) {
                    TabActionEvent tae = new TabActionEvent((Object)this, "close", tabIndex);
                    this.controller.postActionEvent(tae);
                    return tabSize == 1;
                }
                if (item.isSeparator()) {
                    return this.closeSelectedDocumentList();
                }
            }
            if (mustRepaint && this.lastRow == selRow && this.lastCol == selCol) {
                this.repaint(btnRect);
            }
            this.lastCol = selCol;
            this.lastRow = selRow;
            return inButton;
        }
        return false;
    }

    public String getToolTipText(MouseEvent event) {
        int row = this.rowAtPoint(event.getPoint());
        int col = this.columnAtPoint(event.getPoint());
        if (row >= 0 && col <= 0) {
            SwitcherTableItem item = (SwitcherTableItem)this.getModel().getValueAt(row, col);
            return item.getDescription();
        }
        return null;
    }

    boolean closeSelectedDocumentList() {
        ArrayList tabs = new ArrayList(this.controller.getTabModel().getTabs());
        Item item = (Item)((Object)this.getModel().getValueAt(this.getSelectedRow(), this.getSelectedColumn()));
        ProjectSupport.ProjectProxy project = item.getProject();
        ProjectSupport projectSupport = ProjectSupport.getDefault();
        int numOfOtherTabs = 0;
        for (TabData tab : tabs) {
            ProjectSupport.ProjectProxy projectForTab = projectSupport.getProjectForTab(tab);
            if (project == null && projectForTab == null || projectForTab != null && projectForTab.equals(project)) {
                Component tabComponent = tab.getComponent();
                if (tabComponent instanceof TopComponent) {
                    TopComponent curTC = (TopComponent)tabComponent;
                    if (!DocumentSwitcherTable.isClosingEnabled(curTC)) continue;
                    curTC.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
                    if (curTC.close()) continue;
                    break;
                }
                int tabIndex = this.controller.getTabModel().indexOf(tab);
                TabActionEvent tae = new TabActionEvent((Object)this, "close", tabIndex);
                this.controller.postActionEvent(tae);
                continue;
            }
            ++numOfOtherTabs;
        }
        return numOfOtherTabs == 0;
    }

    private static boolean isClosingEnabled(TopComponent tc) {
        return !Boolean.TRUE.equals(tc.getClientProperty((Object)"netbeans.winsys.tc.closing_disabled"));
    }

    private JButton createCloseButton() {
        Icon rolloverIcon;
        JButton res = CloseButtonFactory.createBigCloseButton();
        res.setModel(new DefaultButtonModel(){

            @Override
            public boolean isRollover() {
                return DocumentSwitcherTable.this.inCloseButtonRect;
            }
        });
        Icon defaultIcon = UIManager.getIcon("nb.popupswitcher.closebutton.defaultIcon");
        if (null != defaultIcon) {
            res.setIcon(defaultIcon);
        }
        if (null != (rolloverIcon = UIManager.getIcon("nb.popupswitcher.closebutton.rolloverIcon"))) {
            res.setRolloverIcon(rolloverIcon);
        }
        return res;
    }

    private static class ItemBorder
    implements Border {
        private Color color;

        private ItemBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (null != this.color) {
                g.setColor(this.color);
                g.fillRect(x, y, 5, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 5, 0, 5);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    static class Item
    extends SwitcherTableItem {
        private final TabData tabData;
        private final ProjectSupport.ProjectProxy project;
        private final boolean isSeparator;

        public Item(SwitcherTableItem.Activatable activatable, String name, String htmlName, TabData tab, boolean active, ProjectSupport.ProjectProxy project) {
            super(activatable, name, htmlName, tab.getIcon(), active, tab.getTooltip());
            this.tabData = tab;
            this.project = project;
            this.isSeparator = false;
        }

        public static Item create(ProjectSupport.ProjectProxy project) {
            String projectFolder = null;
            projectFolder = project.getPath();
            return new Item(project.getDisplayName(), "<html><b>" + project.getDisplayName(), projectFolder, project);
        }

        private Item(String name, String htmlName, String tooltip, ProjectSupport.ProjectProxy project) {
            super(NONACTIVATABLE, name, htmlName, null, false, tooltip);
            this.tabData = null;
            this.project = project;
            this.isSeparator = true;
        }

        public TabData getTabData() {
            return this.tabData;
        }

        public boolean isSeparator() {
            return this.isSeparator;
        }

        public int compareTo(Object o) {
            if (o instanceof Item) {
                ProjectSupport.ProjectProxy otherProject = ((Item)((Object)o)).project;
                if (null == this.project && null != otherProject) {
                    return 1;
                }
                if (null != this.project && null == otherProject) {
                    return -1;
                }
                if (null != this.project && null != otherProject) {
                    int res = this.project.getDisplayName().compareTo(otherProject.getDisplayName());
                    if (res != 0) {
                        return res;
                    }
                    res = this.project.getPath().compareTo(otherProject.getPath());
                    if (res != 0) {
                        return res;
                    }
                }
            }
            return super.compareTo(o);
        }

        ProjectSupport.ProjectProxy getProject() {
            return this.project;
        }
    }
}

