/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.devops.model.RepositoryRef;
import com.oracle.bmc.devops.requests.PutRepositoryRefRequest;
import com.oracle.bmc.devops.responses.PutRepositoryRefResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutRepositoryRefConverter {
    private static final Logger LOG = LoggerFactory.getLogger(PutRepositoryRefConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static PutRepositoryRefRequest interceptRequest(PutRepositoryRefRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, PutRepositoryRefRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRefName(), (String)"refName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getPutRepositoryRefDetails(), (String)"putRepositoryRefDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20210630").path("repositories").path(HttpUtils.encodePathSegment((String)request.getRepositoryId())).path("refs").path(HttpUtils.encodePathSegment((String)request.getRefName()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, PutRepositoryRefResponse> fromResponse() {
        Function<Response, PutRepositoryRefResponse> transformer = new Function<Response, PutRepositoryRefResponse>(){

            public PutRepositoryRefResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcWorkRequestIdHeader;
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.devops.responses.PutRepositoryRefResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(RepositoryRef.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                PutRepositoryRefResponse.Builder builder = PutRepositoryRefResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.repositoryRef((RepositoryRef)response.getItem());
                Optional locationHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"location");
                if (locationHeader.isPresent()) {
                    builder.location((String)HeaderUtils.toValue((String)"location", (String)((String)((List)locationHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                PutRepositoryRefResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

