/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.devops.model.DevopsCodeRepositoryBuildSource;
import com.oracle.bmc.devops.model.GithubBuildSource;
import com.oracle.bmc.devops.model.GitlabBuildSource;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="connectionType", defaultImpl=BuildSource.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=GithubBuildSource.class, name="GITHUB"), @JsonSubTypes.Type(value=DevopsCodeRepositoryBuildSource.class, name="DEVOPS_CODE_REPOSITORY"), @JsonSubTypes.Type(value=GitlabBuildSource.class, name="GITLAB")})
@JsonFilter(value="explicitlySetFilter")
public class BuildSource {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="repositoryUrl")
    private final String repositoryUrl;
    @JsonProperty(value="branch")
    private final String branch;

    public String getName() {
        return this.name;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildSource)) {
            return false;
        }
        BuildSource other = (BuildSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$repositoryUrl = this.getRepositoryUrl();
        String other$repositoryUrl = other.getRepositoryUrl();
        if (this$repositoryUrl == null ? other$repositoryUrl != null : !this$repositoryUrl.equals(other$repositoryUrl)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        return !(this$branch == null ? other$branch != null : !this$branch.equals(other$branch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $repositoryUrl = this.getRepositoryUrl();
        result = result * 59 + ($repositoryUrl == null ? 43 : $repositoryUrl.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        return result;
    }

    public String toString() {
        return "BuildSource(name=" + this.getName() + ", repositoryUrl=" + this.getRepositoryUrl() + ", branch=" + this.getBranch() + ")";
    }

    @ConstructorProperties(value={"name", "repositoryUrl", "branch"})
    @Deprecated
    protected BuildSource(String name, String repositoryUrl, String branch) {
        this.name = name;
        this.repositoryUrl = repositoryUrl;
        this.branch = branch;
    }

    public static enum ConnectionType {
        Github("GITHUB"),
        Gitlab("GITLAB"),
        DevopsCodeRepository("DEVOPS_CODE_REPOSITORY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConnectionType> map;

        private ConnectionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConnectionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConnectionType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConnectionType.class);
            map = new HashMap<String, ConnectionType>();
            for (ConnectionType v : ConnectionType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

