/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.php.editor.actions.ImportData;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class FixImportsBottomPanel
extends JPanel {
    private final JComboBox[] comboBoxes;
    private final ImportData importData;
    private ImportData.ItemVariant[] defaultVariants;
    private ImportData.ItemVariant[] dontUseVariants;
    private static final long serialVersionUID = 7771810767310773171L;
    private JButton clearSuggestionsButton;
    private JCheckBox putInPSR12OrderCheckBox;
    private JCheckBox removeUnusedImportsCheckBox;
    private JButton restoreDefaultsButton;

    public FixImportsBottomPanel(JComboBox[] comboBoxes, ImportData importData) {
        this.comboBoxes = comboBoxes;
        this.importData = importData;
        this.initComponents();
        this.init();
    }

    private void init() {
        int numberOfItems = this.importData.getItems().size();
        this.defaultVariants = new ImportData.ItemVariant[numberOfItems];
        this.dontUseVariants = new ImportData.ItemVariant[numberOfItems];
        for (int i = 0; i < numberOfItems; ++i) {
            ImportData.DataItem dataItem = this.importData.getItems().get(i);
            this.defaultVariants[i] = dataItem.getDefaultVariant();
            this.dontUseVariants[i] = dataItem.getDefaultVariant();
            for (ImportData.ItemVariant variant : dataItem.getVariants()) {
                if (variant.canBeUsed()) continue;
                this.dontUseVariants[i] = variant;
            }
        }
    }

    public boolean removeUnusedImports() {
        return this.removeUnusedImportsCheckBox.isSelected();
    }

    public boolean isPSR12Order() {
        return this.putInPSR12OrderCheckBox.isSelected();
    }

    public void setRemoveUnusedImports(boolean removeUnusedImports) {
        this.removeUnusedImportsCheckBox.setSelected(removeUnusedImports);
    }

    public void setPSR12Order(boolean isPSR12Order) {
        this.putInPSR12OrderCheckBox.setSelected(isPSR12Order);
    }

    private void initComponents() {
        this.removeUnusedImportsCheckBox = new JCheckBox();
        this.putInPSR12OrderCheckBox = new JCheckBox();
        this.clearSuggestionsButton = new JButton();
        this.restoreDefaultsButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.removeUnusedImportsCheckBox, (String)NbBundle.getMessage(FixImportsBottomPanel.class, (String)"FixImportsBottomPanel.removeUnusedImportsCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.putInPSR12OrderCheckBox, (String)NbBundle.getMessage(FixImportsBottomPanel.class, (String)"FixImportsBottomPanel.putInPSR12OrderCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.clearSuggestionsButton, (String)NbBundle.getMessage(FixImportsBottomPanel.class, (String)"FixImportsBottomPanel.clearSuggestionsButton.text"));
        this.clearSuggestionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixImportsBottomPanel.this.clearSuggestionsButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.restoreDefaultsButton, (String)NbBundle.getMessage(FixImportsBottomPanel.class, (String)"FixImportsBottomPanel.restoreDefaultsButton.text"));
        this.restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixImportsBottomPanel.this.restoreDefaultsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.removeUnusedImportsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.putInPSR12OrderCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.clearSuggestionsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.restoreDefaultsButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeUnusedImportsCheckBox).addComponent(this.clearSuggestionsButton).addComponent(this.restoreDefaultsButton).addComponent(this.putInPSR12OrderCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        this.removeUnusedImportsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FixImportsBottomPanel.class, (String)"FixImportsBottomPanel.removeUnusedImportsCheckBox.AccessibleContext.accessibleDescription"));
        this.putInPSR12OrderCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FixImportsBottomPanel.class, (String)"FixImportsBottomPanel.putInPSR12OrderCheckBox.AccessibleContext.accessibleDescription"));
    }

    private void clearSuggestionsButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.comboBoxes.length; ++i) {
            this.comboBoxes[i].setSelectedItem(this.dontUseVariants[i]);
        }
    }

    private void restoreDefaultsButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.comboBoxes.length; ++i) {
            this.comboBoxes[i].setSelectedItem(this.defaultVariants[i]);
        }
    }
}

