/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.actions.UsedNamespaceName;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

public class UsedNamesCollector {
    private final PHPParseResult parserResult;
    private final int caretPosition;
    private Map<String, List<UsedNamespaceName>> possibleNames;
    private static final List<String> SPECIAL_NAMES = new LinkedList<String>();

    public UsedNamesCollector(PHPParseResult parserResult, int caretPosition) {
        this.parserResult = parserResult;
        this.caretPosition = caretPosition;
    }

    public Map<String, List<UsedNamespaceName>> collectNames() {
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this.parserResult.getModel().getFileScope(), this.caretPosition);
        assert (namespaceScope != null);
        OffsetRange offsetRange = namespaceScope.getBlockRange();
        NamespaceNameVisitor namespaceNameVisitor = new NamespaceNameVisitor(offsetRange, namespaceScope);
        this.parserResult.getProgram().accept(namespaceNameVisitor);
        this.possibleNames = namespaceNameVisitor.getExistingNames();
        return this.filterNamesWithoutUses(namespaceNameVisitor.getScopeMap());
    }

    private Map<String, List<UsedNamespaceName>> filterNamesWithoutUses(Map<String, NamespaceScope> scopeMap) {
        LinkedHashMap<String, List<UsedNamespaceName>> result = new LinkedHashMap<String, List<UsedNamespaceName>>();
        for (Map.Entry<String, List<UsedNamespaceName>> entry : this.possibleNames.entrySet()) {
            if (this.existsUseForTypeName(scopeMap.get(entry.getKey()).getAllDeclaredSingleUses(), QualifiedName.create(entry.getKey()))) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private boolean existsUseForTypeName(Collection<? extends UseScope> declaredUses, QualifiedName typeName) {
        boolean result = false;
        String firstSegmentName = typeName.getSegments().getFirst();
        for (UseScope useScope : declaredUses) {
            AliasedName aliasName = useScope.getAliasedName();
            if (aliasName != null) {
                if (!firstSegmentName.equals(aliasName.getAliasName())) continue;
                result = true;
                break;
            }
            QualifiedName declaredName = QualifiedName.create(useScope.getName());
            if (!declaredName.getSegments().getLast().equals(firstSegmentName)) continue;
            result = true;
            break;
        }
        return result;
    }

    static {
        SPECIAL_NAMES.add("parent");
        SPECIAL_NAMES.add("self");
        SPECIAL_NAMES.add("static");
    }

    private static class NamespaceDeclarationVisitor
    extends DefaultVisitor {
        private final List<NamespaceDeclaration> globalNamespaceDeclarations = new ArrayList<NamespaceDeclaration>();

        private NamespaceDeclarationVisitor() {
        }

        public List<NamespaceDeclaration> getGlobalNamespaceDeclarations() {
            return Collections.unmodifiableList(this.globalNamespaceDeclarations);
        }

        @Override
        public void visit(NamespaceDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isBracketed() && node.getName() == null) {
                this.globalNamespaceDeclarations.add(node);
            }
            super.visit(node);
        }
    }

    private static class NamespaceNameVisitor
    extends DefaultVisitor {
        private final OffsetRange offsetRange;
        private final Map<String, NamespaceScope> scopeMap = new HashMap<String, NamespaceScope>();
        private final Map<String, List<UsedNamespaceName>> existingNames = new LinkedHashMap<String, List<UsedNamespaceName>>();
        private final NamespaceScope namespaceScope;
        private NamespaceScope currentScope;

        public NamespaceNameVisitor(OffsetRange offsetRange, NamespaceScope namespaceScope) {
            this.offsetRange = offsetRange;
            this.namespaceScope = namespaceScope;
        }

        @Override
        public void scan(ASTNode node) {
            if (this.isNodeForScan(node)) {
                super.scan(node);
            }
        }

        private boolean isNodeForScan(ASTNode node) {
            return node != null && this.isInNamespace(node) && !(node instanceof UseStatement);
        }

        private boolean isInNamespace(ASTNode node) {
            return this.offsetRange.containsInclusive(node.getStartOffset()) || this.offsetRange.containsInclusive(node.getEndOffset());
        }

        @Override
        public void visit(Program node) {
            this.currentScope = this.namespaceScope;
            this.scan(node.getStatements());
            this.scan(node.getComments());
        }

        @Override
        public void visit(NamespaceDeclaration node) {
            if (this.namespaceScope.isDefaultNamespace()) {
                this.currentScope = ModelUtils.getNamespaceScope(this.namespaceScope.getFileScope(), node.getBody().getStartOffset());
            }
            this.scan(node.getBody());
        }

        @Override
        public void visit(NamespaceName node) {
            UsedNamespaceName usedName = new UsedNamespaceName(node, this.currentScope);
            if (this.isValidTypeName(usedName.getName())) {
                this.processUsedName(usedName);
            }
        }

        @Override
        public void visit(PHPDocTypeNode node) {
            UsedNamespaceName usedName = new UsedNamespaceName(node, this.currentScope);
            if (this.isValidTypeName(usedName.getName()) && this.isValidAliasTypeName(usedName.getName())) {
                this.processUsedName(usedName);
            }
        }

        private boolean isValidTypeName(String typeName) {
            return !SPECIAL_NAMES.contains(typeName) && !Type.isPrimitive(typeName) && !typeName.contains("<") && !typeName.contains("{");
        }

        private boolean isValidAliasTypeName(String typeName) {
            return !SPECIAL_NAMES.contains(typeName) && !Type.isPrimitiveAlias(typeName);
        }

        private void processUsedName(UsedNamespaceName usedName) {
            List<UsedNamespaceName> usedNames = this.existingNames.get(usedName.getName());
            if (usedNames == null) {
                usedNames = new LinkedList<UsedNamespaceName>();
                this.existingNames.put(usedName.getName(), usedNames);
                this.scopeMap.put(usedName.getName(), usedName.getInScope());
            }
            usedNames.add(usedName);
        }

        public Map<String, List<UsedNamespaceName>> getExistingNames() {
            return Collections.unmodifiableMap(this.existingNames);
        }

        public Map<String, NamespaceScope> getScopeMap() {
            return Collections.unmodifiableMap(this.scopeMap);
        }
    }
}

