/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.AttributeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Dispatch;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FirstClassCallableArg;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class IncorrectFirstClassCallableSyntaxHintError
extends HintErrorRule {
    private FileObject fileObject;

    public String getDisplayName() {
        return Bundle.IncorrectFirstClassCallableSyntaxHintError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            for (FirstClassCallableArg incorrectCtorArg : checkVisitor.getIncorrectConstructorArgs()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint(incorrectCtorArg, Bundle.IncorrectFirstClassCallableSyntaxHintError_incorrectArgs(Bundle.IncorrectFirstClassCallableSyntaxHintError_withNewExpression()), hints);
            }
            for (FirstClassCallableArg incorrectAttributeArg : checkVisitor.getIncorrectAttributeArgs()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint(incorrectAttributeArg, Bundle.IncorrectFirstClassCallableSyntaxHintError_incorrectArgs(Bundle.IncorrectFirstClassCallableSyntaxHintError_asAttributeArgs()), hints);
            }
            for (FirstClassCallableArg incorrectMethodInvocationArg : checkVisitor.getIncorrectMethodInvocationArgs()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.addHint(incorrectMethodInvocationArg, Bundle.IncorrectFirstClassCallableSyntaxHintError_incorrectArgs(Bundle.IncorrectFirstClassCallableSyntaxHintError_withNullSafeOperator()), hints);
            }
        }
    }

    private void addHint(ASTNode node, String description, List<Hint> hints) {
        this.addHint(node, description, hints, Collections.emptyList());
    }

    private void addHint(ASTNode node, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, new OffsetRange(node.getStartOffset(), node.getEndOffset()), fixes, 500));
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final Set<FirstClassCallableArg> incorrectConstructorArgs = new HashSet<FirstClassCallableArg>();
        private final Set<FirstClassCallableArg> incorrectAttributeArgs = new HashSet<FirstClassCallableArg>();
        private final Set<FirstClassCallableArg> incorrectMethodInvocationArgs = new HashSet<FirstClassCallableArg>();

        private CheckVisitor() {
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkIncorrectArgs(node.ctorParams(), this.incorrectConstructorArgs);
            super.visit(node);
        }

        @Override
        public void visit(AttributeDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.getParameters() != null) {
                this.checkIncorrectArgs(node.getParameters(), this.incorrectAttributeArgs);
            }
            super.visit(node);
        }

        @Override
        public void visit(MethodInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.hasNullSafeOperator(node)) {
                FunctionInvocation method = node.getMethod();
                this.checkIncorrectArgs(method.getParameters(), this.incorrectMethodInvocationArgs);
            }
            super.visit(node);
        }

        private boolean hasNullSafeOperator(Dispatch dispatch) {
            if (dispatch.isNullsafe()) {
                return true;
            }
            if (!(dispatch.getDispatcher() instanceof Dispatch)) {
                return false;
            }
            return this.hasNullSafeOperator((Dispatch)dispatch.getDispatcher());
        }

        private void checkIncorrectArgs(List<Expression> params, Set<FirstClassCallableArg> incorrectArgs) {
            for (Expression param : params) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (!(param instanceof FirstClassCallableArg)) continue;
                incorrectArgs.add((FirstClassCallableArg)param);
                break;
            }
        }

        public Set<FirstClassCallableArg> getIncorrectConstructorArgs() {
            return Collections.unmodifiableSet(this.incorrectConstructorArgs);
        }

        public Set<FirstClassCallableArg> getIncorrectAttributeArgs() {
            return Collections.unmodifiableSet(this.incorrectAttributeArgs);
        }

        public Set<FirstClassCallableArg> getIncorrectMethodInvocationArgs() {
            return Collections.unmodifiableSet(this.incorrectMethodInvocationArgs);
        }
    }
}

