/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.AttributeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class ModifiersCheckHintError
extends HintErrorRule {
    private List<Hint> hints;
    private FileObject fileObject;
    private BaseDocument doc;
    private boolean currentClassHasAbstractMethod = false;

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        this.hints = hints;
        this.doc = context.doc;
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            Collection<? extends ClassScope> declaredClasses = ModelUtils.getDeclaredClasses(fileScope);
            for (ClassScope classScope : declaredClasses) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processClassScope(classScope);
            }
            for (TraitScope traitScope : ModelUtils.getDeclaredTraits(fileScope)) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processTraitScope(traitScope);
            }
            Collection<? extends InterfaceScope> declaredInterfaces = ModelUtils.getDeclaredInterfaces(fileScope);
            for (InterfaceScope interfaceScope : declaredInterfaces) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.processInterfaceScope(interfaceScope);
            }
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            this.checkReadonlyFieldDeclarationsWithDefaultValue(hints, checkVisitor.getReadonlyFieldDeclarationsWithDefaultValue());
            this.checkDuplicatedClassModifiers(hints, checkVisitor.getDuplicatedClassModifiers());
            this.checkInvalidReadonlyClassAttributes(hints, checkVisitor.getInvalidReadonlyClassAttributes());
        }
    }

    private void checkReadonlyFieldDeclarationsWithDefaultValue(List<Hint> hints, List<SingleFieldDeclaration> fields) {
        for (SingleFieldDeclaration fieldDeclaration : fields) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Variable value = fieldDeclaration.getName();
            if (value == null) continue;
            this.addHint(CodeUtils.getOffsetRagne(value), Bundle.ModifiersCheckHintError_realdonlyFieldWithDefaultValue(fieldDeclaration.getName()), hints, Collections.emptyList());
        }
    }

    private void checkDuplicatedClassModifiers(List<Hint> hints, List<Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>>> modifiers) {
        for (Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>> modifier : modifiers) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            OffsetRange lastPosition = null;
            for (OffsetRange offsetRange : modifier.getValue()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (lastPosition == null) {
                    lastPosition = offsetRange;
                    continue;
                }
                if (lastPosition.compareTo(offsetRange) > 0) continue;
                lastPosition = offsetRange;
            }
            assert (lastPosition != null);
            this.addHint(lastPosition, Bundle.ModifiersCheckHintError_duplicatedClassModifiers(modifier.getKey().name().toLowerCase()), hints, Collections.singletonList(new RemoveModifierFix(this.doc, modifier.getKey().toString(), lastPosition.getStart(), lastPosition)));
        }
    }

    private void checkInvalidReadonlyClassAttributes(List<Hint> hints, List<Pair<ClassDeclaration, AttributeDeclaration>> invalidReadonlyClassAttributes) {
        for (Pair<ClassDeclaration, AttributeDeclaration> attribute : invalidReadonlyClassAttributes) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.addHint(CodeUtils.getOffsetRagne((ASTNode)attribute.second()), Bundle.ModifiersCheckHintError_invalidReadonlyClassAttributes(CodeUtils.extractQualifiedName(((AttributeDeclaration)attribute.second()).getAttributeName()), ((ClassDeclaration)attribute.first()).getName().getName()), hints, Collections.emptyList());
        }
    }

    private void addHint(OffsetRange offsetRange, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, offsetRange, fixes, 500));
    }

    public String getDisplayName() {
        return Bundle.ModifiersCheckHintDispName();
    }

    private void processClassScope(ClassScope classScope) {
        this.processClassModifiers(classScope);
        Collection<? extends FieldElement> declaredFields = classScope.getDeclaredFields();
        for (FieldElement fieldElement : declaredFields) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processFieldElement(fieldElement, classScope.isReadonly());
        }
        Collection<? extends MethodScope> declaredMethods = classScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processMethodScope(methodScope);
        }
        if (this.currentClassHasAbstractMethod) {
            this.processPossibleAbstractClass(classScope);
        }
        this.currentClassHasAbstractMethod = false;
    }

    private void processTraitScope(TraitScope traitScope) {
        Collection<? extends FieldElement> declaredFields = traitScope.getDeclaredFields();
        for (FieldElement fieldElement : declaredFields) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processFieldElement(fieldElement);
        }
        Collection<? extends MethodScope> declaredMethods = traitScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processMethodScope(methodScope);
        }
    }

    private void processClassModifiers(ClassScope classScope) {
        if (classScope.isAbstract() && classScope.isFinal()) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            fixes.add(new RemoveModifierFix(this.doc, "abstract", classScope.getOffset()));
            fixes.add(new RemoveModifierFix(this.doc, "final", classScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidFinalModifierWithAbstractModifier(), classScope.getNameRange(), fixes));
        }
        for (ClassScope classScope2 : classScope.getSuperClasses()) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!classScope2.isFinal()) continue;
            this.hints.add(new SimpleHint(Bundle.InvalidClassExtendsFinalClass(classScope.getName(), classScope2.getName()), classScope.getNameRange(), Collections.emptyList()));
            break;
        }
        this.processReadonlyClass(classScope);
    }

    private void processReadonlyClass(ClassScope classScope) {
        if (classScope.isReadonly()) {
            for (ClassScope classScope2 : classScope.getSuperClasses()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (classScope2.isReadonly()) continue;
                List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "readonly", classScope.getOffset()));
                this.hints.add(new SimpleHint(Bundle.InvalidReadonlyClassExtendsNonReadonlyClass(classScope.getName(), classScope2.getName()), classScope.getNameRange(), fixes));
                break;
            }
        } else {
            for (ClassScope classScope3 : classScope.getSuperClasses()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (!classScope3.isReadonly()) continue;
                List<HintFix> fixes = Collections.singletonList(new AddModifierFix(this.doc, "readonly", classScope.getOffset()));
                this.hints.add(new SimpleHint(Bundle.InvalidClassExtendsReadonlyClass(classScope.getName(), classScope3.getName()), classScope.getNameRange(), fixes));
                break;
            }
        }
    }

    private void processFieldElement(FieldElement fieldElement) {
        this.processFieldElement(fieldElement, false);
    }

    private void processFieldElement(FieldElement fieldElement, boolean isReadonlyClass) {
        PhpModifiers phpModifiers = fieldElement.getPhpModifiers();
        if (phpModifiers.isAbstract()) {
            String invalidModifier = "abstract";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, fieldElement.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidField(fieldElement.getName(), invalidModifier), fieldElement.getNameRange(), fixes));
        } else if (phpModifiers.isFinal()) {
            String invalidModifier = "final";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, fieldElement.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidField(fieldElement.getName(), invalidModifier), fieldElement.getNameRange(), fixes));
        } else if (phpModifiers.isStatic() && (phpModifiers.isReadonly() || isReadonlyClass)) {
            this.hints.add(new SimpleHint(Bundle.InvalidStaticReadonlyProperty(fieldElement.getName()), fieldElement.getNameRange(), Collections.emptyList()));
        } else if ((phpModifiers.isReadonly() || isReadonlyClass) && fieldElement.getDefaultTypeNames().isEmpty()) {
            this.hints.add(new SimpleHint(Bundle.InvalidReadonlyProperty(fieldElement.getName()), fieldElement.getNameRange(), Collections.emptyList()));
        }
    }

    private void processMethodScope(MethodScope methodScope) {
        PhpModifiers phpModifiers = methodScope.getPhpModifiers();
        boolean isTrait = methodScope.getInScope() instanceof TraitScope;
        if (phpModifiers.isAbstract() && phpModifiers.isFinal()) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            fixes.add(new RemoveModifierFix(this.doc, "abstract", methodScope.getOffset()));
            fixes.add(new RemoveModifierFix(this.doc, "final", methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.AbstractFinalMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isAbstract() && methodScope.getBlockRange() != null) {
            List<HintFix> fixes = Collections.singletonList(new RemoveBodyFix(this.doc, methodScope));
            this.hints.add(new SimpleHint(Bundle.AbstractWithBlockMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isAbstract() && phpModifiers.isPrivate() && !isTrait) {
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "private", methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.AbstractPrivateMethod(methodScope.getName()), methodScope.getNameRange(), fixes));
        }
        if (phpModifiers.isAbstract() && !isTrait) {
            this.currentClassHasAbstractMethod = true;
        }
    }

    private void processInterfaceScope(InterfaceScope interfaceScope) {
        Collection<? extends MethodScope> declaredMethods = interfaceScope.getDeclaredMethods();
        for (MethodScope methodScope : declaredMethods) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processInterfaceMethodScope(methodScope);
        }
        Collection<? extends ClassConstantElement> declaredConstants = interfaceScope.getDeclaredConstants();
        for (ClassConstantElement classConstantElement : declaredConstants) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.processInterfaceClassConstant(classConstantElement);
        }
    }

    private void processInterfaceMethodScope(MethodScope methodScope) {
        PhpModifiers phpModifiers = methodScope.getPhpModifiers();
        if (phpModifiers.isPrivate()) {
            String invalidModifier = "private";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isProtected()) {
            String invalidModifier = "protected";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (phpModifiers.isFinal()) {
            String invalidModifier = "final";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, methodScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceMethod(methodScope.getName(), invalidModifier), methodScope.getNameRange(), fixes));
        } else if (methodScope.getBlockRange() != null && methodScope.getBlockRange().getLength() != 1) {
            List<HintFix> fixes = Collections.singletonList(new RemoveBodyFix(this.doc, methodScope));
            this.hints.add(new SimpleHint(Bundle.IfaceMethodWithBlock(methodScope.getName()), methodScope.getNameRange(), fixes));
        }
    }

    private void processInterfaceClassConstant(ClassConstantElement classConstant) {
        PhpModifiers phpModifiers = classConstant.getPhpModifiers();
        if (phpModifiers.isPrivate()) {
            String invalidModifier = "private";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, classConstant.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceConstant(classConstant.getName(), invalidModifier), classConstant.getNameRange(), fixes));
        } else if (phpModifiers.isProtected()) {
            String invalidModifier = "protected";
            List<HintFix> fixes = Collections.singletonList(new RemoveModifierFix(this.doc, invalidModifier, classConstant.getOffset()));
            this.hints.add(new SimpleHint(Bundle.InvalidIfaceConstant(classConstant.getName(), invalidModifier), classConstant.getNameRange(), fixes));
        }
    }

    private void processPossibleAbstractClass(ClassScope classScope) {
        List<HintFix> fixes;
        if (!classScope.isAbstract()) {
            fixes = Collections.singletonList(new AddModifierFix(this.doc, "abstract", classScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.PossibleAbstractClass(classScope.getName()), classScope.getNameRange(), fixes));
        }
        if (classScope.isFinal()) {
            fixes = Collections.singletonList(new RemoveModifierFix(this.doc, "final", classScope.getOffset()));
            this.hints.add(new SimpleHint(Bundle.FinalPossibleAbstractClass(classScope.getName()), classScope.getNameRange(), fixes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getStartOffset(BaseDocument doc, int elementOffset) {
        int retval;
        block6: {
            retval = 0;
            doc.readLock();
            try {
                TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, elementOffset);
                if (ts == null) break block6;
                ts.move(elementOffset);
                TokenId lastTokenId = null;
                while (ts.movePrevious()) {
                    Token t = ts.token();
                    if (t.id() != PHPTokenId.PHP_PUBLIC && t.id() != PHPTokenId.PHP_PROTECTED && t.id() != PHPTokenId.PHP_PRIVATE && t.id() != PHPTokenId.PHP_STATIC && t.id() != PHPTokenId.PHP_FINAL && t.id() != PHPTokenId.PHP_ABSTRACT && t.id() != PHPTokenId.PHP_FUNCTION && t.id() != PHPTokenId.WHITESPACE && t.id() != PHPTokenId.PHP_CLASS && t.id() != PHPTokenId.PHP_CONST && t.id() != PHPTokenId.PHP_READONLY) {
                        ts.moveNext();
                        if (lastTokenId == PHPTokenId.WHITESPACE) {
                            ts.moveNext();
                        }
                        retval = ts.offset();
                        break;
                    }
                    lastTokenId = t.id();
                }
            }
            finally {
                doc.readUnlock();
            }
        }
        return retval;
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<SingleFieldDeclaration> readonlyFieldDeclarationsWithDefaultValue = new ArrayList<SingleFieldDeclaration>();
        private final List<Pair<ClassDeclaration, AttributeDeclaration>> invalidReadonlyClassAttributes = new ArrayList<Pair<ClassDeclaration, AttributeDeclaration>>();
        private final List<Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>>> duplicatedClassModifiers = new ArrayList<Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>>>();

        private CheckVisitor() {
        }

        @Override
        public void visit(ClassDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkDuplicatedClassModifiers(node);
            if (node.getModifiers().containsKey((Object)ClassDeclaration.Modifier.READONLY)) {
                this.checkInvalidReadonlyClassAttributes(node);
            }
            super.visit(node);
        }

        private void checkDuplicatedClassModifiers(ClassDeclaration node) {
            for (Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>> entry : node.getModifiers().entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (entry.getValue().size() <= 1) continue;
                this.duplicatedClassModifiers.add(entry);
            }
        }

        private void checkInvalidReadonlyClassAttributes(ClassDeclaration node) {
            block0: for (Attribute attribute : node.getAttributes()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                for (AttributeDeclaration attributeDeclaration : attribute.getAttributeDeclarations()) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    String attributeName = CodeUtils.extractQualifiedName(attributeDeclaration.getAttributeName());
                    if (!"AllowDynamicProperties".equals(attributeName)) continue;
                    this.invalidReadonlyClassAttributes.add((Pair<ClassDeclaration, AttributeDeclaration>)Pair.of((Object)node, (Object)attributeDeclaration));
                    continue block0;
                }
            }
        }

        @Override
        public void visit(FieldsDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (BodyDeclaration.Modifier.isReadonly(node.getModifier())) {
                for (SingleFieldDeclaration field : node.getFields()) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    if (field.getValue() == null) continue;
                    this.readonlyFieldDeclarationsWithDefaultValue.add(field);
                }
            }
            super.visit(node);
        }

        public List<SingleFieldDeclaration> getReadonlyFieldDeclarationsWithDefaultValue() {
            return Collections.unmodifiableList(this.readonlyFieldDeclarationsWithDefaultValue);
        }

        public List<Map.Entry<ClassDeclaration.Modifier, Set<OffsetRange>>> getDuplicatedClassModifiers() {
            return Collections.unmodifiableList(this.duplicatedClassModifiers);
        }

        public List<Pair<ClassDeclaration, AttributeDeclaration>> getInvalidReadonlyClassAttributes() {
            return Collections.unmodifiableList(this.invalidReadonlyClassAttributes);
        }
    }

    private class AddModifierFix
    extends AbstractHintFix {
        private final String modifier;
        private final int elementOffset;

        public AddModifierFix(BaseDocument doc, String modifier, int elementOffset) {
            super(doc);
            this.modifier = modifier;
            this.elementOffset = elementOffset;
        }

        public String getDescription() {
            return Bundle.AddModifierFixDesc(this.modifier);
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            int startOffset = ModifiersCheckHintError.getStartOffset(this.doc, this.elementOffset);
            int length = this.elementOffset - startOffset;
            String replaceText = this.modifier + " " + this.doc.getText(startOffset, length);
            edits.replace(startOffset, length, replaceText, true, 0);
            edits.apply();
        }
    }

    private class RemoveModifierFix
    extends AbstractHintFix {
        private final String modifier;
        private final int elementOffset;
        private final OffsetRange offsetRange;

        public RemoveModifierFix(BaseDocument doc, String modifier, int elementOffset) {
            this(doc, modifier, elementOffset, null);
        }

        public RemoveModifierFix(BaseDocument doc, String modifier, int elementOffset, OffsetRange offsetRange) {
            super(doc);
            this.offsetRange = offsetRange;
            this.modifier = modifier;
            this.elementOffset = elementOffset;
        }

        public String getDescription() {
            return Bundle.RemoveModifierFixDesc(this.modifier);
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            if (this.offsetRange != null) {
                edits.replace(this.offsetRange.getStart(), this.offsetRange.getLength() + 1, "", true, 0);
            } else {
                int startOffset = ModifiersCheckHintError.getStartOffset(this.doc, this.elementOffset);
                int length = this.elementOffset - startOffset;
                String replaceText = this.doc.getText(startOffset, length).replace(this.modifier, "").replaceAll("^\\s+", "");
                edits.replace(startOffset, length, replaceText, true, 0);
            }
            edits.apply();
        }
    }

    private class RemoveBodyFix
    extends AbstractHintFix {
        private final MethodScope methodScope;

        public RemoveBodyFix(BaseDocument doc, MethodScope methodScope) {
            super(doc);
            this.methodScope = methodScope;
        }

        public String getDescription() {
            return Bundle.RemoveBodyFixDesc(this.methodScope.getName());
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.doc);
            edits.replace(this.methodScope.getBlockRange().getStart(), this.methodScope.getBlockRange().getLength(), ";", true, 0);
            edits.apply();
        }
    }

    private abstract class AbstractHintFix
    implements HintFix {
        protected final BaseDocument doc;

        public AbstractHintFix(BaseDocument doc) {
            this.doc = doc;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private class SimpleHint
    extends Hint {
        public SimpleHint(String description, OffsetRange range, List<HintFix> fixes) {
            super((Rule)ModifiersCheckHintError.this, description, ModifiersCheckHintError.this.fileObject, range, fixes, 500);
        }

        public SimpleHint(String description, OffsetRange range) {
            this(description, range, null);
        }
    }
}

