/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.swing.SwingUtilities;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.docker.ChunkedInputStream;
import org.netbeans.modules.docker.ConnectionListener;
import org.netbeans.modules.docker.Demuxer;
import org.netbeans.modules.docker.DirectStreamResult;
import org.netbeans.modules.docker.DockerActionAccessor;
import org.netbeans.modules.docker.DockerConfig;
import org.netbeans.modules.docker.DockerRemoteException;
import org.netbeans.modules.docker.DockerUtils;
import org.netbeans.modules.docker.Endpoint;
import org.netbeans.modules.docker.FolderUploader;
import org.netbeans.modules.docker.HttpUtils;
import org.netbeans.modules.docker.IgnoreFileFilter;
import org.netbeans.modules.docker.MuxedStreamResult;
import org.netbeans.modules.docker.StreamItem;
import org.netbeans.modules.docker.StreamResult;
import org.netbeans.modules.docker.api.ActionChunkedResult;
import org.netbeans.modules.docker.api.ActionStreamResult;
import org.netbeans.modules.docker.api.BuildEvent;
import org.netbeans.modules.docker.api.Credentials;
import org.netbeans.modules.docker.api.CredentialsManager;
import org.netbeans.modules.docker.api.DockerAuthenticationException;
import org.netbeans.modules.docker.api.DockerConflictException;
import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.DockerContainerDetail;
import org.netbeans.modules.docker.api.DockerEntityType;
import org.netbeans.modules.docker.api.DockerEvent;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.api.DockerImage;
import org.netbeans.modules.docker.api.DockerImageDetail;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerName;
import org.netbeans.modules.docker.api.DockerRegistryImage;
import org.netbeans.modules.docker.api.DockerTag;
import org.netbeans.modules.docker.api.DockerfileDetail;
import org.netbeans.modules.docker.api.ExposedPort;
import org.netbeans.modules.docker.api.PortMapping;
import org.netbeans.modules.docker.api.StatusEvent;
import org.netbeans.modules.docker.tls.ContextProvider;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.io.NullInputStream;
import org.openide.util.io.NullOutputStream;

public class DockerAction {
    public static final String DOCKER_FILE = "Dockerfile";
    private static final Logger LOGGER = Logger.getLogger(DockerAction.class.getName());
    private static final Pattern ID_PATTERN = Pattern.compile(".*([0-9a-f]{12}([0-9a-f]{52})?).*");
    private static final Pattern PORT_PATTERN = Pattern.compile("^(\\d+)/(tcp|udp)$");
    private static final Set<Integer> START_STOP_CONTAINER_CODES = new HashSet<Integer>();
    private static final Set<Integer> REMOVE_CONTAINER_CODES = new HashSet<Integer>();
    private static final Set<Integer> REMOVE_IMAGE_CODES = new HashSet<Integer>();
    private static final Pair<String, String> ACCEPT_JSON_HEADER = Pair.of((Object)"Accept", (Object)"application/json");
    private final DockerInstance instance;
    private final boolean emitEvents;

    public DockerAction(DockerInstance instance) {
        this(instance, true);
    }

    private DockerAction(DockerInstance instance, boolean emitEvents) {
        this.instance = instance;
        this.emitEvents = emitEvents;
    }

    public List<DockerImage> getImages() {
        try {
            JSONArray value = (JSONArray)this.doGetRequest("/images/json", Collections.singleton(200));
            ArrayList<DockerImage> ret = new ArrayList<DockerImage>(value.size());
            for (Object o : value) {
                JSONObject json = (JSONObject)o;
                JSONArray repoTags = (JSONArray)json.get((Object)"RepoTags");
                String id = (String)json.get((Object)"Id");
                long created = (Long)json.get((Object)"Created");
                long size = (Long)json.get((Object)"Size");
                long virtualSize = (Long)json.get((Object)"VirtualSize");
                ret.add(new DockerImage(this.instance, (List<String>)repoTags, id, created, size, virtualSize));
            }
            return ret;
        }
        catch (DockerException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return Collections.emptyList();
        }
    }

    public List<DockerContainer> getContainers() {
        try {
            JSONArray value = (JSONArray)this.doGetRequest("/containers/json?all=1", Collections.singleton(200));
            ArrayList<DockerContainer> ret = new ArrayList<DockerContainer>(value.size());
            for (Object o : value) {
                JSONObject json = (JSONObject)o;
                String id = (String)json.get((Object)"Id");
                String image = (String)json.get((Object)"Image");
                String name = null;
                JSONArray names = (JSONArray)json.get((Object)"Names");
                if (names != null && !names.isEmpty()) {
                    name = (String)names.get(0);
                }
                DockerContainer.Status status = DockerUtils.getContainerStatus((String)json.get((Object)"Status"));
                ret.add(new DockerContainer(this.instance, id, image, name, status));
            }
            return ret;
        }
        catch (DockerException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return Collections.emptyList();
        }
    }

    public List<DockerRegistryImage> search(String searchTerm) {
        if (searchTerm.contains(":") || searchTerm.contains("@")) {
            return Collections.emptyList();
        }
        try {
            JSONArray value = (JSONArray)this.doGetRequest("/images/search?term=" + HttpUtils.encodeParameter(searchTerm), Collections.singleton(200));
            ArrayList<DockerRegistryImage> ret = new ArrayList<DockerRegistryImage>(value.size());
            for (Object o : value) {
                JSONObject json = (JSONObject)o;
                String name = (String)json.get((Object)"name");
                String description = (String)json.get((Object)"description");
                long stars = ((Number)DockerAction.getOrDefault((Map)json, "star_count", 0)).longValue();
                boolean official = (Boolean)DockerAction.getOrDefault((Map)json, "is_official", false);
                boolean automated = (Boolean)DockerAction.getOrDefault((Map)json, "is_automated", false);
                ret.add(new DockerRegistryImage(name, description, stars, official, automated));
            }
            return ret;
        }
        catch (UnsupportedEncodingException | DockerException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return Collections.emptyList();
        }
    }

    public DockerImage commit(DockerContainer container, String repository, String tag, String author, String message, boolean pause) throws DockerException {
        if (repository == null && tag != null) {
            throw new IllegalArgumentException("Repository can't be empty when using tag");
        }
        try {
            StringBuilder action = new StringBuilder("/commit");
            action.append("?");
            action.append("container=").append(container.getId());
            if (repository != null) {
                action.append("&repo=").append(HttpUtils.encodeParameter(repository));
                if (tag != null) {
                    action.append("&tag=").append(HttpUtils.encodeParameter(tag));
                }
            }
            if (author != null) {
                action.append("&author=").append(HttpUtils.encodeParameter(author));
            }
            if (message != null) {
                action.append("&comment=").append(HttpUtils.encodeParameter(message));
            }
            if (!pause) {
                action.append("&pause=0");
            }
            JSONObject value = (JSONObject)this.doPostRequest(action.toString(), true, Collections.singleton(201));
            String id = (String)value.get((Object)"Id");
            long time = System.currentTimeMillis() / 1000L;
            if (this.emitEvents) {
                this.instance.getEventBus().sendEvent(new DockerEvent(this.instance, DockerEvent.Status.COMMIT, id, container.getId(), time));
            }
            return new DockerImage(this.instance, Collections.singletonList(DockerUtils.getTag(repository, tag)), (String)value.get((Object)"Id"), time, 0L, 0L);
        }
        catch (UnsupportedEncodingException ex) {
            throw new DockerException(ex);
        }
    }

    public void rename(DockerContainer container, String name) throws DockerException {
        Parameters.notNull((CharSequence)"name", (Object)name);
        try {
            this.doPostRequest("/containers/" + container.getId() + "/rename?name=" + HttpUtils.encodeParameter(name), false, Collections.singleton(204));
            long time = System.currentTimeMillis() / 1000L;
            if (this.emitEvents) {
                this.instance.getEventBus().sendEvent(new DockerEvent(this.instance, DockerEvent.Status.RENAME, container.getId(), container.getId(), time));
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new DockerException(ex);
        }
    }

    public DockerTag tag(DockerTag source, String repository, String tag, boolean force) throws DockerException {
        if (repository == null) {
            throw new IllegalArgumentException("Repository can't be empty");
        }
        StringBuilder action = new StringBuilder("/images/");
        action.append(source.getId());
        action.append("/tag");
        action.append("?");
        action.append("repo=").append(repository);
        if (force) {
            action.append("&force=1");
        }
        if (tag != null) {
            action.append("&tag=").append(tag);
        }
        this.doPostRequest(action.toString(), false, Collections.singleton(201));
        String tagResult = DockerUtils.getTag(repository, tag);
        long time = System.currentTimeMillis() / 1000L;
        if (this.emitEvents) {
            this.instance.getEventBus().sendEvent(new DockerEvent(this.instance, DockerEvent.Status.TAG, source.getId(), tagResult, time));
        }
        return new DockerTag(source.getImage(), tagResult);
    }

    public JSONObject getRawDetails(DockerEntityType entityType, String containerId) throws DockerException {
        JSONObject value = (JSONObject)this.doGetRequest(entityType.getUrlPath() + containerId + "/json", Collections.singleton(200));
        return value;
    }

    public DockerContainerDetail getDetail(DockerContainer container) throws DockerException {
        JSONObject ports;
        JSONObject value = this.getRawDetails(DockerEntityType.Container, container.getId());
        String name = (String)value.get((Object)"Name");
        DockerContainer.Status status = DockerContainer.Status.STOPPED;
        JSONObject state = (JSONObject)value.get((Object)"State");
        if (state != null) {
            boolean paused = (Boolean)DockerAction.getOrDefault((Map)state, "Paused", false);
            if (paused) {
                status = DockerContainer.Status.PAUSED;
            } else {
                boolean running = (Boolean)DockerAction.getOrDefault((Map)state, "Running", false);
                if (running) {
                    status = DockerContainer.Status.RUNNING;
                }
            }
        }
        boolean tty = false;
        boolean stdin = false;
        JSONObject config = (JSONObject)value.get((Object)"Config");
        if (config != null) {
            tty = (Boolean)DockerAction.getOrDefault((Map)config, "Tty", false);
            stdin = (Boolean)DockerAction.getOrDefault((Map)config, "OpenStdin", false);
        }
        if ((ports = (JSONObject)((JSONObject)value.get((Object)"NetworkSettings")).get((Object)"Ports")) == null || ports.isEmpty()) {
            return new DockerContainerDetail(name, status, stdin, tty);
        }
        ArrayList<PortMapping> portMapping = new ArrayList<PortMapping>();
        for (String containerPortData : ports.keySet()) {
            JSONArray hostPortsArray = (JSONArray)ports.get((Object)containerPortData);
            if (hostPortsArray == null || hostPortsArray.isEmpty()) continue;
            Matcher m = PORT_PATTERN.matcher(containerPortData);
            if (m.matches()) {
                int containerPort = Integer.parseInt(m.group(1));
                String type = m.group(2).toUpperCase(Locale.ENGLISH);
                int hostPort = Integer.parseInt((String)((JSONObject)hostPortsArray.get(0)).get((Object)"HostPort"));
                String hostIp = (String)((JSONObject)hostPortsArray.get(0)).get((Object)"HostIp");
                portMapping.add(new PortMapping(ExposedPort.Type.valueOf(type), containerPort, hostPort, hostIp));
                continue;
            }
            LOGGER.log(Level.FINE, "Unparsable port: {0}", containerPortData);
        }
        return new DockerContainerDetail(name, status, stdin, tty, portMapping);
    }

    public DockerImageDetail getDetail(DockerImage image) throws DockerException {
        JSONObject portsObject;
        JSONObject value = (JSONObject)this.doGetRequest("/images/" + image.getId() + "/json", Collections.singleton(200));
        LinkedList<ExposedPort> ports = new LinkedList<ExposedPort>();
        JSONObject config = (JSONObject)value.get((Object)"Config");
        if (config != null && (portsObject = (JSONObject)config.get((Object)"ExposedPorts")) != null) {
            for (Object k : portsObject.keySet()) {
                String portStr = (String)k;
                Matcher m = PORT_PATTERN.matcher(portStr);
                if (m.matches()) {
                    int port = Integer.parseInt(m.group(1));
                    ExposedPort.Type type = ExposedPort.Type.valueOf(m.group(2).toUpperCase(Locale.ENGLISH));
                    ports.add(new ExposedPort(port, type));
                    continue;
                }
                LOGGER.log(Level.FINE, "Unparsable port: {0}", portStr);
            }
        }
        return new DockerImageDetail(ports);
    }

    public DockerfileDetail getDetail(FileObject dockerfile) throws IOException {
        List argLines = dockerfile.asLines().stream().filter(line -> line.trim().matches("^(?i)arg(.*)$")).map(argLine -> argLine.trim().replaceFirst("^(?i)arg", "").trim()).collect(Collectors.toList());
        HashMap<String, String> pairs = new HashMap<String, String>();
        for (String line2 : argLines) {
            String[] split = line2.split("=", 2);
            pairs.put(split[0], split.length == 2 ? split[1] : "");
        }
        return new DockerfileDetail(pairs);
    }

    public void start(DockerContainer container) throws DockerException {
        this.doPostRequest("/containers/" + container.getId() + "/start", false, START_STOP_CONTAINER_CODES);
        if (this.emitEvents) {
            this.instance.getEventBus().sendEvent(new DockerEvent(this.instance, DockerEvent.Status.START, container.getId(), container.getImage(), System.currentTimeMillis() / 1000L));
        }
    }

    public void stop(DockerContainer container) throws DockerException {
        this.doPostRequest("/containers/" + container.getId() + "/stop", false, START_STOP_CONTAINER_CODES);
        if (this.emitEvents) {
            this.instance.getEventBus().sendEvent(new DockerEvent(this.instance, DockerEvent.Status.DIE, container.getId(), container.getImage(), System.currentTimeMillis() / 1000L));
        }
    }

    public void pause(DockerContainer container) throws DockerException {
        this.doPostRequest("/containers/" + container.getId() + "/pause", false, Collections.singleton(204));
        if (this.emitEvents) {
            this.instance.getEventBus().sendEvent(new DockerEvent(this.instance, DockerEvent.Status.PAUSE, container.getId(), container.getImage(), System.currentTimeMillis() / 1000L));
        }
    }

    public void unpause(DockerContainer container) throws DockerException {
        this.doPostRequest("/containers/" + container.getId() + "/unpause", false, Collections.singleton(204));
        if (this.emitEvents) {
            this.instance.getEventBus().sendEvent(new DockerEvent(this.instance, DockerEvent.Status.UNPAUSE, container.getId(), container.getImage(), System.currentTimeMillis() / 1000L));
        }
    }

    public void remove(DockerTag tag) throws DockerException {
        String id = DockerAction.getImage(tag);
        this.doDeleteRequest("/images/" + id, true, REMOVE_IMAGE_CODES);
        if (this.emitEvents) {
            this.instance.getEventBus().sendEvent(new DockerEvent(this.instance, DockerEvent.Status.UNTAG, tag.getId(), null, System.currentTimeMillis() / 1000L));
        }
    }

    public void remove(DockerContainer container) throws DockerException {
        this.doDeleteRequest("/containers/" + container.getId(), false, REMOVE_CONTAINER_CODES);
        if (this.emitEvents) {
            this.instance.getEventBus().sendEvent(new DockerEvent(this.instance, DockerEvent.Status.DESTROY, container.getId(), container.getImage(), System.currentTimeMillis() / 1000L));
        }
    }

    public void resizeTerminal(DockerContainer container, int rows, int columns) throws DockerException {
        this.doPostRequest("/containers/" + container.getId() + "/resize?h=" + rows + "&w=" + columns, false, Collections.singleton(200));
    }

    public ActionStreamResult attach(DockerContainer container, boolean stdin, boolean logs) throws DockerException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Remote access invoked from EDT";
        DockerContainerDetail info = this.getDetail(container);
        Endpoint s = null;
        try {
            s = this.createEndpoint();
            OutputStream os = s.getOutputStream();
            os.write(("POST /containers/" + container.getId() + "/attach?logs=" + (logs ? 1 : 0) + "&stream=1&stdout=1&stdin=" + (stdin ? 1 : 0) + "&stderr=1 HTTP/1.1\r\n").getBytes(StandardCharsets.ISO_8859_1));
            HttpUtils.configureHeaders(os, DockerConfig.getDefault().getHttpHeaders(), this.getHostHeader(), Pair.of((Object)"Connection", (Object)"Upgrade"), Pair.of((Object)"Upgrade", (Object)"tcp"));
            os.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            InputStream is = s.getInputStream();
            HttpUtils.Response response = HttpUtils.readResponse(is);
            int responseCode = response.getCode();
            if (responseCode != 101 && responseCode != 200) {
                String error = HttpUtils.readContent(is, response);
                throw new DockerRemoteException(responseCode, error != null ? error : response.getMessage());
            }
            if (this.emitEvents) {
                this.instance.getEventBus().sendEvent(new DockerEvent(this.instance, DockerEvent.Status.ATTACH, container.getId(), container.getImage(), System.currentTimeMillis() / 1000L));
            }
            Charset ch = HttpUtils.getCharset(response);
            Integer length = HttpUtils.getLength(response.getHeaders());
            if (length != null && length <= 0) {
                DockerAction.closeEndpoint(s);
                return new ActionStreamResult(new EmptyStreamResult(info.isTty()));
            }
            is = HttpUtils.getResponseStream(is, response, true);
            if (info.isTty()) {
                return new ActionStreamResult(new DirectStreamResult(s, ch, is));
            }
            return new ActionStreamResult(new MuxedStreamResult(s, ch, is));
        }
        catch (MalformedURLException e) {
            DockerAction.closeEndpoint(s);
            throw new DockerException(e);
        }
        catch (IOException e) {
            DockerAction.closeEndpoint(s);
            throw new DockerException(e);
        }
        catch (DockerException e) {
            DockerAction.closeEndpoint(s);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pull(String imageName, StatusEvent.Listener listener) throws DockerException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Remote access invoked from EDT";
        try {
            DockerName parsed = DockerName.parse(imageName);
            Endpoint s = this.createEndpoint();
            try {
                OutputStream os = s.getOutputStream();
                os.write(("POST /images/create?fromImage=" + HttpUtils.encodeParameter(imageName) + " HTTP/1.1\r\n").getBytes(StandardCharsets.ISO_8859_1));
                Pair authHeader = null;
                JSONObject auth = DockerAction.createAuthObject(CredentialsManager.getDefault().getCredentials(parsed.getRegistry()));
                authHeader = Pair.of((Object)"X-Registry-Auth", (Object)HttpUtils.encodeBase64(auth.toJSONString()));
                HttpUtils.configureHeaders(os, DockerConfig.getDefault().getHttpHeaders(), this.getHostHeader(), ACCEPT_JSON_HEADER, authHeader);
                os.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
                os.flush();
                InputStream is = s.getInputStream();
                HttpUtils.Response response = HttpUtils.readResponse(is);
                int responseCode = response.getCode();
                is = HttpUtils.getResponseStream(is, response, false);
                if (responseCode != 200) {
                    String error = HttpUtils.readContent(is, response);
                    throw DockerAction.codeToException(responseCode, error != null ? error : response.getMessage());
                }
                String authFailure = null;
                JSONParser parser = new JSONParser();
                try (InputStreamReader r = new InputStreamReader(is, HttpUtils.getCharset(response));){
                    String line;
                    while ((line = DockerAction.readEventObject(r)) != null) {
                        JSONObject o = (JSONObject)parser.parse(line);
                        StatusEvent e = this.parseStatusEvent(o);
                        if (e != null) {
                            if (authFailure == null) {
                                authFailure = DockerAction.getAuthenticationFailure(e);
                            }
                            listener.onEvent(e);
                        }
                        parser.reset();
                    }
                }
                catch (ParseException ex) {
                    throw new DockerException(ex);
                }
                if (authFailure != null) {
                    throw new DockerAuthenticationException(authFailure);
                }
            }
            finally {
                DockerAction.closeEndpoint(s);
            }
        }
        catch (MalformedURLException e) {
            throw new DockerException(e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(DockerTag tag, StatusEvent.Listener listener) throws DockerException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Remote access invoked from EDT";
        try {
            String name = tag.getTag();
            DockerName parsed = DockerName.parse(name);
            String tagString = parsed.getTag();
            StringBuilder action = new StringBuilder();
            action.append("/images/");
            if (tagString == null) {
                action.append(name);
            } else {
                action.append(name.substring(0, name.length() - tagString.length() - 1));
            }
            action.append("/push");
            if (tagString != null) {
                action.append("?tag=").append(HttpUtils.encodeParameter(tagString));
            }
            Endpoint s = this.createEndpoint();
            try {
                OutputStream os = s.getOutputStream();
                os.write(("POST " + action.toString() + " HTTP/1.1\r\n").getBytes(StandardCharsets.ISO_8859_1));
                Pair authHeader = null;
                JSONObject auth = DockerAction.createAuthObject(CredentialsManager.getDefault().getCredentials(parsed.getRegistry()));
                authHeader = Pair.of((Object)"X-Registry-Auth", (Object)HttpUtils.encodeBase64(auth.toJSONString()));
                HttpUtils.configureHeaders(os, DockerConfig.getDefault().getHttpHeaders(), this.getHostHeader(), ACCEPT_JSON_HEADER, authHeader);
                os.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
                os.flush();
                InputStream is = s.getInputStream();
                HttpUtils.Response response = HttpUtils.readResponse(is);
                int responseCode = response.getCode();
                is = HttpUtils.getResponseStream(is, response, false);
                if (responseCode != 200) {
                    String error = HttpUtils.readContent(is, response);
                    throw DockerAction.codeToException(responseCode, error != null ? error : response.getMessage());
                }
                String authFailure = null;
                JSONParser parser = new JSONParser();
                try (InputStreamReader r = new InputStreamReader(is, HttpUtils.getCharset(response));){
                    String line;
                    while ((line = DockerAction.readEventObject(r)) != null) {
                        JSONObject o = (JSONObject)parser.parse(line);
                        StatusEvent e = this.parseStatusEvent(o);
                        if (e != null) {
                            if (authFailure == null) {
                                authFailure = DockerAction.getAuthenticationFailure(e);
                            }
                            listener.onEvent(e);
                        }
                        parser.reset();
                    }
                }
                catch (ParseException ex) {
                    throw new DockerException(ex);
                }
                if (authFailure != null) {
                    throw new DockerAuthenticationException(authFailure);
                }
            }
            finally {
                DockerAction.closeEndpoint(s);
            }
        }
        catch (MalformedURLException e) {
            throw new DockerException(e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    public FutureTask<DockerImage> createBuildTask(final @NonNull FileObject buildContext, final @NullAllowed FileObject dockerfile, final @NullAllowed Map<String, String> buildargs, final String repository, final String tag, final boolean pull, final boolean noCache, final BuildEvent.Listener buildListener, final StatusEvent.Listener statusListener) {
        final CancelHandler handler = new CancelHandler();
        Callable<DockerImage> callable = new Callable<DockerImage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public DockerImage call() throws Exception {
                assert (!SwingUtilities.isEventDispatchThread()) : "Remote access invoked from EDT";
                if (!buildContext.isFolder()) {
                    throw new IllegalArgumentException("Build context has to be a directory");
                }
                if (dockerfile != null && !dockerfile.isData()) {
                    throw new IllegalArgumentException("Dockerfile has to be a file");
                }
                if (repository == null && tag != null) {
                    throw new IllegalArgumentException("Repository can't be empty when using tag");
                }
                String dockerfileName = null;
                if (dockerfile != null) {
                    dockerfileName = dockerfile.getName();
                }
                Endpoint s = null;
                try {
                    s = DockerAction.this.createEndpoint();
                    CancelHandler cancelHandler = handler;
                    synchronized (cancelHandler) {
                        if (handler.isCancelled()) {
                            return null;
                        }
                        handler.setEndpoint(s);
                    }
                    StringBuilder request = new StringBuilder();
                    request.append("POST /build?");
                    request.append("pull=").append(pull ? 1 : 0);
                    request.append("&nocache=").append(noCache ? 1 : 0);
                    if (dockerfileName != null) {
                        request.append("&dockerfile=").append(HttpUtils.encodeParameter(dockerfileName));
                    }
                    if (repository != null) {
                        request.append("&t=").append(HttpUtils.encodeParameter(repository));
                        if (tag != null) {
                            request.append(":").append(tag);
                        }
                    }
                    if (buildargs != null && !buildargs.isEmpty()) {
                        request.append("&buildargs=").append(new JSONObject(buildargs).toString());
                    }
                    request.append(" HTTP/1.1\r\n");
                    JSONObject registryConfig = new JSONObject();
                    JSONObject configs = new JSONObject();
                    registryConfig.put((Object)"configs", (Object)configs);
                    for (Credentials c : DockerConfig.getDefault().getAllCredentials()) {
                        configs.put((Object)c.getRegistry(), (Object)DockerAction.createAuthObject(c));
                    }
                    Pair configHeader = null;
                    if (!configs.isEmpty()) {
                        configHeader = Pair.of((Object)"X-Registry-Config", (Object)HttpUtils.encodeBase64(registryConfig.toJSONString()));
                    }
                    HttpUtils.configureHeaders(request, DockerConfig.getDefault().getHttpHeaders(), configHeader, DockerAction.this.getHostHeader(), Pair.of((Object)"Transfer-Encoding", (Object)"chunked"), Pair.of((Object)"Content-Type", (Object)"application/tar"), Pair.of((Object)"Content-Encoding", (Object)"gzip"));
                    request.append("\r\n");
                    OutputStream os = s.getOutputStream();
                    os.write(request.toString().getBytes(StandardCharsets.ISO_8859_1));
                    os.flush();
                    buildListener.onEvent(new BuildEvent(DockerAction.this.instance, request.toString(), false, null, false));
                    Future<Void> task = new FolderUploader(DockerAction.this.instance, os).upload(buildContext, new IgnoreFileFilter(buildContext, dockerfile, '/'), new FolderUploader.Listener(){

                        @Override
                        public void onUpload(String path) {
                            buildListener.onEvent(new BuildEvent(DockerAction.this.instance, path, false, null, true));
                        }
                    });
                    InputStream is = s.getInputStream();
                    HttpUtils.Response response = HttpUtils.readResponse(is);
                    int responseCode = response.getCode();
                    if (responseCode != 200) {
                        String string;
                        task.cancel(true);
                        String error = HttpUtils.readContent(is, response);
                        if (error != null) {
                            string = error;
                            throw DockerAction.codeToException(responseCode, string);
                        }
                        string = response.getMessage();
                        throw DockerAction.codeToException(responseCode, string);
                    }
                    try {
                        if (task.isDone()) {
                            task.get();
                        } else {
                            LOGGER.log(Level.INFO, "Server responded OK yet upload has not finished");
                            task.cancel(true);
                        }
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException ex) {
                        throw new DockerException(ex.getCause());
                    }
                    is = HttpUtils.getResponseStream(is, response, false);
                    JSONParser parser = new JSONParser();
                    try (InputStreamReader r = new InputStreamReader(is, HttpUtils.getCharset(response));){
                        String line;
                        String stream = null;
                        while ((line = DockerAction.readEventObject(r)) != null) {
                            JSONObject o = (JSONObject)parser.parse(line);
                            stream = (String)o.get((Object)"stream");
                            if (stream != null) {
                                buildListener.onEvent(new BuildEvent(DockerAction.this.instance, stream.trim(), false, null, false));
                            } else if (o.containsKey((Object)"status")) {
                                StatusEvent e = DockerAction.this.parseStatusEvent(o);
                                if (e != null) {
                                    statusListener.onEvent(e);
                                }
                            } else {
                                String error = (String)o.get((Object)"error");
                                if (error != null) {
                                    BuildEvent.Error detail = null;
                                    JSONObject detailObj = (JSONObject)o.get((Object)"errorDetail");
                                    if (detailObj != null) {
                                        long code = ((Number)DockerAction.getOrDefault((Map)detailObj, "code", 0)).longValue();
                                        String mesage = (String)detailObj.get((Object)"message");
                                        detail = new BuildEvent.Error(code, mesage);
                                    }
                                    buildListener.onEvent(new BuildEvent(DockerAction.this.instance, error, true, detail, false));
                                } else {
                                    LOGGER.log(Level.INFO, "Unknown event {0}", o);
                                }
                            }
                            parser.reset();
                        }
                        if (stream == null) return null;
                        Matcher m = ID_PATTERN.matcher(stream.trim());
                        if (!m.matches()) return null;
                        long time = System.currentTimeMillis() / 1000L;
                        if (DockerAction.this.emitEvents) {
                            DockerAction.this.instance.getEventBus().sendEvent(new DockerEvent(DockerAction.this.instance, DockerEvent.Status.PULL, m.group(1), null, time));
                        }
                        DockerImage dockerImage = new DockerImage(DockerAction.this.instance, Collections.singletonList(DockerUtils.getTag(repository, tag)), m.group(1), time, 0L, 0L);
                        return dockerImage;
                    }
                    catch (ParseException ex) {
                        throw new DockerException(ex);
                    }
                }
                catch (MalformedURLException e) {
                    DockerAction.closeEndpoint(s);
                    throw new DockerException(e);
                }
                catch (IOException e) {
                    DockerAction.closeEndpoint(s);
                    if (handler.isCancelled()) return null;
                    throw new DockerException(e);
                }
                catch (DockerException e) {
                    DockerAction.closeEndpoint(s);
                    throw e;
                }
            }
        };
        return new FutureTask<DockerImage>((Callable)callable){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                super.cancel(false);
                if (mayInterruptIfRunning) {
                    handler.cancel();
                }
                return true;
            }
        };
    }

    public ActionChunkedResult logs(DockerContainer container) throws DockerException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Remote access invoked from EDT";
        DockerContainerDetail info = this.getDetail(container);
        Endpoint s = null;
        try {
            StreamItem.Fetcher fetcher;
            s = this.createEndpoint();
            OutputStream os = s.getOutputStream();
            os.write(("GET /containers/" + container.getId() + "/logs?stderr=1&stdout=1&timestamps=1&follow=1 HTTP/1.1\r\n").getBytes(StandardCharsets.ISO_8859_1));
            HttpUtils.configureHeaders(os, DockerConfig.getDefault().getHttpHeaders(), this.getHostHeader());
            os.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            InputStream is = s.getInputStream();
            HttpUtils.Response response = HttpUtils.readResponse(is);
            int responseCode = response.getCode();
            if (responseCode != 101 && responseCode != 200) {
                String error = HttpUtils.readContent(is, response);
                throw new DockerRemoteException(responseCode, error != null ? error : response.getMessage());
            }
            is = HttpUtils.getResponseStream(is, response, true);
            Integer length = HttpUtils.getLength(response.getHeaders());
            if (length != null && length == 0) {
                assert (!(is instanceof ChunkedInputStream));
                LOGGER.log(Level.INFO, "Empty logs");
                fetcher = new StreamItem.Fetcher(){

                    @Override
                    public StreamItem fetch() {
                        return null;
                    }
                };
            } else {
                fetcher = info.isTty() ? new DirectFetcher(is) : new Demuxer(is);
            }
            return new ActionChunkedResult(s, fetcher, HttpUtils.getCharset(response));
        }
        catch (MalformedURLException e) {
            DockerAction.closeEndpoint(s);
            throw new DockerException(e);
        }
        catch (IOException e) {
            DockerAction.closeEndpoint(s);
            throw new DockerException(e);
        }
        catch (DockerException e) {
            DockerAction.closeEndpoint(s);
            throw e;
        }
    }

    public Pair<DockerContainer, ActionStreamResult> run(String name, JSONObject configuration) throws DockerException {
        Endpoint s = null;
        try {
            JSONObject value;
            s = this.createEndpoint();
            byte[] data = configuration.toJSONString().getBytes(StandardCharsets.UTF_8);
            Map<String, String> defaultHeaders = DockerConfig.getDefault().getHttpHeaders();
            OutputStream os = s.getOutputStream();
            os.write(("POST " + (name != null ? "/containers/create?name=" + HttpUtils.encodeParameter(name) : "/containers/create") + " HTTP/1.1\r\n").getBytes(StandardCharsets.ISO_8859_1));
            HttpUtils.configureHeaders(os, defaultHeaders, this.getHostHeader(), Pair.of((Object)"Content-Type", (Object)"application/json"), Pair.of((Object)"Content-Length", (Object)Integer.toString(data.length)));
            os.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.write(data);
            os.flush();
            InputStream is = s.getInputStream();
            HttpUtils.Response response = HttpUtils.readResponse(is);
            if (response.getCode() != 201) {
                String error = HttpUtils.readContent(is, response);
                throw new DockerRemoteException(response.getCode(), error != null ? error : response.getMessage());
            }
            InputStream nis = HttpUtils.getResponseStream(is, response, false);
            try {
                JSONParser parser = new JSONParser();
                value = (JSONObject)parser.parse(HttpUtils.readContent(nis, response));
            }
            catch (ParseException ex) {
                throw new DockerException(ex);
            }
            String id = (String)value.get((Object)"Id");
            DockerContainer container = new DockerContainer(this.instance, id, (String)configuration.get((Object)"Image"), "/" + name, DockerContainer.Status.STOPPED);
            ActionStreamResult r = this.attach(container, true, true);
            os.write(("POST /containers/" + id + "/start HTTP/1.1\r\n").getBytes(StandardCharsets.ISO_8859_1));
            HttpUtils.configureHeaders(os, defaultHeaders, this.getHostHeader());
            os.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            response = HttpUtils.readResponse(is);
            if (response.getCode() != 204) {
                String error = HttpUtils.readContent(is, response);
                throw DockerAction.codeToException(response.getCode(), error != null ? error : response.getMessage());
            }
            return Pair.of((Object)container, (Object)r);
        }
        catch (MalformedURLException e) {
            DockerAction.closeEndpoint(s);
            throw new DockerException(e);
        }
        catch (IOException e) {
            DockerAction.closeEndpoint(s);
            throw new DockerException(e);
        }
        catch (DockerException e) {
            DockerAction.closeEndpoint(s);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pingWithExceptions() throws Exception {
        assert (!SwingUtilities.isEventDispatchThread()) : "Remote access invoked from EDT";
        Endpoint s = this.createEndpoint();
        try {
            OutputStream os = s.getOutputStream();
            os.write(("GET /_ping HTTP/1.1\r\nHost: " + (String)this.getHostHeader().second() + "\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            InputStream is = s.getInputStream();
            HttpUtils.Response response = HttpUtils.readResponse(is);
            boolean bl = response.getCode() == 200;
            return bl;
        }
        finally {
            DockerAction.closeEndpoint(s);
        }
    }

    public boolean ping() {
        try {
            return this.pingWithExceptions();
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void events(Long since, DockerEvent.Listener listener, ConnectionListener connectionListener) throws DockerException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Remote access invoked from EDT";
        try {
            Endpoint s = this.createEndpoint();
            try {
                OutputStream os = s.getOutputStream();
                os.write(("GET " + (since != null ? "/events?since=" + since : "/events") + " HTTP/1.1\r\nHost: " + (String)this.getHostHeader().second() + "\r\nAccept: application/json\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
                os.flush();
                InputStream is = s.getInputStream();
                HttpUtils.Response response = HttpUtils.readResponse(is);
                int responseCode = response.getCode();
                if (responseCode != 200) {
                    String error = HttpUtils.readContent(is, response);
                    throw new DockerRemoteException(responseCode, error != null ? error : response.getMessage());
                }
                is = HttpUtils.getResponseStream(is, response, false);
                if (connectionListener != null) {
                    connectionListener.onConnect(s);
                }
                JSONParser parser = new JSONParser();
                try (InputStreamReader r = new InputStreamReader(is, HttpUtils.getCharset(response));){
                    String line;
                    while ((line = DockerAction.readEventObject(r)) != null) {
                        JSONObject o = (JSONObject)parser.parse(line);
                        DockerEvent.Status status = DockerEvent.Status.parse((String)o.get((Object)"status"));
                        String id = (String)o.get((Object)"id");
                        String from = (String)o.get((Object)"from");
                        long time = (Long)o.get((Object)"time");
                        if (status == null) {
                            LOGGER.log(Level.INFO, "Unknown event {0}", o);
                        } else {
                            listener.onEvent(new DockerEvent(this.instance, status, id, from, time));
                        }
                        parser.reset();
                    }
                }
                catch (ParseException ex) {
                    throw new DockerException(ex);
                }
                finally {
                    if (connectionListener != null) {
                        connectionListener.onDisconnect();
                    }
                }
            }
            finally {
                DockerAction.closeEndpoint(s);
            }
        }
        catch (MalformedURLException e) {
            throw new DockerException(e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Object doGetRequest(@NonNull String action, Set<Integer> okCodes) throws DockerException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Remote access invoked from EDT";
        try {
            Endpoint s = this.createEndpoint();
            try {
                Object object;
                OutputStream os = s.getOutputStream();
                os.write(("GET " + action + " HTTP/1.1\r\n").getBytes(StandardCharsets.ISO_8859_1));
                HttpUtils.configureHeaders(os, DockerConfig.getDefault().getHttpHeaders(), this.getHostHeader(), ACCEPT_JSON_HEADER);
                os.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
                os.flush();
                InputStream is = s.getInputStream();
                HttpUtils.Response response = HttpUtils.readResponse(is);
                int responseCode = response.getCode();
                if (!okCodes.contains(responseCode)) {
                    String error = HttpUtils.readContent(is, response);
                    throw DockerAction.codeToException(responseCode, error != null ? error : response.getMessage());
                }
                is = HttpUtils.getResponseStream(is, response, false);
                BufferedReader br = new BufferedReader(new InputStreamReader(is, HttpUtils.getCharset(response)));
                try {
                    JSONParser parser = new JSONParser();
                    object = parser.parse((Reader)br);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (ParseException ex) {
                        throw new DockerException(ex);
                    }
                }
                br.close();
                return object;
            }
            finally {
                DockerAction.closeEndpoint(s);
            }
        }
        catch (MalformedURLException e) {
            throw new DockerException(e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private Object doPostRequest(@NonNull String action, boolean output, Set<Integer> okCodes) throws DockerException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Remote access invoked from EDT";
        try {
            Endpoint s = this.createEndpoint();
            try {
                OutputStream os = s.getOutputStream();
                os.write(("POST " + action + " HTTP/1.1\r\n").getBytes(StandardCharsets.ISO_8859_1));
                HttpUtils.configureHeaders(os, DockerConfig.getDefault().getHttpHeaders(), this.getHostHeader(), Pair.of((Object)"Content-Type", (Object)"application/json"));
                os.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
                os.flush();
                InputStream is = s.getInputStream();
                HttpUtils.Response response = HttpUtils.readResponse(is);
                int responseCode = response.getCode();
                if (!okCodes.contains(responseCode)) {
                    String error = HttpUtils.readContent(is, response);
                    throw DockerAction.codeToException(responseCode, error != null ? error : response.getMessage());
                }
                if (output) {
                    Object object;
                    is = HttpUtils.getResponseStream(is, response, false);
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, HttpUtils.getCharset(response)));
                    try {
                        JSONParser parser = new JSONParser();
                        object = parser.parse((Reader)br);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (ParseException ex) {
                            throw new DockerException(ex);
                        }
                    }
                    br.close();
                    return object;
                }
                Object var9_14 = null;
                return var9_14;
            }
            finally {
                DockerAction.closeEndpoint(s);
            }
        }
        catch (MalformedURLException e) {
            throw new DockerException(e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private Object doDeleteRequest(@NonNull String action, boolean output, Set<Integer> okCodes) throws DockerException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Remote access invoked from EDT";
        try {
            Endpoint s = this.createEndpoint();
            try {
                OutputStream os = s.getOutputStream();
                os.write(("DELETE " + action + " HTTP/1.1\r\n").getBytes(StandardCharsets.ISO_8859_1));
                HttpUtils.configureHeaders(os, DockerConfig.getDefault().getHttpHeaders(), this.getHostHeader(), ACCEPT_JSON_HEADER);
                os.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
                os.flush();
                InputStream is = s.getInputStream();
                HttpUtils.Response response = HttpUtils.readResponse(is);
                int responseCode = response.getCode();
                if (!okCodes.contains(responseCode)) {
                    String error = HttpUtils.readContent(is, response);
                    throw DockerAction.codeToException(responseCode, error != null ? error : response.getMessage());
                }
                if (output) {
                    Object object;
                    is = HttpUtils.getResponseStream(is, response, false);
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, HttpUtils.getCharset(response)));
                    try {
                        JSONParser parser = new JSONParser();
                        object = parser.parse((Reader)br);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (ParseException ex) {
                            throw new DockerException(ex);
                        }
                    }
                    br.close();
                    return object;
                }
                Object var9_14 = null;
                return var9_14;
            }
            finally {
                DockerAction.closeEndpoint(s);
            }
        }
        catch (MalformedURLException e) {
            throw new DockerException(e);
        }
        catch (IOException e) {
            throw new DockerException(e);
        }
    }

    private StatusEvent parseStatusEvent(JSONObject o) {
        boolean error = false;
        String id = (String)o.get((Object)"id");
        String status = (String)o.get((Object)"status");
        if (status == null) {
            status = (String)o.get((Object)"error");
            boolean bl = error = status != null;
        }
        if (status == null) {
            LOGGER.log(Level.INFO, "Unknown event {0}", o);
            return null;
        }
        String progress = (String)o.get((Object)"progress");
        StatusEvent.Progress detail = null;
        JSONObject detailObj = (JSONObject)o.get((Object)"progressDetail");
        if (detailObj != null) {
            long current = ((Number)DockerAction.getOrDefault((Map)detailObj, "current", 1)).longValue();
            long total = ((Number)DockerAction.getOrDefault((Map)detailObj, "total", 1)).longValue();
            detail = new StatusEvent.Progress(current, total);
        }
        return new StatusEvent(this.instance, id, status, progress, error, detail);
    }

    private Endpoint createEndpoint() throws IOException {
        URL realUrl = this.getUrl();
        try {
            if ("https".equals(realUrl.getProtocol())) {
                SSLContext context = ContextProvider.getInstance().getSSLContext(this.instance);
                return Endpoint.forSocket(context.getSocketFactory().createSocket(realUrl.getHost(), realUrl.getPort()));
            }
            if ("http".equals(realUrl.getProtocol())) {
                Socket s = new Socket(ProxySelector.getDefault().select(realUrl.toURI()).get(0));
                int port = realUrl.getPort();
                if (port < 0) {
                    port = realUrl.getDefaultPort();
                }
                s.connect(new InetSocketAddress(realUrl.getHost(), port));
                return Endpoint.forSocket(s);
            }
            if ("file".equals(realUrl.getProtocol())) {
                AFUNIXSocket s = AFUNIXSocket.newInstance();
                AFUNIXSocketAddress sockAdd = AFUNIXSocketAddress.of((File)new File(realUrl.getFile()));
                s.connect((SocketAddress)sockAdd);
                return Endpoint.forSocket((Socket)s);
            }
            throw new IOException("Unknown protocol: " + realUrl.getProtocol());
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    private Pair<String, String> getHostHeader() throws MalformedURLException {
        URL url = this.getUrl();
        int port = url.getPort();
        if (port <= 0) {
            return Pair.of((Object)"Host", (Object)url.getHost());
        }
        return Pair.of((Object)"Host", (Object)(url.getHost() + ":" + port));
    }

    private URL getUrl() throws MalformedURLException {
        String url = this.instance.getUrl();
        if (url.startsWith("tcp://")) {
            url = "http://" + url.substring(6);
        } else if (url.startsWith("unix://")) {
            url = "file://" + url.substring(7);
        }
        return new URL(url);
    }

    private static JSONObject createAuthObject(Credentials credentials) {
        JSONObject value = new JSONObject();
        if (credentials == null) {
            value.put((Object)"auth", (Object)"");
            value.put((Object)"email", (Object)"");
        } else {
            value.put((Object)"username", (Object)credentials.getUsername());
            value.put((Object)"password", (Object)new String(credentials.getPassword()));
            value.put((Object)"email", (Object)credentials.getEmail());
            value.put((Object)"serveraddress", (Object)credentials.getRegistry());
            value.put((Object)"auth", (Object)"");
        }
        return value;
    }

    private static String getAuthenticationFailure(StatusEvent e) {
        if (!e.isError()) {
            return null;
        }
        if (e.getMessage().contains("Authentication is required") || e.getMessage().contains("Status 401") || e.getMessage().contains("401 Unauthorized") || e.getMessage().contains("status code 401")) {
            return e.getMessage();
        }
        return null;
    }

    private static DockerException codeToException(int code, String message) {
        if (code == 409) {
            return new DockerConflictException(message);
        }
        if (code == 401) {
            return new DockerAuthenticationException(message);
        }
        return new DockerRemoteException(code, message);
    }

    private static String readEventObject(Reader is) throws IOException {
        int b;
        StringWriter sw = new StringWriter();
        int balance = -1;
        while ((b = is.read()) != -1) {
            if (balance < 0) {
                if (b != 123) continue;
                balance = 1;
                sw.write(b);
                continue;
            }
            if (b == 123) {
                ++balance;
            } else if (b == 125) {
                --balance;
            }
            sw.write(b);
            if (balance != 0) continue;
            return sw.toString();
        }
        return null;
    }

    private static void closeEndpoint(Endpoint s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    private static Object getOrDefault(Map map, Object key, Object def) {
        Object ret = map.get(key);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    private static String getImage(DockerTag tag) {
        String id = tag.getTag();
        if (id.equals("<none>:<none>")) {
            id = tag.getImage().getId();
        }
        return id;
    }

    public JSONObject getRunningProcessesList(DockerContainer container) throws DockerException {
        JSONObject value = (JSONObject)this.doGetRequest(DockerEntityType.Container.getUrlPath() + container.getId() + "/top", Collections.singleton(200));
        return value;
    }

    static {
        DockerActionAccessor.setDefault(new DockerActionAccessor(){

            @Override
            public void events(DockerAction action, Long since, DockerEvent.Listener listener, ConnectionListener connectionListener) throws DockerException {
                action.events(since, listener, connectionListener);
            }
        });
        Collections.addAll(START_STOP_CONTAINER_CODES, 204, 304);
        Collections.addAll(REMOVE_CONTAINER_CODES, 204, 404);
        Collections.addAll(REMOVE_IMAGE_CODES, 200, 404);
    }

    private static class CancelHandler {
        private Endpoint endpoint;
        private boolean cancelled;

        private CancelHandler() {
        }

        public synchronized void setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public synchronized void cancel() {
            if (this.endpoint != null) {
                DockerAction.closeEndpoint(this.endpoint);
                this.endpoint = null;
                this.cancelled = true;
            }
        }

        public synchronized boolean isCancelled() {
            return this.cancelled;
        }
    }

    private static class EmptyStreamResult
    implements StreamResult {
        private final OutputStream os = new NullOutputStream();
        private final InputStream is = new NullInputStream();
        private final boolean tty;

        public EmptyStreamResult(boolean tty) {
            this.tty = tty;
        }

        @Override
        public OutputStream getStdIn() {
            return this.os;
        }

        @Override
        public InputStream getStdOut() {
            return this.is;
        }

        @Override
        public InputStream getStdErr() {
            return null;
        }

        @Override
        public boolean hasTty() {
            return this.tty;
        }

        @Override
        public Charset getCharset() {
            return StandardCharsets.UTF_8;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class DirectFetcher
    implements StreamItem.Fetcher {
        private final InputStream is;
        private final byte[] buffer = new byte[1024];

        public DirectFetcher(InputStream is) {
            this.is = is;
        }

        @Override
        public StreamItem fetch() {
            try {
                int count = this.is.read(this.buffer);
                if (count < 0) {
                    return null;
                }
                return new StreamItem(ByteBuffer.wrap(this.buffer, 0, count), false);
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, null, ex);
                return null;
            }
        }
    }
}

