/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.rules.Bundle;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.filesystems.FileObject;

public final class PersistentTimerInEjbLite {
    public static Collection<ErrorDescription> run(HintContext hintContext) {
        ArrayList<ErrorDescription> problems = new ArrayList<ErrorDescription>();
        EJBProblemContext ctx = HintsUtils.getOrCacheContext(hintContext);
        if (ctx != null && ctx.getEjb() instanceof Session) {
            boolean ee9lite = ctx.getEjbModule().getJ2eeProfile().isAtLeast(Profile.JAKARTA_EE_9_WEB);
            boolean ee7lite = ctx.getEjbModule().getJ2eeProfile().isAtLeast(Profile.JAVA_EE_7_WEB);
            boolean ee6lite = ctx.getEjbModule().getJ2eeProfile() == Profile.JAVA_EE_6_WEB;
            J2eePlatform platform = ProjectUtil.getPlatform((Project)ctx.getProject());
            if ((ee6lite || ee7lite || ee9lite) && PersistentTimerInEjbLite.nonEeFullServer(platform)) {
                for (Element element : ctx.getClazz().getEnclosedElements()) {
                    for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                        if (!"javax.ejb.Schedule".equals(annotationMirror.getAnnotationType().toString())) continue;
                        if (ee6lite) {
                            problems.add(HintsUtils.createProblem(element, hintContext.getInfo(), Bundle.PersistentTimerInEjbLite_err_timer_in_ee6lite(), Severity.ERROR));
                        }
                        if (!ee7lite || !PersistentTimerInEjbLite.isTimerPersistent(annotationMirror.getElementValues())) continue;
                        PersistentTimerInEjbLiteFix fix = new PersistentTimerInEjbLiteFix(ctx.getFileObject(), element);
                        problems.add(HintsUtils.createProblem(element, hintContext.getInfo(), Bundle.PersistentTimerInEjbLite_err_nonpersistent_timer_in_ee7lite(), Severity.ERROR, fix));
                    }
                }
            }
        }
        return problems;
    }

    private static boolean nonEeFullServer(J2eePlatform platform) {
        if (platform == null) {
            return true;
        }
        if (platform.getSupportedProfiles().contains(Profile.JAVA_EE_6_FULL)) {
            return false;
        }
        if (platform.getSupportedProfiles().contains(Profile.JAVA_EE_7_FULL)) {
            return false;
        }
        if (platform.getSupportedProfiles().contains(Profile.JAVA_EE_8_FULL)) {
            return false;
        }
        if (platform.getSupportedProfiles().contains(Profile.JAKARTA_EE_8_FULL)) {
            return false;
        }
        if (platform.getSupportedProfiles().contains(Profile.JAKARTA_EE_9_FULL)) {
            return false;
        }
        if (platform.getSupportedProfiles().contains(Profile.JAKARTA_EE_9_1_FULL)) {
            return false;
        }
        return !platform.getSupportedProfiles().contains(Profile.JAKARTA_EE_10_FULL);
    }

    private static boolean isTimerPersistent(Map<? extends ExecutableElement, ? extends AnnotationValue> values) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
            Object elementValue;
            if (!entry.getKey().getSimpleName().contentEquals("persistent") || !((elementValue = entry.getValue().getValue()) instanceof Boolean)) continue;
            return (Boolean)elementValue;
        }
        return true;
    }

    private static class PersistentTimerInEjbLiteFix
    implements Fix {
        private final ElementHandle methodElement;
        private final FileObject fileObject;

        private PersistentTimerInEjbLiteFix(FileObject fileObject, Element methodElement) {
            this.fileObject = fileObject;
            this.methodElement = ElementHandle.create((Element)methodElement);
        }

        public String getText() {
            return Bundle.PersistentTimerInEjbLiteFix_lbl_make_timer_nonpersistent();
        }

        public ChangeInfo implement() throws Exception {
            Task<WorkingCopy> task = new Task<WorkingCopy>(){

                public void run(WorkingCopy copy) throws Exception {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    this.fixTimerAnnotation(copy);
                }
            };
            JavaSource js = JavaSource.forFileObject((FileObject)this.fileObject);
            if (js != null) {
                js.runModificationTask((Task)task).commit();
            }
            return null;
        }

        public void fixTimerAnnotation(WorkingCopy copy) {
            TypeElement scheduleAnnotation = copy.getElements().getTypeElement("javax.ejb.Schedule");
            ModifiersTree modifiers = ((MethodTree)copy.getTrees().getPath(this.methodElement.resolve((CompilationInfo)copy)).getLeaf()).getModifiers();
            TreeMaker tm = copy.getTreeMaker();
            for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
                TreePath tp = new TreePath(new TreePath(copy.getCompilationUnit()), annotationTree.getAnnotationType());
                Element e = copy.getTrees().getElement(tp);
                if (!scheduleAnnotation.equals(e)) continue;
                List<? extends ExpressionTree> arguments = annotationTree.getArguments();
                for (ExpressionTree expressionTree : arguments) {
                    if (expressionTree.getKind() != Tree.Kind.ASSIGNMENT) continue;
                    AssignmentTree assignment = (AssignmentTree)expressionTree;
                    AssignmentTree newAssignment = tm.Assignment(assignment.getVariable(), (ExpressionTree)tm.Literal((Object)false));
                    if (!"persistent".equals(assignment.getVariable().toString())) continue;
                    copy.rewrite((Tree)modifiers, copy.getTreeUtilities().translate((Tree)modifiers, Collections.singletonMap(expressionTree, newAssignment)));
                    return;
                }
                ArrayList<? extends ExpressionTree> newArguments = new ArrayList<ExpressionTree>(arguments);
                ExpressionTree expressionTree = tm.QualIdent("persistent");
                newArguments.add(tm.Assignment(expressionTree, (ExpressionTree)tm.Literal((Object)false)));
                AnnotationTree newAnnotation = tm.Annotation(tp.getLeaf(), newArguments);
                copy.rewrite((Tree)annotationTree, (Tree)newAnnotation);
                return;
            }
        }
    }
}

