/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.chrome;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.PrivateBrowserFamilyId;
import org.netbeans.modules.extbrowser.plugins.ExtensionManager;
import org.netbeans.modules.extbrowser.plugins.ExternalBrowserPlugin;
import org.netbeans.modules.extbrowser.plugins.MessageDispatcherImpl;
import org.netbeans.modules.extbrowser.plugins.PageInspectionHandleImpl;
import org.netbeans.modules.extbrowser.plugins.RemoteScriptExecutor;
import org.netbeans.modules.extbrowser.plugins.chrome.WebKitDebuggingTransport;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.WebBrowserFeatures;
import org.netbeans.modules.web.browser.spi.EnhancedBrowser;
import org.netbeans.modules.web.webkit.debugging.spi.Factory;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ChromeBrowserImpl
extends HtmlBrowser.Impl
implements EnhancedBrowser {
    private static final Logger LOG = Logger.getLogger(ChromeBrowserImpl.class.getName());
    private Lookup lookup;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private URL url;
    protected String title = "";
    private ExtBrowserImpl delegate;
    private ExternalBrowserPlugin.BrowserTabDescriptor browserTabDescriptor = null;
    private boolean enhancedMode;
    private WebBrowserFeatures browserFeatures;
    private Lookup projectContext;
    private String newURL = null;
    private boolean temporaryEnhancedMode = false;

    public ChromeBrowserImpl(ExtBrowserImpl delegate, boolean enhancedMode) {
        this.delegate = delegate;
        this.enhancedMode = enhancedMode;
    }

    public boolean hasEnhancedMode() {
        return this.enhancedMode || this.temporaryEnhancedMode;
    }

    public void setTemporaryEnhancedMode(boolean mode) {
        this.temporaryEnhancedMode = mode;
        this.lookup = null;
    }

    public boolean hasTemporaryEnhancedMode() {
        return this.temporaryEnhancedMode;
    }

    public boolean ignoreChange(FileObject fo) {
        if (this.getBrowserTabDescriptor() != null && this.getBrowserTabDescriptor().isInitialized()) {
            return BrowserSupport.ignoreChangeDefaultImpl((FileObject)fo);
        }
        return false;
    }

    public void initialize(WebBrowserFeatures browserFeatures) {
        this.browserFeatures = browserFeatures;
    }

    public WebBrowserFeatures getBrowserFeatures() {
        return this.browserFeatures;
    }

    public boolean canReloadPage() {
        return this.getBrowserTabDescriptor() != null;
    }

    private Lookup createLookup() {
        ArrayList<Lookup> lookups = new ArrayList<Lookup>();
        if (this.hasEnhancedMode()) {
            lookups.add(Lookups.fixed((Object[])new Object[]{new MessageDispatcherImpl(), new RemoteScriptExecutor(this), new PageInspectionHandleImpl(this)}));
            WebKitDebuggingTransport transport = new WebKitDebuggingTransport(this);
            lookups.add(Lookups.fixed((Object[])new Object[]{transport, Factory.createWebKitDebugging((TransportImplementation)transport)}));
        }
        return new ProxyLookup(lookups.toArray(new Lookup[lookups.size()]));
    }

    public boolean isBackward() {
        return false;
    }

    public boolean isForward() {
        return false;
    }

    public void backward() {
    }

    public void forward() {
    }

    public boolean isHistory() {
        return false;
    }

    public void showHistory() {
    }

    public void stopLoading() {
    }

    protected void setTitle(String title) {
    }

    public String getTitle() {
        return "";
    }

    public String getStatusMessage() {
        return "";
    }

    public void reloadDocument() {
        if (this.url == null) {
            return;
        }
        ExternalBrowserPlugin.BrowserTabDescriptor tab = this.getBrowserTabDescriptor();
        if (tab != null) {
            URL u = this.url;
            if (this.newURL != null) {
                try {
                    URL u2 = new URL(this.newURL);
                    if (u2.getAuthority() != null && u2.getAuthority().equals(u.getAuthority())) {
                        u = u2;
                    }
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            ExternalBrowserPlugin.getInstance().showURLInTab(tab, u);
        } else if (!this.hasEnhancedMode()) {
            this.setURL(this.url);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public void close(boolean closeTab) {
        ExternalBrowserPlugin.BrowserTabDescriptor tab = this.getBrowserTabDescriptor();
        if (tab != null) {
            ExternalBrowserPlugin.getInstance().close(tab, closeTab);
        }
    }

    public void setProjectContext(Lookup projectContext) {
        this.projectContext = projectContext;
    }

    public Lookup getProjectContext() {
        return this.projectContext;
    }

    public void setURL(URL url) {
        this.newURL = null;
        assert (this.delegate.getPrivateBrowserFamilyId() == PrivateBrowserFamilyId.CHROMIUM || this.delegate.getPrivateBrowserFamilyId() == PrivateBrowserFamilyId.CHROME) : "wrong browser: " + this.delegate + " " + this.delegate.getPrivateBrowserFamilyId();
        BrowserFamilyId pluginId = this.delegate.getPrivateBrowserFamilyId() == PrivateBrowserFamilyId.CHROMIUM ? BrowserFamilyId.CHROMIUM : BrowserFamilyId.CHROME;
        ExtensionManager.ExtensitionStatus status = ExtensionManager.isInstalled(pluginId);
        ExternalBrowserPlugin.BrowserTabDescriptor tab = this.getBrowserTabDescriptor();
        if (this.hasEnhancedMode()) {
            if (tab == null) {
                boolean browserPluginAvailable = true;
                if (status == ExtensionManager.ExtensitionStatus.DISABLED) {
                    browserPluginAvailable = false;
                } else if (status == ExtensionManager.ExtensitionStatus.MISSING || status == ExtensionManager.ExtensitionStatus.NEEDS_UPGRADE) {
                    browserPluginAvailable = ExtensionManager.installExtension(pluginId, status);
                }
                if (browserPluginAvailable) {
                    if (ExternalBrowserPlugin.getInstance().isServerRunning()) {
                        URL tempUrl = this.createBlankHTMLPage();
                        assert (tempUrl != null);
                        ExternalBrowserPlugin.getInstance().register(tempUrl, url, this);
                        this.delegate.setURL(tempUrl);
                    } else {
                        this.delegate.setURL(url);
                    }
                }
            } else {
                tab.reEnableReInitialization();
                ExternalBrowserPlugin.getInstance().showURLInTab(tab, url);
            }
        } else {
            ExternalBrowserPlugin.getInstance();
            if (status == ExtensionManager.ExtensitionStatus.INSTALLED) {
                if (tab == null) {
                    ExternalBrowserPlugin.getInstance().register(url, url, this);
                    this.delegate.setURL(url);
                } else {
                    ExternalBrowserPlugin.getInstance().showURLInTab(tab, url);
                }
            } else {
                this.delegate.setURL(url);
            }
        }
        this.url = url;
    }

    private URL createBlankHTMLPage() {
        try {
            Path tempPath = Files.createTempFile("blank", ".html", new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(tempPath, new OpenOption[0]);
                 OutputStreamWriter osw = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
                osw.write("<html :netbeans_temporary=\"true\"></html>");
            }
            return tempPath.toRealPath(new LinkOption[0]).toUri().toURL();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Failed to create blank page for chrome", ex);
            return null;
        }
    }

    public final Component getComponent() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public final Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = this.createLookup();
        }
        return this.lookup;
    }

    public void wasClosed() {
        this.setBrowserTabDescriptor(null);
        this.url = null;
        this.pcs.firePropertyChange("browser.was.closed", null, null);
    }

    public synchronized ExternalBrowserPlugin.BrowserTabDescriptor getBrowserTabDescriptor() {
        return this.browserTabDescriptor;
    }

    public synchronized void setBrowserTabDescriptor(ExternalBrowserPlugin.BrowserTabDescriptor browserTabDescriptor) {
        this.browserTabDescriptor = browserTabDescriptor;
    }

    public void urlHasChanged(String newURL) {
        this.newURL = newURL;
        this.pcs.firePropertyChange("url", null, null);
    }
}

