/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.lsp.server.explorer.TreeItem;
import org.netbeans.modules.java.lsp.server.explorer.TreeNodeRegistry;
import org.netbeans.modules.java.lsp.server.explorer.WeakIdentityMap;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeDataEvent;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeDataListener;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeDataProvider;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeItemData;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class TreeViewProvider {
    private static final Logger LOG = Logger.getLogger(TreeViewProvider.class.getName());
    static final RequestProcessor INITIALIZE = new RequestProcessor("Initialize nodes", 5);
    private static final int NODE_CHANGE_DELAY = 100;
    private final String treeId;
    private final ExplorerManager manager;
    private final NodeListener nodeListener;
    private final TreeNodeRegistry nodeRegistry;
    private final Lookup context;
    private final Lookup.Result<? extends TreeDataProvider.Factory> factories;
    private final TreeDataListener l = new TreeDataListener(){

        @Override
        public void treeItemDataChanged(TreeDataEvent e) {
            TreeViewProvider.this.queueNodeChange(e.getOriginalNode());
        }
    };
    private final RequestProcessor.Task nodeChanges = INITIALIZE.create((Runnable)new Firer());
    private TreeDataProvider clientProvider;
    private Set<Node> changes = new LinkedHashSet<Node>();
    private TreeDataProvider[] providers;
    private SortedMap<Integer, NodeHolder> holdChildren = new TreeMap<Integer, NodeHolder>();
    private WeakIdentityMap<Node, Integer> idMap = WeakIdentityMap.newHashMap();
    static final Node DUMMY_NODE = new AbstractNode(Children.LEAF);
    static final TreeViewProvider NONE = new TreeViewProvider("", TreeViewProvider.dummyManager(), null, Lookup.EMPTY){
        final Node root = TreeViewProvider.access$600(this).getRootContext();

        @Override
        public CompletionStage<TreeItem> getRootInfo() {
            return super.getRootInfo();
        }

        @Override
        public Node findNode(int id) {
            return this.root;
        }

        @Override
        protected int findId(Node n) {
            return -1;
        }

        @Override
        protected void onDidChangeTreeData(Node n, int id) {
        }
    };

    protected TreeViewProvider(final String treeId, ExplorerManager manager, TreeNodeRegistry registry, Lookup context) {
        this.treeId = treeId;
        this.context = context;
        this.manager = manager;
        this.nodeRegistry = registry;
        this.nodeListener = new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
                LOG.log(Level.FINER, "tree {0} children of node {2} added: {1}", new Object[]{treeId, ev, ev.getNode()});
                this.notifyChange(ev.getNode());
            }

            public void childrenRemoved(NodeMemberEvent ev) {
                LOG.log(Level.FINER, "tree {0} children of node {2} removed: {1}", new Object[]{treeId, ev, ev.getNode()});
                this.notifyChange(ev.getNode());
            }

            public void childrenReordered(NodeReorderEvent ev) {
                LOG.log(Level.FINER, "tree {0} children of node {2} reordered: {1}", new Object[]{treeId, ev, ev.getNode()});
                this.notifyChange(ev.getNode());
            }

            public void nodeDestroyed(NodeEvent ev) {
                LOG.log(Level.FINER, "tree {0} children of node {2} destroyed: {1}", new Object[]{treeId, ev, ev.getNode()});
                TreeViewProvider.this.removeNode(ev.getNode());
                this.notifyChange(ev.getNode());
            }

            public void propertyChange(PropertyChangeEvent ev) {
                LOG.log(Level.FINER, "tree {0} property of node {2} changed: {1}", new Object[]{treeId, ev, ev.getSource()});
                this.notifyChange((Node)ev.getSource());
            }

            private void notifyChange(Node src) {
                int id = TreeViewProvider.this.findId(src);
                LOG.log(Level.FINER, "tree {0} tree item changed: {1}", new Object[]{treeId, id});
                TreeViewProvider.this.onDidChangeTreeData(src, id);
            }
        };
        this.factories = context.lookupResult(TreeDataProvider.Factory.class);
        this.factories.addLookupListener(e -> this.refreshProviders());
        this.findId(manager.getRootContext());
        this.refreshProviders();
    }

    protected abstract void onDidChangeTreeData(Node var1, int var2);

    public Lookup getLookup() {
        return this.context;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private Integer releaseNode(Node n) {
        Integer lspId;
        LOG.log(Level.FINER, "Released node: {0}", n);
        for (TreeDataProvider p : this.providers) {
            p.nodeReleased(n);
        }
        if (this.clientProvider != null) {
            this.clientProvider.nodeReleased(n);
        }
        if ((lspId = this.idMap.remove(n)) != null && this.nodeRegistry != null) {
            this.nodeRegistry.unregisterNode(lspId, n);
        }
        return lspId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(Node n) {
        Integer parentLspId;
        Node parent = n.getParentNode();
        LOG.log(Level.FINER, "Removed node: {0}", n);
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            Integer lspId = this.releaseNode(n);
            parentLspId = this.idMap.get(parent);
            if (!(lspId instanceof Integer) || !(parentLspId instanceof Integer)) {
                return;
            }
            NodeHolder nh = (NodeHolder)this.holdChildren.get(parentLspId);
            if (nh == null || nh.id2Child == null) {
                return;
            }
            if (nh.id2Child.remove(lspId) != n) {
                return;
            }
        }
        this.onDidChangeTreeData(parent, parentLspId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChildrenChange(Node parent) {
        int id = this.findId(parent);
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            NodeHolder nh = (NodeHolder)this.holdChildren.get(id);
            if (nh == null || nh.id2Child == null) {
                return;
            }
        }
        this.onDidChangeTreeData(parent, id);
    }

    public final CompletionStage childrenCollapsed(int id) {
        return this.childrenCollapsed(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientProvider(TreeDataProvider p) {
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            this.clientProvider = p;
        }
        this.refreshProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CompletionStage<Void> childrenCollapsed(int id, boolean fromClient) {
        Set<Integer> childIds;
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            NodeHolder nh = (NodeHolder)this.holdChildren.get(id);
            if (nh == null || nh.id2Child == null) {
                return CompletableFuture.completedFuture(null);
            }
            childIds = nh.id2Child.keySet();
            if (fromClient) {
                LOG.log(Level.FINER, "Client node collapsed: {0}:{1}, will collapse {2} direct children", new Object[]{id, nh.node, childIds.size()});
            }
            nh.id2Child = null;
            this.holdChildren.keySet().removeAll(Arrays.asList(childIds));
            this.idMap.remove(nh.node);
        }
        INITIALIZE.post(() -> {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Cascading collapse from {0} to {1}", new Object[]{id, Arrays.asList(childIds)});
            }
            Iterator iterator = childIds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.childrenCollapsed(i, false);
            }
        });
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node findNode(int id) {
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            NodeHolder nh = (NodeHolder)this.holdChildren.get(id);
            return nh == null ? null : nh.node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int findId(Node n) {
        if (n == null) {
            return -1;
        }
        if (this.nodeRegistry == null) {
            return -1;
        }
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            Integer lspId = this.idMap.get(n);
            if (lspId != null) {
                return lspId;
            }
        }
        int id = this.nodeRegistry.registerNode(n, this);
        TreeViewProvider treeViewProvider2 = this;
        synchronized (treeViewProvider2) {
            this.idMap.put(n, id);
            this.holdChildren.put(id, new NodeHolder(id, n));
        }
        n.addNodeListener(this.nodeListener);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeItem findTreeItem(Node n) {
        TreeNodeRegistry.ImageDataOrIndex idoi;
        boolean expanded;
        int id;
        LOG.log(Level.FINER, "Finding tree item for node {0}", n);
        TreeDataProvider[] pa = this.providers;
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            id = this.findId(n);
            expanded = id >= 0 && ((NodeHolder)this.holdChildren.get((Object)Integer.valueOf((int)id))).id2Child != null;
        }
        TreeItemData data = new TreeItemData();
        if (pa != null) {
            for (TreeDataProvider p : pa) {
                TreeItemData contrib = p.createDecorations(n, expanded);
                if (contrib == null) continue;
                data.merge(contrib);
            }
        }
        String v = data.getContextValues() == null ? "" : String.join((CharSequence)" ", data.getContextValues());
        TreeItem ti = new TreeItem(id, n, expanded, v);
        if (data.isLeaf()) {
            ti.collapsibleState = TreeItem.CollapsibleState.None;
        }
        if (data.getIconImage() != null && data.getIconImage() != DUMMY_NODE.getIcon(1) && (idoi = this.nodeRegistry.imageOrIndex(data.getIconImage())) != null) {
            try {
                URI baseURI = TreeViewProvider.builtinURI2URI(idoi.baseURI);
                if (baseURI != null) {
                    ti.iconDescriptor = new TreeItem.IconDescriptor();
                    ti.iconDescriptor.baseUri = baseURI;
                    ti.iconDescriptor.composition = idoi.composition;
                }
            }
            catch (URISyntaxException ex) {
                LOG.log(Level.WARNING, "Cannot convert URL: {0}", idoi.baseURI);
            }
        }
        ti.contextValue = v;
        ti.command = data.getCommand();
        if (data.getResourceURI() != null) {
            ti.resourceUri = data.getResourceURI().toString();
        }
        LOG.log(Level.FINER, "Finding tree item for node {0} => {1} ", new Object[]{n, ti});
        return ti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] childrenIds(Node parent, Node[] nodes) {
        Map<Integer, Node> obsolete;
        NodeHolder nh;
        HashMap<Integer, Node> newId2Node = new HashMap<Integer, Node>();
        int parentId = this.findId(parent);
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            nh = (NodeHolder)this.holdChildren.get(parentId);
            if (nh == null) {
                nh = new NodeHolder(parentId, parent);
                this.holdChildren.put(nh.nodeId, nh);
            }
        }
        LOG.log(Level.FINER, "Expanded node id {0}: {1}", new Object[]{parentId, parent});
        int[] ids = new int[nodes.length];
        for (int i = 0; i < ids.length; ++i) {
            int nid;
            ids[i] = nid = this.findId(nodes[i]);
            newId2Node.put(nid, nodes[i]);
        }
        TreeViewProvider treeViewProvider2 = this;
        synchronized (treeViewProvider2) {
            if (nh.id2Child != null) {
                obsolete = nh.id2Child;
                obsolete.keySet().removeAll(newId2Node.keySet());
            } else {
                obsolete = null;
            }
            nh.id2Child = newId2Node;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Children of id {0}: {1}", new Object[]{parentId, Arrays.toString(ids)});
        }
        if (obsolete != null) {
            treeViewProvider2 = this;
            synchronized (treeViewProvider2) {
                for (Node n : obsolete.values()) {
                    this.releaseNode(n);
                }
            }
        }
        return ids;
    }

    public final CompletionStage<int[]> getChildren(int id) {
        Node n = this.findNode(id);
        return this.getChildren(n).thenApply(nodes -> this.childrenIds(n, (Node[])nodes));
    }

    public final CompletionStage<Node[]> getChildren(Node nodeOrNull) {
        Node node = this.getNodeOrRoot(nodeOrNull);
        return CompletableFuture.completedFuture(node.getChildren().getNodes());
    }

    public final CompletionStage<Node> getParent(Node node) {
        return CompletableFuture.completedFuture(node.getParentNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Integer> getNodeId(Node n) {
        ArrayList<Node> toExpand = new ArrayList<Node>();
        toExpand.add(n);
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            Node parent;
            Integer i = this.idMap.get(n);
            if (i != null) {
                return CompletableFuture.completedFuture(i);
            }
            for (parent = n.getParentNode(); parent != null; parent = parent.getParentNode()) {
                toExpand.add(parent);
                i = this.idMap.get(parent);
                if (i != null) break;
            }
            if (parent == null) {
                return CompletableFuture.completedFuture(null);
            }
        }
        CompletionStage<Integer> nextStage = null;
        for (int idx = toExpand.size() - 1; idx > 0; --idx) {
            CompletionStage<Object> stage = null;
            Node p = (Node)toExpand.get(idx);
            stage = nextStage == null ? this.getChildren(p) : nextStage.thenCompose(x -> this.getChildren(p));
            int fidx = idx - 1;
            nextStage = stage.thenApply(ch -> this.findId((Node)toExpand.get(fidx)));
        }
        return nextStage;
    }

    public final CompletionStage<TreeItem> getTreeItem(int id) {
        return this.getTreeItem(this.findNode(id));
    }

    public CompletionStage<TreeItem> getRootInfo() {
        Node n = this.getNodeOrRoot(null);
        return CompletableFuture.completedFuture(this.findTreeItem(n));
    }

    private final CompletionStage<TreeItem> getTreeItem(Node n) {
        TreeItem item = this.findTreeItem(n);
        return CompletableFuture.completedFuture(item);
    }

    private Node getNodeOrRoot(Node nodeOrNull) {
        Node node = nodeOrNull == null ? this.manager.getRootContext() : nodeOrNull;
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNodeChange(Node n) {
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            boolean sch = this.changes.isEmpty();
            this.changes.add(n);
            if (sch) {
                this.nodeChanges.schedule(100);
            }
        }
    }

    private synchronized Set<Node> changes() {
        Set<Node> q = this.changes;
        if (q.isEmpty()) {
            return null;
        }
        this.changes = new LinkedHashSet<Node>();
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshProviders() {
        TreeDataProvider[] old;
        TreeDataProvider clP;
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            clP = this.clientProvider;
            old = this.providers;
        }
        ArrayList<TreeDataProvider> l = new ArrayList<TreeDataProvider>();
        if (clP != null) {
            l.add(clP);
        }
        for (TreeDataProvider.Factory f : this.factories.allInstances()) {
            TreeDataProvider p = f.createProvider(this.treeId);
            if (p == null) continue;
            l.add(p);
        }
        TreeDataProvider[] n = l.isEmpty() ? null : l.toArray(new TreeDataProvider[l.size()]);
        if (Objects.deepEquals(old, n)) {
            return;
        }
        TreeViewProvider treeViewProvider2 = this;
        synchronized (treeViewProvider2) {
            this.providers = n;
        }
        this.onDidChangeTreeData(null, -1);
    }

    private static ExplorerManager dummyManager() {
        ExplorerManager m = new ExplorerManager();
        m.setRootContext(DUMMY_NODE);
        return m;
    }

    static URI builtinURI2URI(URI u) throws URISyntaxException {
        if (u == null) {
            return null;
        }
        try {
            URL u2;
            String s;
            int i;
            if ("jar".equals(u.getScheme()) && (i = (s = (u2 = u.toURL()).getPath()).indexOf(33)) != -1) {
                return new URI("nbres", s.substring(i + 1), null);
            }
        }
        catch (MalformedURLException ex) {
            throw new URISyntaxException(u.toString(), ex.getMessage());
        }
        return u;
    }

    public static URI findImageURI(Image i) {
        URL u = ImageUtilities.findImageBaseURL((Image)i);
        if (u == null) {
            return null;
        }
        String s = u.toString();
        try {
            if (s.contains(":")) {
                return new URI(s);
            }
            return new URI("nbres:/" + s);
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.WARNING, "Unable to interpret image ID: {0}", s);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SortedMap<Integer, NodeHolder> getHolders() {
        TreeViewProvider treeViewProvider = this;
        synchronized (treeViewProvider) {
            return new TreeMap<Integer, NodeHolder>(this.holdChildren);
        }
    }

    static /* synthetic */ ExplorerManager access$600(TreeViewProvider x0) {
        return x0.manager;
    }

    class Firer
    implements Runnable {
        Firer() {
        }

        @Override
        public void run() {
            Set toFire = TreeViewProvider.this.changes();
            if (toFire == null) {
                return;
            }
            for (Node n : toFire) {
                int id = TreeViewProvider.this.findId(n);
                if (id == -1) continue;
                TreeViewProvider.this.onDidChangeTreeData(n, id);
            }
        }
    }

    static class NodeHolder {
        private final int nodeId;
        private final Node node;
        Map<Integer, Node> id2Child;

        public NodeHolder(int nodeId, Node node) {
            this.nodeId = nodeId;
            this.node = node;
        }
    }
}

