/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.refactoring;

import com.google.gson.Gson;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.refactoring.Bundle;
import org.netbeans.modules.java.lsp.server.refactoring.CodeRefactoring;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.openide.filesystems.FileObject;

public final class PullUpRefactoring
extends CodeRefactoring {
    private static final String PULL_UP_REFACTORING_KIND = "refactor.pull.up";
    private static final String PULL_UP_REFACTORING_COMMAND = "java.refactor.pull.up";
    private final Set<String> commands = Collections.singleton("java.refactor.pull.up");
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("refactor")) {
            return Collections.emptyList();
        }
        CompilationController info = CompilationController.get((Parser.Result)resultIterator.getParserResult());
        if (info == null || !JavaRefactoringUtils.isRefactorable((FileObject)info.getFileObject())) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        int offset = PullUpRefactoring.getOffset((CompilationInfo)info, params.getRange().getStart());
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(offset);
        if (ts.moveNext() && ts.token().id() != JavaTokenId.WHITESPACE && ts.offset() == offset) {
            ++offset;
        }
        String uri = Utils.toUri(info.getFileObject());
        Trees trees = info.getTrees();
        TreeUtilities treeUtilities = info.getTreeUtilities();
        TreePath path = PullUpRefactoring.findSelectedClassMemberDeclaration(treeUtilities.pathFor(offset), (CompilationInfo)info);
        if (path == null) {
            return Collections.emptyList();
        }
        Element element = trees.getElement(path);
        if (!(element instanceof TypeElement)) {
            element = info.getElementUtilities().enclosingTypeElement(element);
        }
        if (!(element instanceof TypeElement)) {
            return Collections.emptyList();
        }
        Collection supertypes = JavaRefactoringUtils.getSuperTypes((TypeElement)((TypeElement)element), (CompilationInfo)info, (boolean)true);
        if (supertypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QuickPickItem> supertypeItems = new ArrayList<QuickPickItem>(supertypes.size());
        for (TypeElement e : supertypes) {
            QuickPickItem supertypeItem = new QuickPickItem(PullUpRefactoring.createLabel((CompilationInfo)info, e), null, null, false, new CodeActionsProvider.ElementData(e));
            supertypeItems.add(supertypeItem);
        }
        QuickPickItem elementItem = new QuickPickItem(PullUpRefactoring.createLabel((CompilationInfo)info, element));
        elementItem.setUserData(new CodeActionsProvider.ElementData(element));
        return Collections.singletonList(this.createCodeAction(Bundle.DN_PullUp(), PULL_UP_REFACTORING_KIND, null, PULL_UP_REFACTORING_COMMAND, uri, offset, elementItem, supertypeItems));
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        block6: {
            try {
                if (arguments.size() > 3) {
                    String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
                    int offset = (Integer)this.gson.fromJson(this.gson.toJson(arguments.get(1)), Integer.class);
                    QuickPickItem sourceItem = (QuickPickItem)this.gson.fromJson(this.gson.toJson(arguments.get(2)), QuickPickItem.class);
                    List<QuickPickItem> superclasses = Arrays.asList((QuickPickItem[])this.gson.fromJson(this.gson.toJson(arguments.get(3)), QuickPickItem[].class));
                    if (superclasses.size() > 1) {
                        client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectTargetSupertype(), superclasses)).thenAccept(selected -> {
                            QuickPickItem targetItem;
                            List<QuickPickItem> members;
                            if (selected != null && !selected.isEmpty() && !(members = this.getMembers(client, uri, offset, sourceItem, targetItem = (QuickPickItem)selected.get(0))).isEmpty()) {
                                client.showQuickPick(new ShowQuickPickParams(null, Bundle.DN_SelectMembersToPullUp(), true, members)).thenAccept(selectedMembers -> {
                                    if (selectedMembers != null && !selectedMembers.isEmpty()) {
                                        this.pullUp(client, uri, sourceItem, targetItem, (List<QuickPickItem>)selectedMembers);
                                    }
                                });
                            }
                        });
                    } else {
                        QuickPickItem targetItem = superclasses.get(0);
                        List<QuickPickItem> members = this.getMembers(client, uri, offset, sourceItem, targetItem);
                        if (!members.isEmpty()) {
                            client.showQuickPick(new ShowQuickPickParams(null, Bundle.DN_SelectMembersToPullUp(), true, members)).thenAccept(selectedMembers -> {
                                if (selectedMembers != null && !selectedMembers.isEmpty()) {
                                    this.pullUp(client, uri, sourceItem, targetItem, (List<QuickPickItem>)selectedMembers);
                                }
                            });
                        }
                    }
                    break block6;
                }
                throw new IllegalArgumentException(String.format("Illegal number of arguments received for command: %s", command));
            }
            catch (Exception ex) {
                client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    private List<QuickPickItem> getMembers(NbCodeLanguageClient client, String uri, int offset, QuickPickItem source, QuickPickItem target) {
        ArrayList<QuickPickItem> members = new ArrayList<QuickPickItem>();
        try {
            FileObject file = Utils.fromUri(uri);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            js.runUserActionTask(info -> {
                Trees trees = info.getTrees();
                SourcePositions sourcePositions = trees.getSourcePositions();
                ElementUtilities eu = info.getElementUtilities();
                Types types = info.getTypes();
                TypeElement sourceElement = (TypeElement)((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(source.getUserData()), CodeActionsProvider.ElementData.class)).toHandle().resolve((CompilationInfo)info);
                TypeMirror sourceType = sourceElement.asType();
                TypeElement targetElement = (TypeElement)((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(target.getUserData()), CodeActionsProvider.ElementData.class)).toHandle().resolve((CompilationInfo)info);
                block4: for (Element element : sourceElement.getEnclosedElements()) {
                    switch (element.getKind()) {
                        case CONSTRUCTOR: 
                        case STATIC_INIT: 
                        case INSTANCE_INIT: {
                            continue block4;
                        }
                        case METHOD: {
                            if (eu.alreadyDefinedIn((CharSequence)element.getSimpleName(), (ExecutableType)types.asMemberOf((DeclaredType)sourceType, element), targetElement)) break;
                        }
                        default: {
                            TreePath path = trees.getPath(element);
                            long startMember = path != null ? sourcePositions.getStartPosition(path.getCompilationUnit(), path.getLeaf()) : -1L;
                            long endMember = path != null ? sourcePositions.getEndPosition(path.getCompilationUnit(), path.getLeaf()) : -1L;
                            boolean selected = (long)offset > startMember && (long)offset < endMember;
                            members.add(new QuickPickItem(PullUpRefactoring.createLabel((CompilationInfo)info, element), null, null, selected, new CodeActionsProvider.ElementData(element)));
                        }
                    }
                }
            }, true);
        }
        catch (Exception ex) {
            client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
        return members;
    }

    private void pullUp(NbCodeLanguageClient client, String uri, QuickPickItem source, QuickPickItem target, List<QuickPickItem> members) {
        try {
            FileObject file = Utils.fromUri(uri);
            ClasspathInfo info = ClasspathInfo.create((FileObject)file);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            ElementHandle sourceHandle = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(source.getUserData()), CodeActionsProvider.ElementData.class)).toHandle();
            ElementHandle targetHandle = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(target.getUserData()), CodeActionsProvider.ElementData.class)).toHandle();
            ArrayList memberHandles = new ArrayList();
            js.runUserActionTask(ci -> {
                ci.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                boolean isAbstract = targetHandle.resolve((CompilationInfo)ci).getModifiers().contains((Object)Modifier.ABSTRACT);
                for (QuickPickItem member : members) {
                    Element el = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(member.getUserData()), CodeActionsProvider.ElementData.class)).resolve((CompilationInfo)ci);
                    MemberInfo memberInfo = MemberInfo.create((Element)el, (CompilationInfo)ci);
                    memberInfo.setMakeAbstract(Boolean.valueOf(isAbstract && el.getKind() == ElementKind.METHOD));
                    memberHandles.add(memberInfo);
                }
            }, true);
            org.netbeans.modules.refactoring.java.api.PullUpRefactoring refactoring = new org.netbeans.modules.refactoring.java.api.PullUpRefactoring(TreePathHandle.from((ElementHandle)sourceHandle, (ClasspathInfo)info));
            refactoring.setTargetType(targetHandle);
            refactoring.setMembers(memberHandles.toArray(new MemberInfo[memberHandles.size()]));
            refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor((FileObject[])new FileObject[]{file}));
            client.applyEdit(new ApplyWorkspaceEditParams(PullUpRefactoring.perform((AbstractRefactoring)refactoring, "PullUp")));
        }
        catch (Exception ex) {
            client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
    }

    private static TreePath findSelectedClassMemberDeclaration(TreePath path, CompilationInfo javac) {
        List<? extends Tree> typeDecls;
        TreePath currentPath = path;
        TreePath selection = null;
        while (currentPath != null && selection == null) {
            switch (currentPath.getLeaf().getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case NEW_CLASS: 
                case METHOD: {
                    selection = currentPath;
                    break;
                }
                case VARIABLE: {
                    Element elm = javac.getTrees().getElement(currentPath);
                    if (elm == null || !elm.getKind().isField()) break;
                    selection = currentPath;
                }
            }
            if (selection != null && javac.getTreeUtilities().isSynthetic(selection)) {
                selection = null;
            }
            if (selection != null) continue;
            currentPath = currentPath.getParentPath();
        }
        if (selection == null && path != null && !(typeDecls = path.getCompilationUnit().getTypeDecls()).isEmpty() && typeDecls.get(0).getKind().asInterface() == ClassTree.class) {
            selection = TreePath.getPath(path.getCompilationUnit(), typeDecls.get(0));
        }
        return selection;
    }
}

