/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.php.dbgp.annotations.BrkpntAnnotation;
import org.netbeans.modules.php.dbgp.annotations.DisabledBrkpntAnnotation;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Lookup;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener,
AnnotationProvider {
    private Map<Breakpoint, Annotation> myAnnotations = new HashMap<Breakpoint, Annotation>();

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (!(breakpoint instanceof LineBreakpoint)) {
            return;
        }
        this.addAnnotation(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (!(breakpoint instanceof LineBreakpoint)) {
            return;
        }
        this.removeAnnotation(breakpoint);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!"enabled".equals(evt.getPropertyName())) {
            return;
        }
        this.removeAnnotation((Breakpoint)evt.getSource());
        this.addAnnotation((Breakpoint)evt.getSource());
    }

    private void addAnnotation(Breakpoint breakpoint) {
        LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
        Line line = lineBreakpoint.getLine();
        BrkpntAnnotation annotation = breakpoint.isEnabled() ? new BrkpntAnnotation((Annotatable)line, lineBreakpoint) : new DisabledBrkpntAnnotation((Annotatable)line, lineBreakpoint);
        this.myAnnotations.put(breakpoint, (Annotation)annotation);
        breakpoint.addPropertyChangeListener("enabled", (PropertyChangeListener)this);
    }

    private void removeAnnotation(Breakpoint breakpoint) {
        Annotation annotation = this.myAnnotations.remove(breakpoint);
        if (annotation == null) {
            return;
        }
        annotation.detach();
        breakpoint.removePropertyChangeListener("enabled", (PropertyChangeListener)this);
    }

    public void annotate(Line.Set set, Lookup context) {
        DebuggerManager.getDebuggerManager().getBreakpoints();
    }
}

