/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.spec.html5;

import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.saxtree.DocumentFragment;
import nu.validator.saxtree.TreeBuilder;
import nu.validator.spec.Spec;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.EmptyAttributes;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class Html5SpecBuilder
implements ContentHandler {
    private static final String NS = "http://www.w3.org/1999/xhtml";
    private static final String SPEC_LINK_URI = System.getProperty("nu.validator.spec.html5-link", "https://html.spec.whatwg.org/multipage/");
    private static final Pattern THE = Pattern.compile("^.*The.*$", 32);
    private static final Pattern ELEMENT = Pattern.compile("^.*The.*element\\s*$", 32);
    private static final Pattern CATEGORIES = Pattern.compile("^\\s*Categories\\s*");
    private static final Pattern CONTEXT = Pattern.compile("^\\s*Contexts\\s+in\\s+which\\s+th(is|ese)\\s+element[s]?\\s+can\\s+be\\s+used:?\\s*");
    private static final Pattern CONTENT_MODEL = Pattern.compile("^\\s*Content\\s+model:?\\s*$");
    private static final Pattern TAG_OMISSION = Pattern.compile("^\\s*Tag omission\\s+in\\s+text/html:?\\s*$");
    private static final Pattern ATTRIBUTES = Pattern.compile("^\\s*Content\\s+attributes:?\\s*$");
    private Locator locator;
    private State state = State.AWAITING_HEADING;
    private int captureDepth = 0;
    private String currentId;
    private StringBuilder nameText = new StringBuilder();
    private StringBuilder referenceText = new StringBuilder();
    private TreeBuilder fragmentBuilder;
    private Name currentName;
    private Map<Name, String> urisByElement = new HashMap<Name, String>();
    private Map<Name, DocumentFragment> categoriesByElement = new HashMap<Name, DocumentFragment>();
    private Map<Name, DocumentFragment> contextsByElement = new HashMap<Name, DocumentFragment>();
    private Map<Name, DocumentFragment> contentModelsByElement = new HashMap<Name, DocumentFragment>();
    private Map<Name, DocumentFragment> attributesByElement = new HashMap<Name, DocumentFragment>();
    private boolean ignoreTextNodes = false;

    private static Spec parseSpec(InputSource in) throws IOException, SAXException {
        HtmlParser parser = new HtmlParser(XmlViolationPolicy.ALTER_INFOSET);
        Html5SpecBuilder handler = new Html5SpecBuilder();
        parser.setContentHandler((ContentHandler)handler);
        parser.parse(in);
        return handler.buildSpec();
    }

    public static void main(String[] args) throws IOException, SAXException {
        if (args == null || args.length < 1) {
            System.err.printf("Usage: java -cp ~/vnu.jar nu.validator.spec.html5.Html5SpecBuilder URL_OF_HTML_SPEC\n", new Object[0]);
            System.exit(1);
        }
        String url = args[0];
        System.err.println(url);
        InputSource is = "-".equals(url) ? new InputSource(System.in) : new InputSource(url);
        try {
            Html5SpecBuilder.parseSpec(is);
        }
        catch (SAXParseException e) {
            System.err.printf("Line: %d Col: %d\n", e.getLineNumber(), e.getColumnNumber());
            e.printStackTrace();
        }
    }

    public static Spec parseSpec(InputStream html5SpecAsStream) throws IOException, SAXException {
        return Html5SpecBuilder.parseSpec(new InputSource(html5SpecAsStream));
    }

    private Spec buildSpec() {
        return new Spec(this.urisByElement, this.contextsByElement, this.contentModelsByElement, this.attributesByElement);
    }

    private Html5SpecBuilder() {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.state) {
            case AWAITING_HEADING: {
                break;
            }
            case IN_H4: {
                Matcher m;
                this.referenceText.append(ch, start, length);
                if (this.nameText.length() == 0 || !(m = THE.matcher(this.referenceText)).matches()) break;
                String ln = this.nameText.toString().intern();
                if ("" == ln) {
                    throw new SAXParseException("Malformed spec: no element " + this.currentName, this.locator);
                }
                this.currentName = new Name(NS, ln);
                if (this.urisByElement.containsKey(this.currentName)) break;
                if (this.currentId == null) {
                    this.state = State.AWAITING_HEADING;
                }
                this.urisByElement.put(this.currentName, SPEC_LINK_URI + "#" + this.currentId);
                break;
            }
            case IN_CODE_IN_H4: {
                this.nameText.append(ch, start, length);
                break;
            }
            case AWAITING_ELEMENT_DL: {
                break;
            }
            case IN_ELEMENT_DL_START: {
                break;
            }
            case IN_CATEGORIES_DT: 
            case IN_CONTEXT_DT: 
            case IN_CONTENT_MODEL_DT: 
            case IN_TAG_OMISSION_DT: 
            case IN_ATTRIBUTES_DT: {
                this.referenceText.append(ch, start, length);
                break;
            }
            case CAPTURING_CATEGORIES_DDS: 
            case CAPTURING_CONTEXT_DDS: 
            case CAPTURING_CONTENT_MODEL_DDS: 
            case CAPTURING_TAG_OMISSION_DDS: 
            case CAPTURING_ATTRIBUTES_DDS: {
                if (this.ignoreTextNodes) {
                    this.ignoreTextNodes = false;
                    break;
                }
                this.fragmentBuilder.characters(ch, start, length);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        switch (this.state) {
            case AWAITING_HEADING: 
            case AWAITING_ELEMENT_DL: {
                break;
            }
            case IN_H4: 
            case IN_CODE_IN_H4: 
            case IN_ELEMENT_DL_START: 
            case IN_CATEGORIES_DT: 
            case IN_CONTEXT_DT: 
            case IN_CONTENT_MODEL_DT: 
            case IN_TAG_OMISSION_DT: 
            case IN_ATTRIBUTES_DT: 
            case CAPTURING_CATEGORIES_DDS: 
            case CAPTURING_CONTEXT_DDS: 
            case CAPTURING_CONTENT_MODEL_DDS: 
            case CAPTURING_TAG_OMISSION_DDS: 
            case CAPTURING_ATTRIBUTES_DDS: {
                throw new SAXException("Malformed spec: Wrong state for document end.");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("p" == localName && NS == uri) {
            return;
        }
        switch (this.state) {
            case AWAITING_HEADING: {
                break;
            }
            case IN_H4: {
                if ("h4" != localName || NS != uri) break;
                Matcher m = ELEMENT.matcher(this.referenceText);
                if (m.matches()) {
                    String ln = this.nameText.toString().intern();
                    if ("" == ln) {
                        throw new SAXParseException("Malformed spec: no element" + this.currentName, this.locator);
                    }
                    if (this.currentId == null) {
                        this.state = State.AWAITING_HEADING;
                    }
                    this.state = State.AWAITING_ELEMENT_DL;
                    break;
                }
                this.currentId = null;
                this.nameText.setLength(0);
                this.state = State.AWAITING_HEADING;
                break;
            }
            case IN_CODE_IN_H4: {
                if ("code" != localName || NS != uri) break;
                this.state = State.IN_H4;
                break;
            }
            case AWAITING_ELEMENT_DL: {
                break;
            }
            case IN_ELEMENT_DL_START: {
                throw new SAXParseException("Malformed spec: no children in element dl.", this.locator);
            }
            case IN_CATEGORIES_DT: {
                if ("a" != localName || NS != uri) break;
                Matcher m = CATEGORIES.matcher(this.referenceText);
                if (m.matches()) {
                    this.state = State.CAPTURING_CATEGORIES_DDS;
                    this.captureDepth = 0;
                    this.fragmentBuilder = new TreeBuilder(true, true);
                    break;
                }
                throw new SAXParseException("Malformed spec: Expected dt to be categories dt but it was not.", this.locator);
            }
            case IN_CONTEXT_DT: {
                if ("a" != localName || NS != uri) break;
                Matcher m = CONTEXT.matcher(this.referenceText);
                if (m.matches()) {
                    this.state = State.CAPTURING_CONTEXT_DDS;
                    this.captureDepth = 0;
                    this.fragmentBuilder = new TreeBuilder(true, true);
                    break;
                }
                System.err.printf("Line: %d Col: %d\n", this.locator.getLineNumber(), this.locator.getColumnNumber());
                throw new SAXParseException("Malformed spec at element " + this.currentName.getLocalName() + " (" + this.currentId + "): Expected dt to be context dt but it was not.", this.locator);
            }
            case IN_CONTENT_MODEL_DT: {
                if ("a" != localName || NS != uri) break;
                Matcher m = CONTENT_MODEL.matcher(this.referenceText);
                if (m.matches()) {
                    this.state = State.CAPTURING_CONTENT_MODEL_DDS;
                    this.captureDepth = 0;
                    this.fragmentBuilder = new TreeBuilder(true, true);
                    break;
                }
                throw new SAXParseException("Malformed spec: Expected dt to be content-model dt but it was not.", this.locator);
            }
            case IN_TAG_OMISSION_DT: {
                if ("a" != localName || NS != uri) break;
                Matcher m = TAG_OMISSION.matcher(this.referenceText);
                if (m.matches()) {
                    this.state = State.CAPTURING_TAG_OMISSION_DDS;
                    this.captureDepth = 0;
                    this.fragmentBuilder = new TreeBuilder(true, true);
                    break;
                }
                throw new SAXParseException("Malformed spec: Expected dt to be tag-omission dt but it was not.", this.locator);
            }
            case IN_ATTRIBUTES_DT: {
                if ("a" != localName || NS != uri) break;
                Matcher m = ATTRIBUTES.matcher(this.referenceText);
                if (m.matches()) {
                    this.state = State.CAPTURING_ATTRIBUTES_DDS;
                    this.captureDepth = 0;
                    this.fragmentBuilder = new TreeBuilder(true, true);
                    break;
                }
                throw new SAXParseException("Malformed spec: Expected dt to be content-attributes dt but it was not.", this.locator);
            }
            case CAPTURING_CATEGORIES_DDS: 
            case CAPTURING_CONTEXT_DDS: 
            case CAPTURING_CONTENT_MODEL_DDS: 
            case CAPTURING_TAG_OMISSION_DDS: 
            case CAPTURING_ATTRIBUTES_DDS: {
                if ("dt" == localName) break;
                if (this.captureDepth == 0) {
                    throw new SAXParseException("Malformed spec: Did not see following dt when capturing dds.", this.locator);
                }
                --this.captureDepth;
                this.fragmentBuilder.endElement(uri, localName, qName);
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("p" == localName && NS == uri) {
            return;
        }
        switch (this.state) {
            case AWAITING_HEADING: {
                if ("h4" != localName || NS != uri) break;
                this.referenceText.setLength(0);
                this.currentId = atts.getValue("", "id");
                this.currentName = null;
                this.state = State.IN_H4;
                break;
            }
            case IN_H4: {
                if ("code" != localName || NS != uri) break;
                this.nameText.setLength(0);
                this.state = State.IN_CODE_IN_H4;
                break;
            }
            case IN_CODE_IN_H4: {
                break;
            }
            case AWAITING_ELEMENT_DL: {
                if ("dl" != localName || NS != uri || !"element".equals(atts.getValue("", "class"))) break;
                this.state = State.IN_ELEMENT_DL_START;
                break;
            }
            case IN_ELEMENT_DL_START: {
                if ("dt" == localName && NS == uri) {
                    this.referenceText.setLength(0);
                    this.state = State.IN_CATEGORIES_DT;
                    break;
                }
                throw new SAXParseException("Malformed spec: Expected dt in dl.", this.locator);
            }
            case IN_CATEGORIES_DT: {
                if ("a" == localName && NS == uri) {
                    this.state = State.IN_CATEGORIES_DT;
                    break;
                }
            }
            case IN_CONTEXT_DT: {
                if ("a" == localName && NS == uri) {
                    this.state = State.IN_CONTEXT_DT;
                    break;
                }
            }
            case IN_CONTENT_MODEL_DT: {
                if ("a" == localName && NS == uri) {
                    this.state = State.IN_CONTENT_MODEL_DT;
                    break;
                }
            }
            case IN_TAG_OMISSION_DT: {
                if ("a" == localName && NS == uri) {
                    this.state = State.IN_TAG_OMISSION_DT;
                    break;
                }
            }
            case IN_ATTRIBUTES_DT: {
                if ("a" == localName && NS == uri) {
                    this.state = State.IN_ATTRIBUTES_DT;
                    break;
                }
                throw new SAXParseException("Malformed spec: Not expecting children in dts.", this.locator);
            }
            case CAPTURING_CATEGORIES_DDS: 
            case CAPTURING_CONTEXT_DDS: 
            case CAPTURING_CONTENT_MODEL_DDS: 
            case CAPTURING_TAG_OMISSION_DDS: 
            case CAPTURING_ATTRIBUTES_DDS: {
                if ("dt" == localName && NS == uri && this.captureDepth == 0) {
                    this.ignoreTextNodes = true;
                    DocumentFragment fragment = (DocumentFragment)this.fragmentBuilder.getRoot();
                    this.fragmentBuilder = null;
                    this.referenceText.setLength(0);
                    if (this.state == State.CAPTURING_CATEGORIES_DDS) {
                        this.categoriesByElement.put(this.currentName, fragment);
                        this.state = State.IN_CONTEXT_DT;
                        break;
                    }
                    if (this.state == State.CAPTURING_CONTEXT_DDS) {
                        this.contextsByElement.put(this.currentName, fragment);
                        this.state = State.IN_CONTENT_MODEL_DT;
                        break;
                    }
                    if (this.state == State.CAPTURING_CONTENT_MODEL_DDS) {
                        this.contentModelsByElement.put(this.currentName, fragment);
                        this.state = State.IN_TAG_OMISSION_DT;
                        break;
                    }
                    if (this.state == State.CAPTURING_TAG_OMISSION_DDS) {
                        this.state = State.IN_ATTRIBUTES_DT;
                        break;
                    }
                    this.attributesByElement.put(this.currentName, fragment);
                    this.state = State.AWAITING_HEADING;
                    break;
                }
                ++this.captureDepth;
                String href = null;
                if ("a" == localName && NS == uri && (href = atts.getValue("", "href")) != null) {
                    if (href.startsWith("#")) {
                        href = SPEC_LINK_URI + href;
                    }
                    AttributesImpl attributesImpl = new AttributesImpl();
                    attributesImpl.addAttribute("href", href);
                    this.fragmentBuilder.startElement(uri, localName, qName, (Attributes)attributesImpl);
                    break;
                }
                this.fragmentBuilder.startElement(uri, localName, qName, (Attributes)EmptyAttributes.EMPTY_ATTRIBUTES);
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private static enum State {
        AWAITING_HEADING,
        IN_H4,
        IN_CODE_IN_H4,
        AWAITING_ELEMENT_DL,
        IN_ELEMENT_DL_START,
        IN_CATEGORIES_DT,
        CAPTURING_CATEGORIES_DDS,
        IN_CONTEXT_DT,
        CAPTURING_CONTEXT_DDS,
        IN_CONTENT_MODEL_DT,
        CAPTURING_CONTENT_MODEL_DDS,
        IN_TAG_OMISSION_DT,
        CAPTURING_TAG_OMISSION_DDS,
        IN_ATTRIBUTES_DT,
        CAPTURING_ATTRIBUTES_DDS;

    }
}

