/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.el.ELUtils;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.mgbean.ManagedBeanInfo;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.TypedCollections;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.bean.ManagedBean;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManagedBeanConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String MANAGED_BEAN = "managed-bean";
    private static final String DESCRIPTION = "description";
    private static final String MGBEAN_NAME = "managed-bean-name";
    private static final String MGBEAN_CLASS = "managed-bean-class";
    private static final String MGBEAN_SCOPE = "managed-bean-scope";
    private static final String MG_PROPERTY = "managed-property";
    private static final String MG_PROPERTY_NAME = "property-name";
    private static final String MG_PROPERTY_TYPE = "property-class";
    private static final String NULL_VALUE = "null-value";
    private static final String VALUE = "value";
    private static final String KEY = "key";
    private static final String MAP_KEY_CLASS = "key-class";
    private static final String VALUE_CLASS = "value-class";
    private static final String MAP_ENTRY = "map-entry";
    private static final String MAP_ENTRIES = "map-entries";
    private static final String LIST_ENTRIES = "list-entries";
    private static final String EAGER_ATTRIBUTE = "eager";
    private static final String DEFAULT_SCOPE = "request";

    @Override
    public void process(ServletContext sc, DocumentInfo[] documentInfos) throws Exception {
        this.processAnnotations(ManagedBean.class);
        BeanManager beanManager = ApplicationAssociate.getInstance(sc).getBeanManager();
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing managed-bean elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList managedBeans = document.getDocumentElement().getElementsByTagNameNS(namespace, MANAGED_BEAN);
            if (managedBeans == null || managedBeans.getLength() <= 0) continue;
            int size = managedBeans.getLength();
            for (int m = 0; m < size; ++m) {
                this.addManagedBean(beanManager, managedBeans.item(m));
            }
        }
        beanManager.preProcessesBeans();
        this.invokeNext(sc, documentInfos);
    }

    private void addManagedBean(BeanManager beanManager, Node managedBean) {
        NodeList children = managedBean.getChildNodes();
        String beanName = null;
        String beanClass = null;
        String beanScope = null;
        ManagedBeanInfo.ListEntry listEntry = null;
        ManagedBeanInfo.MapEntry mapEntry = null;
        ArrayList<Node> managedProperties = null;
        ArrayList<Node> descriptions = null;
        int size = children.getLength();
        block18: for (int i = 0; i < size; ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            switch (n.getLocalName()) {
                case "managed-bean-name": {
                    beanName = this.getNodeText(n);
                    continue block18;
                }
                case "managed-bean-class": {
                    beanClass = this.getNodeText(n);
                    continue block18;
                }
                case "managed-bean-scope": {
                    beanScope = this.getNodeText(n);
                    if (beanScope != null) continue block18;
                    beanScope = DEFAULT_SCOPE;
                    continue block18;
                }
                case "list-entries": {
                    listEntry = this.buildListEntry(n);
                    continue block18;
                }
                case "map-entries": {
                    mapEntry = this.buildMapEntry(n);
                    continue block18;
                }
                case "managed-property": {
                    if (managedProperties == null) {
                        managedProperties = new ArrayList<Node>(size);
                    }
                    managedProperties.add(n);
                    continue block18;
                }
                case "description": {
                    if (descriptions == null) {
                        descriptions = new ArrayList<Node>(4);
                    }
                    descriptions.add(n);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Begin processing managed bean ''{0}''", beanName);
        }
        ArrayList<ManagedBeanInfo.ManagedProperty> properties = null;
        if (managedProperties != null && !managedProperties.isEmpty()) {
            properties = new ArrayList<ManagedBeanInfo.ManagedProperty>(managedProperties.size());
            for (Node managedProperty : managedProperties) {
                properties.add(this.buildManagedProperty(managedProperty));
            }
        }
        beanManager.register(new ManagedBeanInfo(beanName, beanClass, beanScope, this.isEager(managedBean, beanName, beanScope), mapEntry, listEntry, properties, this.getTextMap(descriptions)));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Completed processing bean ''{0}''", beanName);
        }
    }

    private ManagedBeanInfo.ListEntry buildListEntry(Node listEntry) {
        if (listEntry != null) {
            String valueClass = "java.lang.String";
            List<String> values = null;
            NodeList children = listEntry.getChildNodes();
            int size = children.getLength();
            block10: for (int i = 0; i < size; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                switch (child.getLocalName()) {
                    case "value-class": {
                        valueClass = this.getNodeText(child);
                        continue block10;
                    }
                    case "value": {
                        if (values == null) {
                            values = new ArrayList<String>(size);
                        }
                        values.add(this.getNodeText(child));
                        continue block10;
                    }
                    case "null-value": {
                        if (values == null) {
                            values = new ArrayList<String>(size);
                        }
                        values.add("null_value");
                    }
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Created ListEntry valueClass={1}, values={3}", valueClass, values != null && !values.isEmpty() ? values.toString() : "none"));
            }
            return new ManagedBeanInfo.ListEntry(valueClass, values == null ? TypedCollections.dynamicallyCastList(Collections.emptyList(), String.class) : values);
        }
        return null;
    }

    private ManagedBeanInfo.MapEntry buildMapEntry(Node mapEntry) {
        if (mapEntry != null) {
            String valueClass = "java.lang.String";
            String keyClass = "java.lang.String";
            LinkedHashMap<String, String> entries = null;
            NodeList children = mapEntry.getChildNodes();
            int size = children.getLength();
            block20: for (int i = 0; i < size; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                switch (child.getLocalName()) {
                    case "value-class": {
                        valueClass = this.getNodeText(child);
                        continue block20;
                    }
                    case "key-class": {
                        keyClass = this.getNodeText(child);
                        continue block20;
                    }
                    case "map-entry": {
                        if (entries == null) {
                            entries = new LinkedHashMap<String, String>(8, 1.0f);
                        }
                        NodeList c = child.getChildNodes();
                        String key = null;
                        String value = null;
                        int jsize = c.getLength();
                        block21: for (int j = 0; j < jsize; ++j) {
                            Node node = c.item(j);
                            if (node.getNodeType() != 1) continue;
                            switch (node.getLocalName()) {
                                case "key": {
                                    key = this.getNodeText(node);
                                    continue block21;
                                }
                                case "value": {
                                    value = this.getNodeText(node);
                                    continue block21;
                                }
                                case "null-value": {
                                    value = "null_value";
                                }
                            }
                        }
                        entries.put(key, value);
                    }
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Created MapEntry keyClass={0}, valueClass={1}, entries={3}", keyClass, valueClass, entries != null ? ((Object)entries).toString() : "none"));
            }
            return new ManagedBeanInfo.MapEntry(keyClass, valueClass, entries);
        }
        return null;
    }

    private ManagedBeanInfo.ManagedProperty buildManagedProperty(Node managedProperty) {
        if (managedProperty != null) {
            String propertyName = null;
            String propertyClass = null;
            String value = null;
            ManagedBeanInfo.MapEntry mapEntry = null;
            ManagedBeanInfo.ListEntry listEntry = null;
            NodeList children = managedProperty.getChildNodes();
            int size = children.getLength();
            block16: for (int i = 0; i < size; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                switch (child.getLocalName()) {
                    case "property-name": {
                        propertyName = this.getNodeText(child);
                        continue block16;
                    }
                    case "property-class": {
                        propertyClass = this.getNodeText(child);
                        continue block16;
                    }
                    case "value": {
                        value = this.getNodeText(child);
                        continue block16;
                    }
                    case "null-value": {
                        value = "null_value";
                        continue block16;
                    }
                    case "list-entries": {
                        listEntry = this.buildListEntry(child);
                        continue block16;
                    }
                    case "map-entries": {
                        mapEntry = this.buildMapEntry(child);
                    }
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Adding ManagedProperty propertyName={0}, propertyClass={1}, propertyValue={2}, hasMapEntry={3}, hasListEntry={4}", propertyName, propertyClass != null ? propertyClass : "inferred", value, mapEntry != null, listEntry != null));
            }
            return new ManagedBeanInfo.ManagedProperty(propertyName, propertyClass, value, mapEntry, listEntry);
        }
        return null;
    }

    private boolean isEager(Node managedBean, String beanName, String scope) {
        NamedNodeMap attributes = managedBean.getAttributes();
        Node eagerNode = attributes.getNamedItem(EAGER_ATTRIBUTE);
        boolean eager = false;
        if (eagerNode != null && (eager = Boolean.valueOf(this.getNodeText(eagerNode)).booleanValue()) && (scope == null || !ELUtils.Scope.APPLICATION.toString().equals(scope))) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.configuration.illegal.eager.bean", new Object[]{beanName, scope});
            }
            eager = false;
        }
        return eager;
    }
}

