/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.ui.wizards.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class NewFileNamespacePanelVisual
extends JPanel {
    private static final String NAMESPACE_SEPARATOR = "\\";
    private static final Pattern NAMESPACE_PART_PATTERN = Pattern.compile("^[a-z][a-z0-9_]*$", 2);
    private final NamespaceComboBoxModel comboBoxModel = new NamespaceComboBoxModel();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JComboBox<String> namespaceComboBox;
    private JLabel namespaceLabel;

    public NewFileNamespacePanelVisual() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.init();
    }

    private void init() {
        assert (EventQueue.isDispatchThread());
        this.namespaceComboBox.setModel(this.comboBoxModel);
        this.namespaceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewFileNamespacePanelVisual.this.fireChange();
            }
        });
        this.namespaceComboBox.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                NewFileNamespacePanelVisual.this.fireChange();
            }
        });
    }

    public String getSelectedNamespace() {
        return (String)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                assert (EventQueue.isDispatchThread());
                if (!NewFileNamespacePanelVisual.this.namespaceComboBox.isEnabled()) {
                    return null;
                }
                return (String)NewFileNamespacePanelVisual.this.namespaceComboBox.getEditor().getItem();
            }
        });
    }

    public void setSelectedNamespace(String namespace) {
        this.comboBoxModel.setSelectedItem(namespace);
    }

    public void setNamespaces(List<String> namespaces) {
        assert (EventQueue.isDispatchThread());
        this.namespaceComboBox.setEnabled(true);
        this.comboBoxModel.setNamespaces(namespaces);
    }

    public void setPleaseWaitState() {
        assert (EventQueue.isDispatchThread());
        this.namespaceComboBox.setEnabled(false);
        this.comboBoxModel.setNamespaces(Collections.singletonList(Bundle.NewFileNamespacePanelVisual_message_pleaseWait()));
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public static String validateNamespace(String namespace) {
        assert (namespace != null);
        if (namespace.isEmpty()) {
            return null;
        }
        if (namespace.startsWith(NAMESPACE_SEPARATOR) || namespace.endsWith(NAMESPACE_SEPARATOR)) {
            return Bundle.NewFileNamespacePanelVisual_error_namespace_invalid();
        }
        for (String part : StringUtils.explode((String)namespace, (String)NAMESPACE_SEPARATOR)) {
            if (NAMESPACE_PART_PATTERN.matcher(part).matches()) continue;
            return Bundle.NewFileNamespacePanelVisual_error_namespace_invalid();
        }
        return null;
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.namespaceLabel = new JLabel();
        this.namespaceComboBox = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.namespaceLabel, (String)NbBundle.getMessage(NewFileNamespacePanelVisual.class, (String)"NewFileNamespacePanelVisual.namespaceLabel.text"));
        this.namespaceComboBox.setEditable(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.namespaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.namespaceComboBox, 0, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.namespaceLabel).addComponent(this.namespaceComboBox, -2, -1, -2)));
    }

    private static final class NamespaceComboBoxModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private static final long serialVersionUID = -5783235465654654L;
        private final List<String> namespaces = new CopyOnWriteArrayList<String>();
        private volatile String selectedNamespace = null;

        private NamespaceComboBoxModel() {
        }

        @Override
        public int getSize() {
            return this.namespaces.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.namespaces.get(index);
        }

        @Override
        public void setSelectedItem(Object namespace) {
            this.selectedNamespace = (String)namespace;
            this.fireContentsChanged();
        }

        @Override
        public String getSelectedItem() {
            return this.selectedNamespace;
        }

        public void setNamespaces(List<String> namespaces) {
            this.clearNamespaces();
            this.namespaces.addAll(namespaces);
            Iterator<String> iterator = namespaces.iterator();
            if (iterator.hasNext()) {
                String namespace;
                this.selectedNamespace = namespace = iterator.next();
            }
            this.fireContentsChanged();
        }

        private void clearNamespaces() {
            this.namespaces.clear();
            this.selectedNamespace = null;
            this.fireContentsChanged();
        }

        private void fireContentsChanged() {
            this.fireContentsChanged(this, -1, -1);
        }
    }
}

