/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.GestureSubmitter;
import org.netbeans.api.debugger.IdentityHashSet;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.DelegatingDebuggerEngineProvider;
import org.netbeans.spi.debugger.DelegatingSessionProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Task;

public final class DebuggerManager
implements ContextProvider {
    public static final String PROP_BREAKPOINTS_INIT = "breakpointsInit";
    public static final String PROP_BREAKPOINTS = "breakpoints";
    public static final String PROP_CURRENT_ENGINE = "currentEngine";
    public static final String PROP_CURRENT_SESSION = "currentSession";
    public static final String PROP_SESSIONS = "sessions";
    public static final String PROP_DEBUGGER_ENGINES = "debuggerEngines";
    public static final String PROP_WATCHES = "watches";
    public static final String PROP_WATCHES_INIT = "watchesInit";
    private static DebuggerManager debuggerManager;
    private Session currentSession;
    private DebuggerEngine currentEngine;
    private final List<Session> sessions = new ArrayList<Session>();
    private final Set engines = new HashSet();
    private final Vector<Breakpoint> breakpoints = new Vector();
    private boolean breakpointsInitializing = false;
    private boolean breakpointsInitialized = false;
    private final Vector<Watch> watches = new Vector();
    private boolean watchesInitialized = false;
    private ThreadLocal<Boolean> watchesInitializing = new ThreadLocal();
    private SessionListener sessionListener = new SessionListener();
    private Vector<DebuggerManagerListener> listeners = new Vector();
    private final Map<String, Vector<DebuggerManagerListener>> listenersMap = new HashMap<String, Vector<DebuggerManagerListener>>();
    private ActionsManager actionsManager = null;
    private Lookup lookup = new Lookup.MetaInf(null);
    private List<Breakpoint> createdBreakpoints;
    private final Map<ClassLoader, Set<Breakpoint>> breakpointsByClassLoaders = new HashMap<ClassLoader, Set<Breakpoint>>();
    private Set<LazyDebuggerManagerListener> loadedListeners;
    private List<? extends LazyDebuggerManagerListener> listenersLookupList;
    private final Object loadedListenersLock = new Object();

    public static synchronized DebuggerManager getDebuggerManager() {
        if (debuggerManager == null) {
            debuggerManager = new DebuggerManager();
        }
        return debuggerManager;
    }

    private DebuggerManager() {
    }

    public synchronized ActionsManager getActionsManager() {
        if (this.actionsManager == null) {
            this.actionsManager = new ActionsManager(this.lookup);
        }
        return this.actionsManager;
    }

    @Override
    public <T> List<? extends T> lookup(String folder, Class<T> service) {
        return this.lookup.lookup(folder, service);
    }

    @Override
    public <T> T lookupFirst(String folder, Class<T> service) {
        return this.lookup.lookupFirst(folder, service);
    }

    public static ContextProvider join(ContextProvider cp1, ContextProvider cp2) {
        return new Lookup.Compound(cp1, cp2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerEngine[] startDebugging(DebuggerInfo info) {
        int i;
        ArrayList<Object> sessionProviders = new ArrayList<Object>();
        ArrayList<DebuggerEngine> engines = new ArrayList<DebuggerEngine>();
        Lookup l = info.getLookup();
        Lookup l2 = info.getLookup();
        Lookup lookup = l;
        synchronized (lookup) {
            sessionProviders.addAll(l.lookup(null, SessionProvider.class));
            sessionProviders.addAll(l.lookup(null, DelegatingSessionProvider.class));
        }
        Session sessionToStart = null;
        int k = sessionProviders.size();
        for (i = 0; i < k; ++i) {
            Session s = null;
            if (sessionProviders.get(i) instanceof DelegatingSessionProvider) {
                s = ((DelegatingSessionProvider)sessionProviders.get(i)).getSession(info);
                l = new Lookup.Compound(l, s.privateLookup);
            } else {
                SessionProvider sp = (SessionProvider)sessionProviders.get(i);
                if (sp.getSessionName() == null) {
                    throw new NullPointerException("<null> session name provided by: " + sp);
                }
                if (sp.getTypeID() == null) {
                    throw new NullPointerException("<null> type ID provided by: " + sp);
                }
                if (sp.getServices() == null) {
                    throw new NullPointerException("<null> services provided by: " + sp);
                }
                sessionToStart = s = new Session(sp.getSessionName(), sp.getLocationName(), sp.getTypeID(), sp.getServices(), l);
                l = s.getLookup();
                l2 = s.getLookup();
                this.addSession(s);
            }
            ArrayList<Object> engineProviders = new ArrayList<Object>();
            Lookup lookup2 = l2;
            synchronized (lookup2) {
                engineProviders.addAll(l2.lookup(null, DebuggerEngineProvider.class));
                engineProviders.addAll(l2.lookup(null, DelegatingDebuggerEngineProvider.class));
            }
            int jj = engineProviders.size();
            for (int j = 0; j < jj; ++j) {
                DebuggerEngine engine = null;
                String[] languages = null;
                if (engineProviders.get(j) instanceof DebuggerEngineProvider) {
                    DebuggerEngineProvider ep = (DebuggerEngineProvider)engineProviders.get(j);
                    Object[] services = ep.getServices();
                    engine = new DebuggerEngine(ep.getEngineTypeID(), s, services, l);
                    languages = ep.getLanguages();
                    ep.setDestructor(engine.new DebuggerEngine.Destructor());
                    engines.add(engine);
                } else {
                    DelegatingDebuggerEngineProvider dep = (DelegatingDebuggerEngineProvider)engineProviders.get(j);
                    languages = dep.getLanguages();
                    engine = dep.getEngine();
                    dep.setDestructor(engine.new DebuggerEngine.Destructor());
                }
                int ww = languages.length;
                for (int w = 0; w < ww; ++w) {
                    s.addLanguage(languages[w], engine);
                }
            }
        }
        if (sessionToStart != null) {
            GestureSubmitter.logDebugStart(sessionToStart, engines);
            if (this.currentSession == null) {
                this.setCurrentSession(sessionToStart);
            }
        }
        k = engines.size();
        for (i = 0; i < k && !Thread.interrupted(); ++i) {
            Task task = ((DebuggerEngine)engines.get(i)).getActionsManager().postAction(ActionsManager.ACTION_START);
            if (task instanceof Cancellable) {
                try {
                    task.waitFinished(0L);
                }
                catch (InterruptedException iex) {
                    if (((Cancellable)task).cancel()) break;
                    task.waitFinished();
                }
                continue;
            }
            task.waitFinished();
        }
        if (i < k) {
            int n = i + 1;
            for (i = 0; i < k; ++i) {
                ActionsManager am = ((DebuggerEngine)engines.get(i)).getActionsManager();
                if (i < n - 1) {
                    am.postAction(ActionsManager.ACTION_KILL);
                }
                am.destroy();
            }
            if (sessionToStart != null) {
                sessionToStart.kill();
            }
            return new DebuggerEngine[0];
        }
        DebuggerEngine[] des = new DebuggerEngine[engines.size()];
        return engines.toArray(des);
    }

    public void finishAllSessions() {
        Session[] ds = this.getSessions();
        if (ds.length == 0) {
            return;
        }
        int k = ds.length;
        for (int i = 0; i < k; ++i) {
            ds[i].getCurrentEngine().getActionsManager().doAction(ActionsManager.ACTION_KILL);
        }
    }

    public Session getCurrentSession() {
        return this.currentSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSession(Session session) {
        DebuggerEngine newEngine;
        DebuggerEngine oldEngine;
        Session newSession;
        Session oldSession;
        List<Session> list = this.sessions;
        synchronized (list) {
            if (session != null) {
                int i;
                int k = this.sessions.size();
                for (i = 0; i < k && session != this.sessions.get(i); ++i) {
                }
                if (i == k) {
                    return;
                }
            }
            if (session == (oldSession = this.getCurrentSession())) {
                return;
            }
            this.currentSession = newSession = session;
            oldEngine = this.currentEngine;
            newEngine = null;
            if (this.getCurrentSession() != null) {
                newEngine = this.getCurrentSession().getCurrentEngine();
            }
            this.currentEngine = newEngine;
        }
        if (oldEngine != newEngine) {
            this.firePropertyChange(PROP_CURRENT_ENGINE, oldEngine, newEngine);
        }
        this.firePropertyChange(PROP_CURRENT_SESSION, oldSession, newSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions() {
        List<Session> list = this.sessions;
        synchronized (list) {
            return this.sessions.toArray(new Session[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerEngine[] getDebuggerEngines() {
        Set set = this.engines;
        synchronized (set) {
            return this.engines.toArray(new DebuggerEngine[this.engines.size()]);
        }
    }

    public DebuggerEngine getCurrentEngine() {
        return this.currentEngine;
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        if (this.initBreakpoints(breakpoint) && this.registerBreakpoint(breakpoint)) {
            this.breakpoints.addElement(breakpoint);
            this.fireBreakpointCreated(breakpoint, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerBreakpoint(Breakpoint breakpoint) {
        Class<?> c = breakpoint.getClass();
        ClassLoader cl = c.getClassLoader();
        Map<ClassLoader, Set<Breakpoint>> map = this.breakpointsByClassLoaders;
        synchronized (map) {
            Set<Breakpoint> lb = this.breakpointsByClassLoaders.get(cl);
            if (lb == null) {
                lb = new IdentityHashSet<Breakpoint>();
                this.breakpointsByClassLoaders.put(cl, lb);
            }
            return lb.add(breakpoint);
        }
    }

    public void removeBreakpoint(Breakpoint breakpoint) {
        this.removeBreakpoint(breakpoint, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBreakpoint(Breakpoint breakpoint, boolean ignoreInitBreakpointsListeners) {
        if (!ignoreInitBreakpointsListeners) {
            this.initBreakpoints();
            Class<?> c = breakpoint.getClass();
            ClassLoader cl = c.getClassLoader();
            Map<ClassLoader, Set<Breakpoint>> map = this.breakpointsByClassLoaders;
            synchronized (map) {
                Set<Breakpoint> lb = this.breakpointsByClassLoaders.get(cl);
                if (lb != null) {
                    lb.remove(breakpoint);
                    if (lb.isEmpty()) {
                        this.breakpointsByClassLoaders.remove(cl);
                    }
                }
            }
            this.breakpoints.removeElement(breakpoint);
            breakpoint.disposeOut();
        } else {
            this.breakpoints.removeElement(breakpoint);
            breakpoint.dispose();
        }
        this.fireBreakpointRemoved(breakpoint, ignoreInitBreakpointsListeners, null);
    }

    public Breakpoint[] getBreakpoints() {
        this.initBreakpoints();
        return this.breakpoints.toArray(new Breakpoint[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleUnloaded(ClassLoader cl) {
        Set<Breakpoint> lb;
        Map<ClassLoader, Set<Breakpoint>> map = this.breakpointsByClassLoaders;
        synchronized (map) {
            lb = this.breakpointsByClassLoaders.remove(cl);
        }
        if (lb == null) {
            return;
        }
        for (Breakpoint b : lb) {
            this.removeBreakpoint(b, true);
        }
    }

    public Watch createWatch(String expr) {
        Watch w = new Watch(expr);
        if (Boolean.TRUE.equals(this.watchesInitializing.get())) {
            this.watches.addElement(w);
        } else {
            this.initWatches();
            this.watches.addElement(w);
            this.fireWatchCreated(w);
        }
        return w;
    }

    public Watch createWatch(int index, String expr) {
        Watch w = new Watch(expr);
        if (Boolean.TRUE.equals(this.watchesInitializing.get())) {
            this.watches.add(index, w);
        } else {
            this.initWatches();
            this.watches.add(index, w);
            this.fireWatchCreated(w);
        }
        return w;
    }

    public Watch createPinnedWatch(String expr, Watch.Pin pin) {
        Watch w = new Watch(expr, pin);
        if (Boolean.TRUE.equals(this.watchesInitializing.get())) {
            this.watches.addElement(w);
        } else {
            this.initWatches();
            this.watches.addElement(w);
            this.fireWatchCreated(w);
        }
        return w;
    }

    public Watch[] getWatches() {
        this.initWatches();
        return this.watches.toArray(new Watch[0]);
    }

    public void removeAllWatches() {
        this.initWatches();
        Vector v = (Vector)this.watches.clone();
        int k = v.size();
        for (int i = k - 1; i >= 0; --i) {
            ((Watch)v.elementAt(i)).remove();
        }
    }

    void removeWatch(Watch w) {
        this.initWatches();
        this.watches.removeElement(w);
        this.fireWatchRemoved(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reorderWatches(int[] permutation) throws IllegalArgumentException {
        Vector<Watch> vector = this.watches;
        synchronized (vector) {
            if (permutation.length != this.watches.size()) {
                throw new IllegalArgumentException("Permutation of length " + permutation.length + ", but have " + this.watches.size() + " watches.");
            }
            DebuggerManager.checkPermutation(permutation);
            Vector<Watch> v = new Vector<Watch>(this.watches);
            for (int i = 0; i < v.size(); ++i) {
                this.watches.set(permutation[i], v.get(i));
            }
        }
    }

    private static void checkPermutation(int[] permutation) throws IllegalArgumentException {
        int max = permutation.length;
        int[] check = new int[max];
        for (int i = 0; i < max; ++i) {
            int p = permutation[i];
            if (p >= max) {
                throw new IllegalArgumentException("Permutation " + Arrays.toString(permutation) + " is not a valid permutation, it contains element " + p + ", which is bigger than the length of the permutation.");
            }
            if (p < 0) {
                throw new IllegalArgumentException("Permutation " + Arrays.toString(permutation) + " is not a valid permutation, it contains element " + p + ", which is negative.");
            }
            if (check[p] != 0) {
                throw new IllegalArgumentException("Permutation " + Arrays.toString(permutation) + " is not a valid permutation, it contains element " + p + " twice or more times.");
            }
            check[p] = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(String name, Object o, Object n) {
        int i;
        Vector l1;
        this.initDebuggerManagerListeners();
        Vector l = (Vector)this.listeners.clone();
        Map<String, Vector<DebuggerManagerListener>> map = this.listenersMap;
        synchronized (map) {
            l1 = this.listenersMap.get(name);
            if (l1 != null) {
                l1 = (Vector)l1.clone();
            }
        }
        PropertyChangeEvent ev = new PropertyChangeEvent(this, name, o, n);
        int k = l.size();
        for (i = 0; i < k; ++i) {
            try {
                ((DebuggerManagerListener)l.elementAt(i)).propertyChange(ev);
                continue;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                try {
                    ((DebuggerManagerListener)l1.elementAt(i)).propertyChange(ev);
                    continue;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public void addDebuggerListener(DebuggerManagerListener l) {
        this.listeners.addElement(l);
    }

    public void removeDebuggerListener(DebuggerManagerListener l) {
        this.listeners.removeElement(l);
    }

    private void removeDebuggerManagerListener(DebuggerManagerListener l) {
        this.listeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebuggerListener(String propertyName, DebuggerManagerListener l) {
        Map<String, Vector<DebuggerManagerListener>> map = this.listenersMap;
        synchronized (map) {
            Vector<DebuggerManagerListener> listeners = this.listenersMap.get(propertyName);
            if (listeners == null) {
                listeners = new Vector();
                this.listenersMap.put(propertyName, listeners);
            }
            listeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebuggerListener(String propertyName, DebuggerManagerListener l) {
        Map<String, Vector<DebuggerManagerListener>> map = this.listenersMap;
        synchronized (map) {
            Vector<DebuggerManagerListener> listeners = this.listenersMap.get(propertyName);
            if (listeners == null) {
                return;
            }
            listeners.removeElement(l);
            if (listeners.size() == 0) {
                this.listenersMap.remove(propertyName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBreakpointCreated(Breakpoint breakpoint, DebuggerManagerListener originatingListener) {
        Vector l1;
        int i;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent ev = new PropertyChangeEvent(this, PROP_BREAKPOINTS, null, null);
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (i = 0; i < k; ++i) {
            DebuggerManagerListener dl = (DebuggerManagerListener)l.elementAt(i);
            if (dl == originatingListener) continue;
            try {
                dl.breakpointAdded(breakpoint);
                dl.propertyChange(ev);
                continue;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        Map<String, Vector<DebuggerManagerListener>> ex = this.listenersMap;
        synchronized (ex) {
            l1 = this.listenersMap.get(PROP_BREAKPOINTS);
            if (l1 != null) {
                l1 = (Vector)l1.clone();
            }
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                DebuggerManagerListener dl = (DebuggerManagerListener)l1.elementAt(i);
                if (dl == originatingListener) continue;
                try {
                    dl.breakpointAdded(breakpoint);
                    dl.propertyChange(ev);
                    continue;
                }
                catch (Exception ex2) {
                    Exceptions.printStackTrace((Throwable)ex2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBreakpointRemoved(Breakpoint breakpoint, boolean ignoreInitBreakpointsListeners, DebuggerManagerListener ignoredListener) {
        Vector l1;
        int i;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent ev = new PropertyChangeEvent(this, PROP_BREAKPOINTS, null, null);
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (i = 0; i < k; ++i) {
            DebuggerManagerListener ml = (DebuggerManagerListener)l.elementAt(i);
            if (ml == ignoredListener) continue;
            try {
                Breakpoint[] bps;
                if (ignoreInitBreakpointsListeners && (bps = ml.initBreakpoints()) != null && bps.length > 0) continue;
                ml.breakpointRemoved(breakpoint);
                ml.propertyChange(ev);
                continue;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
        }
        Map<String, Vector<DebuggerManagerListener>> t = this.listenersMap;
        synchronized (t) {
            l1 = this.listenersMap.get(PROP_BREAKPOINTS);
            if (l1 != null) {
                l1 = (Vector)l1.clone();
            }
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                DebuggerManagerListener ml = (DebuggerManagerListener)l1.elementAt(i);
                if (ml == ignoredListener) continue;
                try {
                    Breakpoint[] bps;
                    if (ignoreInitBreakpointsListeners && (bps = ml.initBreakpoints()) != null && bps.length > 0) continue;
                    ml.breakpointRemoved(breakpoint);
                    ml.propertyChange(ev);
                    continue;
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t2) {
                    Exceptions.printStackTrace((Throwable)t2);
                }
            }
        }
    }

    private void initBreakpoints() {
        this.initBreakpoints(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initBreakpoints(Breakpoint newBreakpoint) {
        List<Breakpoint> breakpointsToAdd;
        HashMap<Breakpoint, DebuggerManagerListener> originatingListeners;
        Vector<Breakpoint> vector = this.breakpoints;
        synchronized (vector) {
            if (this.breakpointsInitialized) {
                return true;
            }
            if (this.breakpointsInitializing) {
                if (newBreakpoint != null) {
                    this.createdBreakpoints.add(newBreakpoint);
                    return false;
                }
                throw new IllegalStateException("Breakpoints not yet initialized and tried to initialize again...");
            }
            this.breakpointsInitializing = true;
            try {
                Breakpoint[] bkpts;
                int i;
                this.initDebuggerManagerListeners();
                this.createdBreakpoints = new ArrayList<Breakpoint>();
                originatingListeners = new HashMap<Breakpoint, DebuggerManagerListener>();
                Vector l = (Vector)this.listeners.clone();
                int k = l.size();
                for (i = 0; i < k; ++i) {
                    DebuggerManagerListener dl = (DebuggerManagerListener)l.elementAt(i);
                    bkpts = DebuggerManager.getInitialBreakpoints(dl);
                    if (bkpts == null) continue;
                    this.createdBreakpoints.addAll(Arrays.asList(bkpts));
                    for (int j = 0; j < bkpts.length; ++j) {
                        originatingListeners.put(bkpts[j], dl);
                    }
                }
                bkpts = this.listenersMap;
                synchronized (this.listenersMap) {
                    Vector l1 = this.listenersMap.get(PROP_BREAKPOINTS_INIT);
                    if (l1 != null) {
                        l1 = (Vector)l1.clone();
                    }
                    // ** MonitorExit[bkpts] (shouldn't be in output)
                    if (l1 != null) {
                        k = l1.size();
                        for (i = 0; i < k; ++i) {
                            DebuggerManagerListener dl = (DebuggerManagerListener)l1.elementAt(i);
                            Breakpoint[] bkpts2 = DebuggerManager.getInitialBreakpoints(dl);
                            if (bkpts2 == null) continue;
                            this.createdBreakpoints.addAll(Arrays.asList(bkpts2));
                            for (int j = 0; j < bkpts2.length; ++j) {
                                originatingListeners.put(bkpts2[j], dl);
                            }
                        }
                    }
                    this.breakpoints.addAll(this.createdBreakpoints);
                }
            }
            finally {
                this.breakpointsInitializing = false;
            }
            {
                this.breakpointsInitialized = true;
                breakpointsToAdd = this.createdBreakpoints;
                this.createdBreakpoints = null;
            }
        }
        {
            for (Breakpoint bp : breakpointsToAdd) {
                this.registerBreakpoint(bp);
                this.fireBreakpointCreated(bp, (DebuggerManagerListener)originatingListeners.get(bp));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBreakpoints(DebuggerManagerListener dl) {
        List<Breakpoint> breakpointsToAdd;
        if (!this.breakpointsInitialized) {
            return;
        }
        HashMap<Breakpoint, DebuggerManagerListener> originatingListeners = new HashMap<Breakpoint, DebuggerManagerListener>();
        Vector<Breakpoint> vector = this.breakpoints;
        synchronized (vector) {
            this.breakpointsInitialized = false;
            this.breakpointsInitializing = true;
            try {
                this.createdBreakpoints = new ArrayList<Breakpoint>();
                Breakpoint[] bps = DebuggerManager.getInitialBreakpoints(dl);
                if (bps != null) {
                    this.createdBreakpoints.addAll(Arrays.asList(bps));
                    for (int j = 0; j < bps.length; ++j) {
                        originatingListeners.put(bps[j], dl);
                    }
                }
                this.breakpoints.addAll(this.createdBreakpoints);
            }
            finally {
                this.breakpointsInitializing = false;
                this.breakpointsInitialized = true;
            }
            breakpointsToAdd = this.createdBreakpoints;
            this.createdBreakpoints = null;
        }
        for (Breakpoint bp : breakpointsToAdd) {
            this.registerBreakpoint(bp);
            this.fireBreakpointCreated(bp, (DebuggerManagerListener)originatingListeners.get(bp));
        }
    }

    private static Breakpoint[] getInitialBreakpoints(DebuggerManagerListener dl) {
        Breakpoint[] bps;
        try {
            bps = dl.initBreakpoints();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            Exceptions.printStackTrace((Throwable)t);
            bps = null;
        }
        if (bps == null) {
            return null;
        }
        int nn = 0;
        for (int i = 0; i < bps.length; ++i) {
            if (bps[i] != null) continue;
            ++nn;
        }
        if (nn > 0) {
            if (nn == bps.length) {
                return null;
            }
            Breakpoint[] bps2 = new Breakpoint[bps.length - nn];
            int j = 0;
            for (int i = 0; i < bps.length; ++i) {
                if (bps[i] == null) continue;
                bps2[j] = bps[i];
                ++j;
            }
            bps = bps2;
        }
        return bps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBreakpoints(DebuggerManagerListener dl) {
        Breakpoint[] bps;
        if (!this.breakpointsInitialized) {
            return;
        }
        try {
            Method unloadMethod = dl.getClass().getMethod("unloadBreakpoints", new Class[0]);
            bps = (Breakpoint[])unloadMethod.invoke((Object)dl, new Object[0]);
        }
        catch (IllegalAccessException iaex) {
            return;
        }
        catch (IllegalArgumentException iaex) {
            return;
        }
        catch (NoSuchMethodException iaex) {
            return;
        }
        catch (SecurityException iaex) {
            return;
        }
        catch (InvocationTargetException iaex) {
            Exceptions.printStackTrace((Throwable)iaex.getTargetException());
            return;
        }
        this.breakpoints.removeAll(Arrays.asList(bps));
        for (Breakpoint breakpoint : bps) {
            Class<?> c = breakpoint.getClass();
            ClassLoader cl = c.getClassLoader();
            Map<ClassLoader, Set<Breakpoint>> map = this.breakpointsByClassLoaders;
            synchronized (map) {
                Set<Breakpoint> lb = this.breakpointsByClassLoaders.get(cl);
                if (lb != null) {
                    lb.remove(breakpoint);
                    if (lb.isEmpty()) {
                        this.breakpointsByClassLoaders.remove(cl);
                    }
                }
            }
            breakpoint.disposeOut();
        }
        for (Breakpoint bp : bps) {
            this.fireBreakpointRemoved(bp, false, dl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWatchCreated(Watch watch) {
        Vector l1;
        int i;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent ev = new PropertyChangeEvent(this, PROP_WATCHES, null, null);
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (i = 0; i < k; ++i) {
            try {
                ((DebuggerManagerListener)l.elementAt(i)).watchAdded(watch);
                ((DebuggerManagerListener)l.elementAt(i)).propertyChange(ev);
                continue;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        Map<String, Vector<DebuggerManagerListener>> map = this.listenersMap;
        synchronized (map) {
            l1 = this.listenersMap.get(PROP_WATCHES);
            if (l1 != null) {
                l1 = (Vector)l1.clone();
            }
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                try {
                    ((DebuggerManagerListener)l1.elementAt(i)).watchAdded(watch);
                    ((DebuggerManagerListener)l1.elementAt(i)).propertyChange(ev);
                    continue;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWatchRemoved(Watch watch) {
        Vector l1;
        int i;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent ev = new PropertyChangeEvent(this, PROP_WATCHES, null, null);
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (i = 0; i < k; ++i) {
            try {
                ((DebuggerManagerListener)l.elementAt(i)).watchRemoved(watch);
                ((DebuggerManagerListener)l.elementAt(i)).propertyChange(ev);
                continue;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        Map<String, Vector<DebuggerManagerListener>> map = this.listenersMap;
        synchronized (map) {
            l1 = this.listenersMap.get(PROP_WATCHES);
            if (l1 != null) {
                l1 = (Vector)l1.clone();
            }
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                try {
                    ((DebuggerManagerListener)l1.elementAt(i)).watchRemoved(watch);
                    ((DebuggerManagerListener)l1.elementAt(i)).propertyChange(ev);
                    continue;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWatches() {
        this.initDebuggerManagerListeners();
        Vector<Watch> vector = this.watches;
        synchronized (vector) {
            if (this.watchesInitialized) {
                return;
            }
            this.watchesInitialized = true;
            try {
                Vector l1;
                int i;
                this.watchesInitializing.set(Boolean.TRUE);
                PropertyChangeEvent ev = new PropertyChangeEvent(this, PROP_WATCHES_INIT, null, null);
                Vector l = (Vector)this.listeners.clone();
                int k = l.size();
                for (i = 0; i < k; ++i) {
                    try {
                        ((DebuggerManagerListener)l.elementAt(i)).initWatches();
                        ((DebuggerManagerListener)l.elementAt(i)).propertyChange(ev);
                        continue;
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                Map<String, Vector<DebuggerManagerListener>> map = this.listenersMap;
                synchronized (map) {
                    l1 = this.listenersMap.get(PROP_WATCHES_INIT);
                    if (l1 != null) {
                        l1 = (Vector)l1.clone();
                    }
                }
                if (l1 != null) {
                    k = l1.size();
                    for (i = 0; i < k; ++i) {
                        try {
                            ((DebuggerManagerListener)l1.elementAt(i)).initWatches();
                            ((DebuggerManagerListener)l1.elementAt(i)).propertyChange(ev);
                            continue;
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
            finally {
                this.watchesInitializing.set(Boolean.FALSE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSessionAdded(Session session, Session[] old, Session[] ne) {
        Vector l1;
        int i;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent ev = new PropertyChangeEvent(this, PROP_SESSIONS, old, ne);
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (i = 0; i < k; ++i) {
            try {
                ((DebuggerManagerListener)l.elementAt(i)).sessionAdded(session);
                ((DebuggerManagerListener)l.elementAt(i)).propertyChange(ev);
                continue;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        Map<String, Vector<DebuggerManagerListener>> map = this.listenersMap;
        synchronized (map) {
            l1 = this.listenersMap.get(PROP_SESSIONS);
            if (l1 != null) {
                l1 = (Vector)l1.clone();
            }
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                try {
                    ((DebuggerManagerListener)l1.elementAt(i)).sessionAdded(session);
                    ((DebuggerManagerListener)l1.elementAt(i)).propertyChange(ev);
                    continue;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSessionRemoved(Session session, Session[] old, Session[] ne) {
        Vector l1;
        int i;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent ev = new PropertyChangeEvent(this, PROP_SESSIONS, old, ne);
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (i = 0; i < k; ++i) {
            try {
                ((DebuggerManagerListener)l.elementAt(i)).sessionRemoved(session);
                ((DebuggerManagerListener)l.elementAt(i)).propertyChange(ev);
                continue;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        Map<String, Vector<DebuggerManagerListener>> map = this.listenersMap;
        synchronized (map) {
            l1 = this.listenersMap.get(PROP_SESSIONS);
            if (l1 != null) {
                l1 = (Vector)l1.clone();
            }
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                try {
                    ((DebuggerManagerListener)l1.elementAt(i)).sessionRemoved(session);
                    ((DebuggerManagerListener)l1.elementAt(i)).propertyChange(ev);
                    continue;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEngineAdded(DebuggerEngine engine, DebuggerEngine[] old, DebuggerEngine[] ne) {
        Vector l1;
        int i;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent ev = new PropertyChangeEvent(this, PROP_DEBUGGER_ENGINES, old, ne);
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (i = 0; i < k; ++i) {
            try {
                ((DebuggerManagerListener)l.elementAt(i)).engineAdded(engine);
                ((DebuggerManagerListener)l.elementAt(i)).propertyChange(ev);
                continue;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        Map<String, Vector<DebuggerManagerListener>> map = this.listenersMap;
        synchronized (map) {
            l1 = this.listenersMap.get(PROP_DEBUGGER_ENGINES);
            if (l1 != null) {
                l1 = (Vector)l1.clone();
            }
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                try {
                    ((DebuggerManagerListener)l1.elementAt(i)).engineAdded(engine);
                    ((DebuggerManagerListener)l1.elementAt(i)).propertyChange(ev);
                    continue;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEngineRemoved(DebuggerEngine engine, DebuggerEngine[] old, DebuggerEngine[] ne) {
        Vector l1;
        int i;
        this.initDebuggerManagerListeners();
        PropertyChangeEvent ev = new PropertyChangeEvent(this, PROP_DEBUGGER_ENGINES, old, ne);
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (i = 0; i < k; ++i) {
            try {
                ((DebuggerManagerListener)l.elementAt(i)).engineRemoved(engine);
                ((DebuggerManagerListener)l.elementAt(i)).propertyChange(ev);
                continue;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        Map<String, Vector<DebuggerManagerListener>> map = this.listenersMap;
        synchronized (map) {
            l1 = this.listenersMap.get(PROP_DEBUGGER_ENGINES);
            if (l1 != null) {
                l1 = (Vector)l1.clone();
            }
        }
        if (l1 != null) {
            k = l1.size();
            for (i = 0; i < k; ++i) {
                try {
                    ((DebuggerManagerListener)l1.elementAt(i)).engineRemoved(engine);
                    ((DebuggerManagerListener)l1.elementAt(i)).propertyChange(ev);
                    continue;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDebuggerManagerListeners() {
        Object object = this.loadedListenersLock;
        synchronized (object) {
            if (this.loadedListeners == null) {
                this.loadedListeners = new HashSet<LazyDebuggerManagerListener>();
                this.listenersLookupList = this.lookup.lookup(null, LazyDebuggerManagerListener.class);
                this.refreshDebuggerManagerListeners(this.listenersLookupList);
                ((Customizer)((Object)this.listenersLookupList)).addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        DebuggerManager.this.refreshDebuggerManagerListeners((List)evt.getSource());
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDebuggerManagerListeners(List<? extends LazyDebuggerManagerListener> listenersLookupList) {
        HashSet<LazyDebuggerManagerListener> addedInitBreakpointsListeners = new HashSet<LazyDebuggerManagerListener>();
        List<? extends LazyDebuggerManagerListener> list = listenersLookupList;
        synchronized (list) {
            int k = listenersLookupList.size();
            for (int i = 0; i < k; ++i) {
                LazyDebuggerManagerListener l = listenersLookupList.get(i);
                if (!this.loadedListeners.add(l)) continue;
                String[] props = l.getProperties();
                if (props == null || props.length == 0) {
                    this.addDebuggerListener(l);
                } else {
                    int jj = props.length;
                    for (int j = 0; j < jj; ++j) {
                        this.addDebuggerListener(props[j], l);
                    }
                }
                addedInitBreakpointsListeners.add(l);
            }
            HashSet<LazyDebuggerManagerListener> listenersToRemove = new HashSet<LazyDebuggerManagerListener>(this.loadedListeners);
            listenersToRemove.removeAll(listenersLookupList);
            for (LazyDebuggerManagerListener l : listenersToRemove) {
                if (!this.loadedListeners.contains(l)) continue;
                this.removeBreakpoints(l);
            }
            for (LazyDebuggerManagerListener l : listenersToRemove) {
                if (!this.loadedListeners.remove(l)) continue;
                this.moduleUnloaded(l.getClass().getClassLoader());
                String[] props = l.getProperties();
                if (props == null || props.length == 0) {
                    this.removeDebuggerListener(l);
                    continue;
                }
                int jj = props.length;
                for (int j = 0; j < jj; ++j) {
                    this.removeDebuggerListener(props[j], l);
                }
            }
        }
        for (LazyDebuggerManagerListener l : addedInitBreakpointsListeners) {
            this.addBreakpoints(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(Session session) {
        Session[] newSessions;
        Session[] oldSessions;
        List<Session> list = this.sessions;
        synchronized (list) {
            oldSessions = this.getSessions();
            int k = oldSessions.length;
            for (int i = 0; i < k; ++i) {
                if (session != oldSessions[i]) continue;
                return;
            }
            newSessions = new Session[oldSessions.length + 1];
            System.arraycopy(oldSessions, 0, newSessions, 0, oldSessions.length);
            newSessions[oldSessions.length] = session;
            this.sessions.add(session);
            session.addPropertyChangeListener(this.sessionListener);
        }
        this.fireSessionAdded(session, oldSessions, newSessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(Session session) {
        Session[] newSessions;
        Session[] oldSessions;
        Session nCurrentSesson = null;
        List<Session> list = this.sessions;
        synchronized (list) {
            int i;
            oldSessions = this.getSessions();
            int k = oldSessions.length;
            for (i = 0; i < k && oldSessions[i] != session; ++i) {
                if (nCurrentSesson != null) continue;
                nCurrentSesson = oldSessions[i];
            }
            if (i == k) {
                return;
            }
            if (session == this.getCurrentSession()) {
                if (nCurrentSesson == null && k > 1) {
                    nCurrentSesson = oldSessions[1];
                }
            } else {
                nCurrentSesson = this.getCurrentSession();
            }
            newSessions = new Session[oldSessions.length - 1];
            System.arraycopy(oldSessions, 0, newSessions, 0, i);
            if (oldSessions.length - i > 1) {
                System.arraycopy(oldSessions, i + 1, newSessions, i, oldSessions.length - i - 1);
            }
            this.sessions.remove(i);
            session.removePropertyChangeListener(this.sessionListener);
        }
        this.setCurrentSession(nCurrentSesson);
        this.fireSessionRemoved(session, oldSessions, newSessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEngine(DebuggerEngine engine) {
        DebuggerEngine[] ne;
        DebuggerEngine[] old;
        Set set = this.engines;
        synchronized (set) {
            if (this.engines.contains(engine)) {
                return;
            }
            old = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
            this.engines.add(engine);
            ne = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
        }
        this.fireEngineAdded(engine, old, ne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEngine(DebuggerEngine engine) {
        DebuggerEngine[] ne;
        DebuggerEngine[] old;
        Set set = this.engines;
        synchronized (set) {
            if (!this.engines.contains(engine)) {
                return;
            }
            old = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
            this.engines.remove(engine);
            ne = this.engines.toArray(new DebuggerEngine[this.engines.size()]);
        }
        this.fireEngineRemoved(engine, old, ne);
    }

    private class SessionListener
    implements PropertyChangeListener {
        private SessionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() instanceof Session) {
                Session s;
                DebuggerEngine newEngine;
                DebuggerEngine oldEngine;
                if (!e.getPropertyName().equals("currentLanguage") && !e.getPropertyName().equals("supportedLanguages")) {
                    return;
                }
                List list = DebuggerManager.this.sessions;
                synchronized (list) {
                    oldEngine = DebuggerManager.this.currentEngine;
                    newEngine = null;
                    if (DebuggerManager.this.getCurrentSession() != null) {
                        newEngine = DebuggerManager.this.getCurrentSession().getCurrentEngine();
                    }
                    DebuggerManager.this.currentEngine = newEngine;
                }
                if (newEngine != oldEngine) {
                    DebuggerManager.this.firePropertyChange(DebuggerManager.PROP_CURRENT_ENGINE, oldEngine, newEngine);
                }
                if ((s = (Session)e.getSource()).getSupportedLanguages().length == 0) {
                    DebuggerManager.this.removeSession(s);
                }
            }
        }
    }
}

