/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CancelWorkRequestRequest
extends BmcRequest<Void> {
    private String workRequestId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"workRequestId", "ifMatch", "opcRequestId"})
    CancelWorkRequestRequest(String workRequestId, String ifMatch, String opcRequestId) {
        this.workRequestId = workRequestId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().workRequestId(this.workRequestId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "CancelWorkRequestRequest(super=" + super.toString() + ", workRequestId=" + this.getWorkRequestId() + ", ifMatch=" + this.getIfMatch() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelWorkRequestRequest)) {
            return false;
        }
        CancelWorkRequestRequest other = (CancelWorkRequestRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$workRequestId = this.getWorkRequestId();
        String other$workRequestId = other.getWorkRequestId();
        if (this$workRequestId == null ? other$workRequestId != null : !this$workRequestId.equals(other$workRequestId)) {
            return false;
        }
        String this$ifMatch = this.getIfMatch();
        String other$ifMatch = other.getIfMatch();
        if (this$ifMatch == null ? other$ifMatch != null : !this$ifMatch.equals(other$ifMatch)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CancelWorkRequestRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $workRequestId = this.getWorkRequestId();
        result = result * 59 + ($workRequestId == null ? 43 : $workRequestId.hashCode());
        String $ifMatch = this.getIfMatch();
        result = result * 59 + ($ifMatch == null ? 43 : $ifMatch.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<CancelWorkRequestRequest, Void> {
        private String workRequestId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelWorkRequestRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelWorkRequestRequest build() {
            CancelWorkRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public CancelWorkRequestRequest buildWithoutInvocationCallback() {
            return new CancelWorkRequestRequest(this.workRequestId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "CancelWorkRequestRequest.Builder(workRequestId=" + this.workRequestId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

