/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.adm.model.SortOrder;
import com.oracle.bmc.adm.model.VulnerabilityAudit;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListVulnerabilityAuditsRequest
extends BmcRequest<Void> {
    private String id;
    private String compartmentId;
    private String knowledgeBaseId;
    private Boolean isSuccess;
    private VulnerabilityAudit.LifecycleState lifecycleState;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private SortBy sortBy;
    private String displayName;

    @ConstructorProperties(value={"id", "compartmentId", "knowledgeBaseId", "isSuccess", "lifecycleState", "sortOrder", "limit", "page", "opcRequestId", "sortBy", "displayName"})
    ListVulnerabilityAuditsRequest(String id, String compartmentId, String knowledgeBaseId, Boolean isSuccess, VulnerabilityAudit.LifecycleState lifecycleState, SortOrder sortOrder, Integer limit, String page, String opcRequestId, SortBy sortBy, String displayName) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.knowledgeBaseId = knowledgeBaseId;
        this.isSuccess = isSuccess;
        this.lifecycleState = lifecycleState;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
        this.sortBy = sortBy;
        this.displayName = displayName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).compartmentId(this.compartmentId).knowledgeBaseId(this.knowledgeBaseId).isSuccess(this.isSuccess).lifecycleState(this.lifecycleState).sortOrder(this.sortOrder).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).sortBy(this.sortBy).displayName(this.displayName);
    }

    public String toString() {
        return "ListVulnerabilityAuditsRequest(super=" + super.toString() + ", id=" + this.getId() + ", compartmentId=" + this.getCompartmentId() + ", knowledgeBaseId=" + this.getKnowledgeBaseId() + ", isSuccess=" + this.getIsSuccess() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", opcRequestId=" + this.getOpcRequestId() + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", displayName=" + this.getDisplayName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListVulnerabilityAuditsRequest)) {
            return false;
        }
        ListVulnerabilityAuditsRequest other = (ListVulnerabilityAuditsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isSuccess = this.getIsSuccess();
        Boolean other$isSuccess = other.getIsSuccess();
        if (this$isSuccess == null ? other$isSuccess != null : !((Object)this$isSuccess).equals(other$isSuccess)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$knowledgeBaseId = this.getKnowledgeBaseId();
        String other$knowledgeBaseId = other.getKnowledgeBaseId();
        if (this$knowledgeBaseId == null ? other$knowledgeBaseId != null : !this$knowledgeBaseId.equals(other$knowledgeBaseId)) {
            return false;
        }
        VulnerabilityAudit.LifecycleState this$lifecycleState = this.getLifecycleState();
        VulnerabilityAudit.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListVulnerabilityAuditsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isSuccess = this.getIsSuccess();
        result = result * 59 + ($isSuccess == null ? 43 : ((Object)$isSuccess).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $knowledgeBaseId = this.getKnowledgeBaseId();
        result = result * 59 + ($knowledgeBaseId == null ? 43 : $knowledgeBaseId.hashCode());
        VulnerabilityAudit.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public Boolean getIsSuccess() {
        return this.isSuccess;
    }

    public VulnerabilityAudit.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static class Builder
    implements BmcRequest.Builder<ListVulnerabilityAuditsRequest, Void> {
        private String id;
        private String compartmentId;
        private String knowledgeBaseId;
        private Boolean isSuccess;
        private VulnerabilityAudit.LifecycleState lifecycleState;
        private SortOrder sortOrder;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private SortBy sortBy;
        private String displayName;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListVulnerabilityAuditsRequest o) {
            this.id(o.getId());
            this.compartmentId(o.getCompartmentId());
            this.knowledgeBaseId(o.getKnowledgeBaseId());
            this.isSuccess(o.getIsSuccess());
            this.lifecycleState(o.getLifecycleState());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.sortBy(o.getSortBy());
            this.displayName(o.getDisplayName());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListVulnerabilityAuditsRequest build() {
            ListVulnerabilityAuditsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public Builder isSuccess(Boolean isSuccess) {
            this.isSuccess = isSuccess;
            return this;
        }

        public Builder lifecycleState(VulnerabilityAudit.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ListVulnerabilityAuditsRequest buildWithoutInvocationCallback() {
            return new ListVulnerabilityAuditsRequest(this.id, this.compartmentId, this.knowledgeBaseId, this.isSuccess, this.lifecycleState, this.sortOrder, this.limit, this.page, this.opcRequestId, this.sortBy, this.displayName);
        }

        public String toString() {
            return "ListVulnerabilityAuditsRequest.Builder(id=" + this.id + ", compartmentId=" + this.compartmentId + ", knowledgeBaseId=" + this.knowledgeBaseId + ", isSuccess=" + this.isSuccess + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ", sortBy=" + (Object)((Object)this.sortBy) + ", displayName=" + this.displayName + ")";
        }
    }

    public static enum SortBy {
        MaxObservedCvssV2Score("maxObservedCvssV2Score"),
        MaxObservedCvssV3Score("maxObservedCvssV3Score"),
        TimeCreated("timeCreated"),
        VulnerableArtifactsCount("vulnerableArtifactsCount");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

