/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.configurations;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.EditorKit;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.configurations.Bundle;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

public class NewConfigurationPanel
extends JPanel
implements DocumentListener {
    private final Supplier<Collection<? extends GradleExecConfiguration>> configProvider;
    private final Project project;
    private NotificationLineSupport notifications;
    private boolean valid;
    private JCheckBox cbPrivate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JTextField txId;
    private JTextField txLabel;
    private JEditorPane txParameters;
    private JEditorPane txProperties;

    public NewConfigurationPanel(Project project, Supplier<Collection<? extends GradleExecConfiguration>> confProvider, boolean isNew) {
        this.project = project;
        this.configProvider = confProvider;
        this.initComponents();
        EditorKit kit = CloneableEditorSupport.getEditorKit((String)"text/x-gradle-cli");
        this.txParameters.setEditorKit(kit);
        this.txParameters.getDocument().putProperty("gradle-project", project);
        if (isNew) {
            this.txId.getDocument().addDocumentListener(this);
            this.txId.getDocument().addDocumentListener(this);
        } else {
            this.txId.setEditable(false);
            this.txId.setEnabled(false);
        }
    }

    public void setDisplayName(String dn) {
        if (dn == null) {
            this.txLabel.setText("");
        } else {
            this.txLabel.setText(dn);
        }
    }

    public void setNotifications(NotificationLineSupport notifications) {
        this.notifications = notifications;
        this.check();
    }

    public String getConfigurationId() {
        return this.txId.getText().trim();
    }

    public String getLabel() {
        String l = this.txLabel.getText().trim();
        return l.isEmpty() ? null : l;
    }

    public void setConfigurationId(String configurationId) {
        this.txId.setText(configurationId);
    }

    public boolean isShared() {
        return !this.cbPrivate.isSelected();
    }

    public void setShared(boolean shared) {
        this.cbPrivate.setSelected(!shared);
    }

    public void setParameters(String parameters) {
        this.txParameters.setText(parameters);
    }

    public String getParameters() {
        String s = this.txParameters.getText().trim();
        return s.isEmpty() ? null : s;
    }

    public void setProfiles(List<String> profiles) {
        String val = "";
        if (profiles != null) {
            for (String prf : profiles) {
                val = val + prf + " ";
            }
        }
    }

    public void setProperties(Map<String, String> initProps) {
        String content = initProps == null || initProps.isEmpty() ? "" : String.join((CharSequence)"\n", initProps.entrySet().stream().map(e -> (String)e.getKey() + "=" + (e.getValue() == null ? "" : (String)e.getValue())).collect(Collectors.toList()));
        this.txProperties.setText(content);
    }

    public Map<String, String> getProperties() {
        String[] lines;
        LinkedHashMap<String, String> propList = new LinkedHashMap<String, String>();
        for (String l : lines = this.txProperties.getText().trim().split("\n")) {
            String v;
            String k;
            int eq = l.indexOf(61);
            if (eq == -1) {
                k = l.trim();
                v = "";
            } else {
                k = l.substring(0, eq).trim();
                v = l.substring(eq + 1);
            }
            if (k.isEmpty()) continue;
            propList.put(k, v);
        }
        return propList.isEmpty() ? null : propList;
    }

    public boolean isPanelValid() {
        return this.valid;
    }

    private void setPanelValid(boolean valid) {
        if (this.valid == valid) {
            return;
        }
        this.valid = valid;
        this.firePropertyChange("panelValid", !valid, valid);
    }

    private void check() {
        if (this.notifications == null) {
            return;
        }
        if (this.txId.isEditable()) {
            String id = this.txId.getText().trim();
            if (id.isEmpty()) {
                this.notifications.setErrorMessage(Bundle.ERR_ConfigurationIdEmpty());
                this.setPanelValid(false);
                return;
            }
            if (!FileUtil.isValidFileName((String)id)) {
                this.notifications.setErrorMessage(Bundle.ERR_ConfigurationIInvalid());
                this.setPanelValid(false);
                return;
            }
            Optional<GradleExecConfiguration> present = this.configProvider.get().stream().filter(c -> id.equalsIgnoreCase(c.getId())).findAny();
            if (present.isPresent()) {
                this.notifications.setErrorMessage(Bundle.ERR_ConfigurationIExists(present.get().getId()));
                this.setPanelValid(false);
                return;
            }
        }
        this.notifications.clearMessages();
        this.setPanelValid(true);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.check();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.check();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.check();
    }

    private void initComponents() {
        this.txId = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txLabel = new JTextField();
        this.cbPrivate = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.txProperties = new JEditorPane();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.txParameters = new JEditorPane();
        this.txId.setText(NbBundle.getMessage(NewConfigurationPanel.class, (String)"NewConfigurationPanel.txId.text"));
        this.jLabel1.setLabelFor(this.txId);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NewConfigurationPanel.class, (String)"NewConfigurationPanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.txLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NewConfigurationPanel.class, (String)"NewConfigurationPanel.jLabel2.text"));
        this.txLabel.setText(NbBundle.getMessage(NewConfigurationPanel.class, (String)"NewConfigurationPanel.txLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbPrivate, (String)NbBundle.getMessage(NewConfigurationPanel.class, (String)"NewConfigurationPanel.cbPrivate.text"));
        this.txProperties.setContentType("text/x-properties");
        this.jScrollPane1.setViewportView(this.txProperties);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(NewConfigurationPanel.class, (String)"NewConfigurationPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(NewConfigurationPanel.class, (String)"NewConfigurationPanel.jLabel4.text"));
        this.jScrollPane3.setViewportView(this.txParameters);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.txId).addComponent(this.txLabel).addGroup(layout.createSequentialGroup().addComponent(this.cbPrivate).addGap(0, 103, Short.MAX_VALUE)).addComponent(this.jScrollPane3)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txId, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txLabel, -2, -1, -2).addComponent(this.jLabel2, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPrivate).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 83, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jScrollPane3, -2, 40, -2)).addContainerGap(44, Short.MAX_VALUE)));
    }
}

