/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.spi.annotation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.csl.api.OffsetRange;
import org.openide.util.Parameters;

public interface AnnotationParsedLine {
    public String getName();

    public String getDescription();

    public Map<OffsetRange, String> getTypes();

    public boolean startsWithAnnotation();

    public static final class ParsedLine
    implements AnnotationParsedLine {
        private final String name;
        private final String description;
        private final Map<OffsetRange, String> types;
        private final boolean startsWithAnnotation;

        public ParsedLine(@NonNull String name) {
            this(name, null, null, false);
        }

        public ParsedLine(@NonNull String name, @NullAllowed Map<OffsetRange, String> types) {
            this(name, types, null, false);
        }

        public ParsedLine(@NonNull String name, @NullAllowed String description) {
            this(name, null, description, false);
        }

        public ParsedLine(@NonNull String name, @NullAllowed Map<OffsetRange, String> types, @NullAllowed String description) {
            this(name, types, description, false);
        }

        public ParsedLine(@NonNull String name, @NullAllowed Map<OffsetRange, String> types, @NullAllowed String description, boolean startsWithAnnotation) {
            Parameters.notNull((CharSequence)"name", (Object)name);
            this.name = name;
            this.types = types;
            this.description = description;
            this.startsWithAnnotation = startsWithAnnotation;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<OffsetRange, String> getTypes() {
            Map<OffsetRange, String> result = Collections.emptyMap();
            if (this.types != null) {
                result = new HashMap<OffsetRange, String>(this.types);
            }
            return result;
        }

        @Override
        public String getDescription() {
            String result = "";
            if (this.description != null) {
                result = this.description;
            }
            return result;
        }

        @Override
        public boolean startsWithAnnotation() {
            return this.startsWithAnnotation;
        }

        public boolean equals(@NullAllowed Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParsedLine other = (ParsedLine)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            return this.types == other.types || this.types != null && this.types.equals(other.types);
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 59 * hash + (this.description != null ? this.description.hashCode() : 0);
            hash = 59 * hash + (this.types != null ? this.types.hashCode() : 0);
            return hash;
        }
    }
}

